/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.atumvr.core.init;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import me.phoenixra.atumvr.api.exceptions.VRException;
import me.phoenixra.atumvr.core.OpenXRProvider;
import me.phoenixra.atumvr.core.OpenXRState;
import org.lwjgl.PointerBuffer;
import org.lwjgl.openxr.EXTDebugUtils;
import org.lwjgl.openxr.XR10;
import org.lwjgl.openxr.XrApplicationInfo;
import org.lwjgl.openxr.XrDebugUtilsMessengerCallbackDataEXT;
import org.lwjgl.openxr.XrDebugUtilsMessengerCallbackEXTI;
import org.lwjgl.openxr.XrDebugUtilsMessengerCreateInfoEXT;
import org.lwjgl.openxr.XrDebugUtilsMessengerEXT;
import org.lwjgl.openxr.XrEventDataBuffer;
import org.lwjgl.openxr.XrExtensionProperties;
import org.lwjgl.openxr.XrInstance;
import org.lwjgl.openxr.XrInstanceCreateInfo;
import org.lwjgl.openxr.XrInstanceProperties;
import org.lwjgl.system.MemoryStack;

public class OpenXRInstance {
    private static final String GRAPHICS_EXTENSION = "XR_KHR_opengl_enable";
    private final OpenXRState xrState;
    protected XrInstance handle;
    protected final XrEventDataBuffer xrEventBuffer;
    private String runtimeName;
    private long runtimeVersion;
    private String runtimeVersionString;
    private XrDebugUtilsMessengerEXT debugMessenger;

    public OpenXRInstance(OpenXRState xrState) {
        this.xrState = xrState;
        this.xrEventBuffer = XrEventDataBuffer.calloc();
    }

    public void init() {
        try (MemoryStack stack = MemoryStack.stackPush();){
            OpenXRProvider provider = this.xrState.getVrProvider();
            PointerBuffer extensionsPointer = this.setupExtensions(provider, stack);
            XrApplicationInfo appInfo = XrApplicationInfo.calloc((MemoryStack)stack).applicationName(stack.UTF8((CharSequence)provider.getAppName())).applicationVersion(1).engineName(stack.UTF8((CharSequence)"AtumEngine")).engineVersion(1).apiVersion(XR10.XR_MAKE_VERSION((int)1, (int)0, (int)40));
            XrInstanceCreateInfo instInfo = XrInstanceCreateInfo.calloc((MemoryStack)stack).type(3).next(0L).applicationInfo(appInfo).enabledExtensionNames(extensionsPointer).enabledApiLayerNames(null);
            PointerBuffer instancePointer = stack.callocPointer(1);
            int result = XR10.xrCreateInstance((XrInstanceCreateInfo)instInfo, (PointerBuffer)instancePointer);
            if (result == -2) {
                throw new VRException("Failed to create XrInstance: runtime failure (is headset connected?)");
            }
            if (result == -13) {
                throw new VRException("Failed to create XrInstance: instance lost during creation");
            }
            if (result != 0) {
                provider.checkXRError(result, "xrCreateInstance", "Failed to create XrInstance");
            }
            this.handle = new XrInstance(instancePointer.get(0), instInfo);
            if (this.handle.getCapabilities().XR_EXT_debug_utils) {
                this.setupDebugMessenger(provider, stack);
            }
            XrInstanceProperties properties = XrInstanceProperties.calloc((MemoryStack)stack).type$Default();
            provider.checkXRError(XR10.xrGetInstanceProperties((XrInstance)this.handle, (XrInstanceProperties)properties), "xrGetInstanceProperties", new String[0]);
            this.runtimeName = properties.runtimeNameString();
            this.runtimeVersion = properties.runtimeVersion();
            this.runtimeVersionString = XR10.XR_VERSION_MAJOR((long)this.runtimeVersion) + "." + XR10.XR_VERSION_MINOR((long)this.runtimeVersion) + "." + XR10.XR_VERSION_PATCH((long)this.runtimeVersion);
        }
    }

    private PointerBuffer setupExtensions(OpenXRProvider provider, MemoryStack stack) {
        IntBuffer extCountBuf = stack.callocInt(1);
        provider.checkXRError(XR10.xrEnumerateInstanceExtensionProperties((ByteBuffer)null, (IntBuffer)extCountBuf, null), "xrEnumerateInstanceExtensionProperties", "count");
        int extCount = extCountBuf.get(0);
        XrExtensionProperties.Buffer extProperties = XrExtensionProperties.calloc((int)extCount, (MemoryStack)stack);
        extProperties.forEach(prop -> prop.type(2));
        provider.checkXRError(XR10.xrEnumerateInstanceExtensionProperties((ByteBuffer)null, (IntBuffer)extCountBuf, (XrExtensionProperties.Buffer)extProperties), "xrEnumerateInstanceExtensionProperties", "properties");
        HashSet<String> availableExtensions = new HashSet<String>(extCount);
        for (XrExtensionProperties prop2 : extProperties) {
            availableExtensions.add(prop2.extensionNameString());
        }
        ArrayList<String> desiredExtensions = new ArrayList<String>(List.of(GRAPHICS_EXTENSION, "XR_EXT_debug_utils", "XR_FB_display_refresh_rate", "XR_KHR_visibility_mask"));
        desiredExtensions.addAll(provider.getXRAppExtensions());
        if (!availableExtensions.contains(GRAPHICS_EXTENSION)) {
            throw new VRException("Missing required graphics extension: XR_KHR_opengl_enable");
        }
        PointerBuffer enabledExtensions = stack.mallocPointer(desiredExtensions.size());
        for (String extName : desiredExtensions) {
            if (!availableExtensions.contains(extName)) continue;
            enabledExtensions.put(stack.UTF8((CharSequence)extName));
        }
        enabledExtensions.flip();
        return enabledExtensions;
    }

    private void setupDebugMessenger(OpenXRProvider provider, MemoryStack stack) {
        XrDebugUtilsMessengerCreateInfoEXT createInfo = XrDebugUtilsMessengerCreateInfoEXT.calloc((MemoryStack)stack).type$Default().messageSeverities(4369L).messageTypes(15L);
        XrDebugUtilsMessengerCallbackEXTI debugCallback = (messageSeverity, messageTypes, pCallbackData, pUserData) -> {
            XrDebugUtilsMessengerCallbackDataEXT data = XrDebugUtilsMessengerCallbackDataEXT.create((long)pCallbackData);
            provider.getLogger().logDebug(String.format("[OpenXR][%s] %s%n", data.functionNameString(), data.messageString()));
            return 0;
        };
        createInfo.userCallback(debugCallback).userData(0L);
        PointerBuffer pMessenger = stack.callocPointer(1);
        int err = EXTDebugUtils.xrCreateDebugUtilsMessengerEXT((XrInstance)this.handle, (XrDebugUtilsMessengerCreateInfoEXT)createInfo, (PointerBuffer)pMessenger);
        provider.checkXRError(err, "xrCreateDebugUtilsMessengerEXT", "");
        this.debugMessenger = new XrDebugUtilsMessengerEXT(pMessenger.get(0), this.handle);
    }

    public void destroy() {
        if (this.debugMessenger != null) {
            this.xrState.getVrProvider().checkXRError(false, EXTDebugUtils.xrDestroyDebugUtilsMessengerEXT((XrDebugUtilsMessengerEXT)this.debugMessenger), "xrDestroyDebugUtilsMessengerEXT", "");
        }
        if (this.handle != null) {
            this.xrState.getVrProvider().checkXRError(false, XR10.xrDestroyInstance((XrInstance)this.handle), "xrDestroyInstance", "");
        }
        this.xrEventBuffer.close();
    }

    public XrInstance getHandle() {
        return this.handle;
    }

    public XrEventDataBuffer getXrEventBuffer() {
        return this.xrEventBuffer;
    }

    public String getRuntimeName() {
        return this.runtimeName;
    }

    public long getRuntimeVersion() {
        return this.runtimeVersion;
    }

    public String getRuntimeVersionString() {
        return this.runtimeVersionString;
    }
}

