/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.atumvr.core.init;

import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.util.Iterator;
import java.util.List;
import me.phoenixra.atumvr.api.VRLogger;
import me.phoenixra.atumvr.core.OpenXRState;
import org.lwjgl.PointerBuffer;
import org.lwjgl.openxr.XR10;
import org.lwjgl.openxr.XrInstance;
import org.lwjgl.openxr.XrSession;
import org.lwjgl.openxr.XrSwapchain;
import org.lwjgl.openxr.XrSwapchainCreateInfo;
import org.lwjgl.openxr.XrSwapchainImageOpenGLKHR;
import org.lwjgl.openxr.XrView;
import org.lwjgl.openxr.XrViewConfigurationView;
import org.lwjgl.system.MemoryStack;

public class OpenXRSwapChain {
    private static final int VIEW_TYPE = 2;
    private final OpenXRState xrState;
    private final VRLogger LOG;
    private final List<Integer> desiredSwapChainFormats;
    private XrSwapchain handle;
    private XrView.Buffer xrViewBuffer;
    private int eyeMaxWidth;
    private int eyeMaxHeight;

    public OpenXRSwapChain(OpenXRState xrState) {
        this.xrState = xrState;
        this.LOG = xrState.getVrProvider().getLogger();
        this.desiredSwapChainFormats = xrState.getVrProvider().getSwapChainFormats();
    }

    public void init() {
        try (MemoryStack stack = MemoryStack.stackPush();){
            XrInstance instance = this.xrState.getVrInstance().getHandle();
            XrSession session = this.xrState.getVrSession().getHandle();
            long systemId = this.xrState.getVrSystem().getSystemId();
            int viewCount = this.enumerateViewCount(instance, systemId, stack);
            XrViewConfigurationView.Buffer viewConfigs = this.enumerateViewConfigs(instance, systemId, viewCount, stack);
            long chosenFormat = this.pickSwapchainFormat(session, stack);
            this.handle = this.createSwapchain(session, (XrViewConfigurationView)viewConfigs.get(0), chosenFormat, stack);
            this.eyeMaxWidth = ((XrViewConfigurationView)viewConfigs.get(0)).recommendedImageRectWidth();
            this.eyeMaxHeight = ((XrViewConfigurationView)viewConfigs.get(0)).recommendedImageRectHeight();
            this.xrViewBuffer = XrView.calloc((int)viewCount);
            for (int i = 0; i < viewCount; ++i) {
                ((XrView)this.xrViewBuffer.get(i)).type(7).next(0L);
            }
            this.LOG.logInfo(String.format("Swapchain created: %s\u00d7%s pixels, format 0x%s", this.eyeMaxWidth, this.eyeMaxHeight, Long.toHexString(chosenFormat)));
        }
    }

    private int enumerateViewCount(XrInstance instance, long systemId, MemoryStack stack) {
        IntBuffer countBuf = stack.callocInt(1);
        this.xrState.getVrProvider().checkXRError(XR10.xrEnumerateViewConfigurationViews((XrInstance)instance, (long)systemId, (int)2, (IntBuffer)countBuf, null), "xrEnumerateViewConfigurationViews", "count");
        return countBuf.get(0);
    }

    private XrViewConfigurationView.Buffer enumerateViewConfigs(XrInstance instance, long systemId, int viewCount, MemoryStack stack) {
        XrViewConfigurationView.Buffer configs = XrViewConfigurationView.calloc((int)viewCount, (MemoryStack)stack);
        for (int i = 0; i < viewCount; ++i) {
            ((XrViewConfigurationView)configs.get(i)).type(41).next(0L);
        }
        IntBuffer countBuf = stack.ints(viewCount);
        int err = XR10.xrEnumerateViewConfigurationViews((XrInstance)instance, (long)systemId, (int)2, (IntBuffer)countBuf, (XrViewConfigurationView.Buffer)configs);
        this.xrState.getVrProvider().checkXRError(err, "xrEnumerateViewConfigurationViews", "views");
        return configs;
    }

    private long pickSwapchainFormat(XrSession session, MemoryStack stack) {
        IntBuffer fmtCount = stack.callocInt(1);
        this.xrState.getVrProvider().checkXRError(XR10.xrEnumerateSwapchainFormats((XrSession)session, (IntBuffer)fmtCount, null), "xrEnumerateSwapchainFormats", "count");
        LongBuffer available = stack.callocLong(fmtCount.get(0));
        this.xrState.getVrProvider().checkXRError(XR10.xrEnumerateSwapchainFormats((XrSession)session, (IntBuffer)fmtCount, (LongBuffer)available), "xrEnumerateSwapchainFormats", "values");
        Iterator<Integer> iterator = this.desiredSwapChainFormats.iterator();
        while (iterator.hasNext()) {
            long want = iterator.next().intValue();
            for (int i = 0; i < available.capacity(); ++i) {
                if (available.get(i) != want) continue;
                this.LOG.logDebug(String.format("Selected swapchain format: 0x%s", Long.toHexString(want)));
                return want;
            }
        }
        throw new IllegalStateException("No compatible swapchain format found: " + available);
    }

    private XrSwapchain createSwapchain(XrSession session, XrViewConfigurationView viewConfig, long format, MemoryStack stack) {
        XrSwapchainCreateInfo info = XrSwapchainCreateInfo.calloc((MemoryStack)stack).type(9).next(0L).usageFlags(1L).format(format).sampleCount(1).width(viewConfig.recommendedImageRectWidth()).height(viewConfig.recommendedImageRectHeight()).faceCount(1).arraySize(2).mipCount(1);
        PointerBuffer handlePtr = stack.callocPointer(1);
        this.xrState.getVrProvider().checkXRError(XR10.xrCreateSwapchain((XrSession)session, (XrSwapchainCreateInfo)info, (PointerBuffer)handlePtr), "xrCreateSwapchain", "format: " + Long.toHexString(format));
        return new XrSwapchain(handlePtr.get(0), session);
    }

    public XrSwapchainImageOpenGLKHR.Buffer createImageBuffers(int imageCount, MemoryStack stack) {
        XrSwapchainImageOpenGLKHR.Buffer swapchainImageBuffer = XrSwapchainImageOpenGLKHR.calloc((int)imageCount, (MemoryStack)stack);
        for (XrSwapchainImageOpenGLKHR image : swapchainImageBuffer) {
            image.type(1000023004);
        }
        return swapchainImageBuffer;
    }

    public void destroy() {
        this.destroySwapchainQuietly();
        this.destroyViewBuffer();
    }

    private void destroySwapchainQuietly() {
        if (this.handle == null) {
            return;
        }
        int err = XR10.xrDestroySwapchain((XrSwapchain)this.handle);
        this.xrState.getVrProvider().checkXRError(false, err, "xrDestroySwapchain", "ignoring on teardown");
        this.handle = null;
        this.LOG.logDebug("Swapchain destroyed");
    }

    private void destroyViewBuffer() {
        if (this.xrViewBuffer != null) {
            this.xrViewBuffer.close();
            this.xrViewBuffer = null;
            this.LOG.logDebug("View buffer destroyed");
        }
    }

    public XrSwapchain getHandle() {
        return this.handle;
    }

    public XrView.Buffer getXrViewBuffer() {
        return this.xrViewBuffer;
    }

    public int getEyeMaxWidth() {
        return this.eyeMaxWidth;
    }

    public int getEyeMaxHeight() {
        return this.eyeMaxHeight;
    }
}

