/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.atumvr.core.init;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.util.Objects;
import me.phoenixra.atumvr.api.exceptions.VRException;
import me.phoenixra.atumvr.core.OpenXRProvider;
import me.phoenixra.atumvr.core.OpenXRState;
import org.lwjgl.PointerBuffer;
import org.lwjgl.glfw.GLFWNativeGLX;
import org.lwjgl.glfw.GLFWNativeWGL;
import org.lwjgl.glfw.GLFWNativeWin32;
import org.lwjgl.glfw.GLFWNativeX11;
import org.lwjgl.opengl.GLX13;
import org.lwjgl.openxr.KHROpenGLEnable;
import org.lwjgl.openxr.XR10;
import org.lwjgl.openxr.XrGraphicsBindingOpenGLWin32KHR;
import org.lwjgl.openxr.XrGraphicsBindingOpenGLXlibKHR;
import org.lwjgl.openxr.XrGraphicsRequirementsOpenGLKHR;
import org.lwjgl.openxr.XrInstance;
import org.lwjgl.openxr.XrSystemGetInfo;
import org.lwjgl.openxr.XrSystemGraphicsProperties;
import org.lwjgl.openxr.XrSystemProperties;
import org.lwjgl.openxr.XrSystemTrackingProperties;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Platform;
import org.lwjgl.system.Struct;
import org.lwjgl.system.linux.X11;
import org.lwjgl.system.windows.User32;

public class OpenXRSystem {
    private final OpenXRState xrState;
    private long systemId;

    public OpenXRSystem(OpenXRState xrState) {
        this.xrState = xrState;
    }

    public void init() {
        try (MemoryStack stack = MemoryStack.stackPush();){
            OpenXRProvider provider = this.xrState.getVrProvider();
            XrSystemGetInfo sysGetInfo = XrSystemGetInfo.calloc((MemoryStack)stack).type(4).next(0L).formFactor(1);
            LongBuffer sysIdBuf = stack.callocLong(1);
            provider.checkXRError(XR10.xrGetSystem((XrInstance)this.xrState.getVrInstance().getHandle(), (XrSystemGetInfo)sysGetInfo, (LongBuffer)sysIdBuf), "xrGetSystem", "fetch HMD system ID");
            this.systemId = sysIdBuf.get(0);
            if (this.systemId == 0L) {
                throw new VRException("No compatible HMD detected (system ID == 0)");
            }
            XrSystemProperties sysProps = XrSystemProperties.calloc((MemoryStack)stack).type(5);
            provider.checkXRError(XR10.xrGetSystemProperties((XrInstance)this.xrState.getVrInstance().getHandle(), (long)this.systemId, (XrSystemProperties)sysProps), "xrGetSystemProperties", "id=" + this.systemId);
            String name = MemoryUtil.memUTF8((long)MemoryUtil.memAddress((ByteBuffer)sysProps.systemName()));
            XrSystemTrackingProperties track = sysProps.trackingProperties();
            XrSystemGraphicsProperties gfx = sysProps.graphicsProperties();
            provider.getLogger().logInfo(String.format("Found HMD [%s] (vendor=%d): orientTrack=%b, posTrack=%b, maxRes=%dx%d, maxLayers=%d", name, sysProps.vendorId(), track.orientationTracking(), track.positionTracking(), gfx.maxSwapchainImageWidth(), gfx.maxSwapchainImageHeight(), gfx.maxLayerCount()));
        }
    }

    public Struct<?> createGraphicsBinding(MemoryStack stack, XrInstance instance, long systemID, long windowHandle) {
        XrGraphicsRequirementsOpenGLKHR graphicsRequirements = XrGraphicsRequirementsOpenGLKHR.calloc((MemoryStack)stack).type(1000023005);
        KHROpenGLEnable.xrGetOpenGLGraphicsRequirementsKHR((XrInstance)instance, (long)systemID, (XrGraphicsRequirementsOpenGLKHR)graphicsRequirements);
        if (Platform.get() == Platform.WINDOWS) {
            return XrGraphicsBindingOpenGLWin32KHR.calloc((MemoryStack)stack).set(1000023000, 0L, User32.GetDC((long)GLFWNativeWin32.glfwGetWin32Window((long)windowHandle)), GLFWNativeWGL.glfwGetWGLContext((long)windowHandle));
        }
        if (Platform.get() == Platform.LINUX) {
            long xDisplay = GLFWNativeX11.glfwGetX11Display();
            long glXContext = GLFWNativeGLX.glfwGetGLXContext((long)windowHandle);
            long glXWindowHandle = GLFWNativeGLX.glfwGetGLXWindow((long)windowHandle);
            int fbXID = GLX13.glXQueryDrawable((long)xDisplay, (long)glXWindowHandle, (int)32787);
            PointerBuffer fbConfigBuf = GLX13.glXChooseFBConfig((long)xDisplay, (int)X11.XDefaultScreen((long)xDisplay), (IntBuffer)MemoryStack.stackInts((int)32787, (int)fbXID, (int)0));
            if (fbConfigBuf == null) {
                throw new VRException("Framebuffer config is null");
            }
            long fbConfig = fbConfigBuf.get();
            return XrGraphicsBindingOpenGLXlibKHR.calloc((MemoryStack)stack).set(1000023001, 0L, xDisplay, (int)Objects.requireNonNull(GLX13.glXGetVisualFromFBConfig((long)xDisplay, (long)fbConfig)).visualid(), fbConfig, glXWindowHandle, glXContext);
        }
        throw new VRException("MacOS not supported");
    }

    public void destroy() {
    }

    public long getSystemId() {
        return this.systemId;
    }
}

