/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.atumvr.core.input.action.profileset;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.phoenixra.atumvr.core.OpenXRProvider;
import me.phoenixra.atumvr.core.enums.XRInteractionProfile;
import me.phoenixra.atumvr.core.input.action.OpenXRActionSet;
import me.phoenixra.atumvr.core.input.action.profileset.OpenXRProfileSet;
import me.phoenixra.atumvr.core.input.action.profileset.SharedActionSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProfileSetHolder {
    private final SharedActionSet sharedSet;
    private OpenXRProfileSet lastActive;
    private final Map<XRInteractionProfile, OpenXRProfileSet> profileSetMap = new HashMap<XRInteractionProfile, OpenXRProfileSet>();

    public ProfileSetHolder(OpenXRProvider provider) {
        this(new SharedActionSet(provider), XRInteractionProfile.getSupportedProfileSets(provider));
    }

    public ProfileSetHolder(@NotNull SharedActionSet sharedSet, @NotNull List<OpenXRProfileSet> profileSets) {
        this.sharedSet = sharedSet;
        for (OpenXRProfileSet entry : profileSets) {
            this.profileSetMap.put(entry.getType(), entry);
        }
    }

    @Nullable
    public OpenXRProfileSet getActiveProfileSet() {
        if (this.lastActive != null && this.lastActive.isProfileActive()) {
            return this.lastActive;
        }
        for (OpenXRProfileSet entry : this.profileSetMap.values()) {
            if (!entry.isProfileActive()) continue;
            this.lastActive = entry;
            return entry;
        }
        return this.lastActive;
    }

    @Nullable
    public OpenXRProfileSet getProfileSet(XRInteractionProfile type) {
        return this.profileSetMap.get((Object)type);
    }

    public Collection<OpenXRProfileSet> getProfileSets() {
        return this.profileSetMap.values();
    }

    public List<? extends OpenXRActionSet> getAllSets() {
        ArrayList<OpenXRActionSet> list = new ArrayList<OpenXRActionSet>();
        list.add(this.sharedSet);
        list.addAll(this.profileSetMap.values());
        return list;
    }

    public SharedActionSet getSharedSet() {
        return this.sharedSet;
    }
}

