/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.atumvr.core.input.action.profileset;

import java.util.List;
import me.phoenixra.atumvr.api.misc.pose.VRPoseRecord;
import me.phoenixra.atumvr.core.OpenXRProvider;
import me.phoenixra.atumvr.core.enums.XRInteractionProfile;
import me.phoenixra.atumvr.core.input.action.OpenXRAction;
import me.phoenixra.atumvr.core.input.action.OpenXRActionSet;
import me.phoenixra.atumvr.core.input.action.OpenXRMultiAction;
import me.phoenixra.atumvr.core.input.action.types.HapticPulseAction;
import me.phoenixra.atumvr.core.input.action.types.multi.PoseMultiAction;

public class SharedActionSet
extends OpenXRActionSet {
    private HapticPulseAction hapticPulse;
    private PoseMultiAction handPoseAim;
    private PoseMultiAction handPoseGrip;

    public SharedActionSet(OpenXRProvider provider) {
        super(provider, "shared", "Shared set", 0);
    }

    @Override
    protected List<OpenXRAction> loadActions(OpenXRProvider provider) {
        List<XRInteractionProfile> supportedProfiles = XRInteractionProfile.getSupported(provider);
        this.hapticPulse = new HapticPulseAction(provider, this, "haptic_pulse", "Haptic Pulse").putDefaultBindings(supportedProfiles, "output/haptic");
        this.handPoseAim = new PoseMultiAction(provider, (OpenXRActionSet)this, "hand_aim", "Hand Aim", List.of(new OpenXRMultiAction.SubAction<VRPoseRecord>("hand.aim.left", "/user/hand/left", VRPoseRecord.EMPTY).putDefaultBindings(supportedProfiles, "input/aim/pose"), new OpenXRMultiAction.SubAction<VRPoseRecord>("hand.aim.right", "/user/hand/right", VRPoseRecord.EMPTY).putDefaultBindings(supportedProfiles, "input/aim/pose")));
        this.handPoseGrip = new PoseMultiAction(provider, (OpenXRActionSet)this, "hand_grip", "Hand Grip", List.of(new OpenXRMultiAction.SubAction<VRPoseRecord>("hand.aim.left", "/user/hand/left", VRPoseRecord.EMPTY).putDefaultBindings(supportedProfiles, "input/grip/pose"), new OpenXRMultiAction.SubAction<VRPoseRecord>("hand.aim.right", "/user/hand/right", VRPoseRecord.EMPTY).putDefaultBindings(supportedProfiles, "input/grip/pose")));
        return List.of(this.hapticPulse, this.handPoseAim, this.handPoseGrip);
    }

    public HapticPulseAction getHapticPulse() {
        return this.hapticPulse;
    }

    public PoseMultiAction getHandPoseAim() {
        return this.handPoseAim;
    }

    public PoseMultiAction getHandPoseGrip() {
        return this.handPoseGrip;
    }
}

