/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.atumvr.core.input.action.profileset.types;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import me.phoenixra.atumvr.api.input.action.VRActionDataButton;
import me.phoenixra.atumvr.api.input.action.VRActionDataVec2;
import me.phoenixra.atumvr.core.OpenXRProvider;
import me.phoenixra.atumvr.core.enums.XRInteractionProfile;
import me.phoenixra.atumvr.core.input.action.OpenXRAction;
import me.phoenixra.atumvr.core.input.action.OpenXRActionSet;
import me.phoenixra.atumvr.core.input.action.OpenXRMultiAction;
import me.phoenixra.atumvr.core.input.action.profileset.OpenXRProfileSet;
import me.phoenixra.atumvr.core.input.action.types.multi.BoolButtonMultiAction;
import me.phoenixra.atumvr.core.input.action.types.multi.FloatButtonMultiAction;
import me.phoenixra.atumvr.core.input.action.types.multi.Vec2MultiAction;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector2f;

public class ValveIndexSet
extends OpenXRProfileSet {
    private static final XRInteractionProfile PROFILE = XRInteractionProfile.VALVE_INDEX;
    public static final String BUTTON_SYSTEM_LEFT = "button.system.left";
    public static final String BUTTON_SYSTEM_RIGHT = "button.system.right";
    public static final String BUTTON_SYSTEM_TOUCH_LEFT = "button.system.touch.left";
    public static final String BUTTON_SYSTEM_TOUCH_RIGHT = "button.system.touch.right";
    public static final String BUTTON_A_LEFT = "button.a.left";
    public static final String BUTTON_A_RIGHT = "button.a.right";
    public static final String BUTTON_A_TOUCH_LEFT = "button.a.touch.left";
    public static final String BUTTON_A_TOUCH_RIGHT = "button.a.touch.right";
    public static final String BUTTON_B_LEFT = "button.b.left";
    public static final String BUTTON_B_RIGHT = "button.b.right";
    public static final String BUTTON_B_TOUCH_LEFT = "button.b.touch.left";
    public static final String BUTTON_B_TOUCH_RIGHT = "button.b.touch.right";
    public static final String BUTTON_GRIP_LEFT = "button.grip.left";
    public static final String BUTTON_GRIP_RIGHT = "button.grip.right";
    public static final String BUTTON_GRIP_FORCE_LEFT = "button.grip.force.left";
    public static final String BUTTON_GRIP_FORCE_RIGHT = "button.grip.force.right";
    public static final String BUTTON_TRIGGER_LEFT = "button.trigger.left";
    public static final String BUTTON_TRIGGER_RIGHT = "button.trigger.right";
    public static final String BUTTON_TRIGGER_CLICK_LEFT = "button.trigger.click.left";
    public static final String BUTTON_TRIGGER_CLICK_RIGHT = "button.trigger.click.right";
    public static final String BUTTON_TRIGGER_TOUCH_LEFT = "button.trigger.touch.left";
    public static final String BUTTON_TRIGGER_TOUCH_RIGHT = "button.trigger.touch.right";
    public static final String BUTTON_THUMBSTICK_LEFT = "button.thumbstick.left";
    public static final String BUTTON_THUMBSTICK_RIGHT = "button.thumbstick.right";
    public static final String BUTTON_THUMBSTICK_TOUCH_LEFT = "button.thumbstick.touch.left";
    public static final String BUTTON_THUMBSTICK_TOUCH_RIGHT = "button.thumbstick.touch.right";
    public static final String BUTTON_TRACKPAD_TOUCH_LEFT = "button.trackpad.touch.left";
    public static final String BUTTON_TRACKPAD_TOUCH_RIGHT = "button.trackpad.touch.right";
    public static final String BUTTON_TRACKPAD_FORCE_LEFT = "button.trackpad.force.left";
    public static final String BUTTON_TRACKPAD_FORCE_RIGHT = "button.trackpad.force.right";
    public static final String VEC2_THUMBSTICK_LEFT = "vec2.thumbstick.left";
    public static final String VEC2_THUMBSTICK_RIGHT = "vec2.thumbstick.right";
    public static final String VEC2_TRACKPAD_LEFT = "vec2.trackpad.left";
    public static final String VEC2_TRACKPAD_RIGHT = "vec2.trackpad.right";
    private BoolButtonMultiAction systemButton;
    private BoolButtonMultiAction systemButtonTouch;
    private BoolButtonMultiAction buttonA;
    private BoolButtonMultiAction buttonTouchA;
    private BoolButtonMultiAction buttonB;
    private BoolButtonMultiAction buttonTouchB;
    private FloatButtonMultiAction gripValue;
    private FloatButtonMultiAction gripForce;
    private FloatButtonMultiAction triggerValue;
    private BoolButtonMultiAction triggerButton;
    private BoolButtonMultiAction triggerButtonTouch;
    private Vec2MultiAction thumbStick;
    private BoolButtonMultiAction thumbStickButton;
    private BoolButtonMultiAction thumbStickButtonTouch;
    private Vec2MultiAction trackpad;
    private BoolButtonMultiAction trackpadTouch;
    private FloatButtonMultiAction trackpadForce;
    private Map<String, VRActionDataButton> buttonMap;
    private Map<String, VRActionDataVec2> vec2Map;

    public ValveIndexSet(OpenXRProvider provider) {
        super(provider, "valve_index", "Valve Index", 0);
    }

    @Override
    protected List<OpenXRAction> loadActions(OpenXRProvider provider) {
        this.systemButton = new BoolButtonMultiAction(provider, (OpenXRActionSet)this, "button.system", "System button", List.of(new BoolButtonMultiAction.SubActionBoolButton(BUTTON_SYSTEM_LEFT, "/user/hand/left", false).putDefaultBindings(PROFILE, "input/system/click"), new BoolButtonMultiAction.SubActionBoolButton(BUTTON_SYSTEM_RIGHT, "/user/hand/right", false).putDefaultBindings(PROFILE, "input/system/click")));
        this.systemButtonTouch = new BoolButtonMultiAction(provider, (OpenXRActionSet)this, "button.system.touch", "System button touch", List.of(new BoolButtonMultiAction.SubActionBoolButton(BUTTON_SYSTEM_TOUCH_LEFT, "/user/hand/left", false).putDefaultBindings(PROFILE, "input/system/touch"), new BoolButtonMultiAction.SubActionBoolButton(BUTTON_SYSTEM_TOUCH_RIGHT, "/user/hand/right", false).putDefaultBindings(PROFILE, "input/system/touch")));
        this.buttonA = new BoolButtonMultiAction(provider, (OpenXRActionSet)this, "button.primary", "Primary Button", List.of(new BoolButtonMultiAction.SubActionBoolButton(BUTTON_A_LEFT, "/user/hand/left", false).putDefaultBindings(PROFILE, "input/a/click"), new BoolButtonMultiAction.SubActionBoolButton(BUTTON_A_RIGHT, "/user/hand/right", false).putDefaultBindings(PROFILE, "input/a/click")));
        this.buttonTouchA = new BoolButtonMultiAction(provider, (OpenXRActionSet)this, "button.a.touch", "'A' Button Touch", List.of(new BoolButtonMultiAction.SubActionBoolButton(BUTTON_A_TOUCH_LEFT, "/user/hand/left", false).putDefaultBindings(PROFILE, "input/a/touch"), new BoolButtonMultiAction.SubActionBoolButton(BUTTON_A_TOUCH_RIGHT, "/user/hand/right", false).putDefaultBindings(PROFILE, "input/a/touch")));
        this.buttonB = new BoolButtonMultiAction(provider, (OpenXRActionSet)this, "button.b", "'B' Button", List.of(new BoolButtonMultiAction.SubActionBoolButton(BUTTON_B_LEFT, "/user/hand/left", false).putDefaultBindings(PROFILE, "input/b/click"), new BoolButtonMultiAction.SubActionBoolButton(BUTTON_B_RIGHT, "/user/hand/right", false).putDefaultBindings(PROFILE, "input/b/click")));
        this.buttonTouchB = new BoolButtonMultiAction(provider, (OpenXRActionSet)this, "button.b.touch", "B Button Touch", List.of(new BoolButtonMultiAction.SubActionBoolButton(BUTTON_B_TOUCH_LEFT, "/user/hand/left", false).putDefaultBindings(PROFILE, "input/b/touch"), new BoolButtonMultiAction.SubActionBoolButton(BUTTON_B_TOUCH_RIGHT, "/user/hand/right", false).putDefaultBindings(PROFILE, "input/b/touch")));
        this.gripValue = new FloatButtonMultiAction(provider, this, "button.grip", "Grip Value", 0.9f, 0.85f, List.of(new FloatButtonMultiAction.SubActionFloatButton(BUTTON_GRIP_LEFT, "/user/hand/left", Float.valueOf(0.0f)).putDefaultBindings(PROFILE, "input/squeeze/value"), new FloatButtonMultiAction.SubActionFloatButton(BUTTON_GRIP_RIGHT, "/user/hand/right", Float.valueOf(0.0f)).putDefaultBindings(PROFILE, "input/squeeze/value")));
        this.gripForce = new FloatButtonMultiAction(provider, this, "button.grip.force", "Grip Force button", 0.9f, 0.85f, List.of(new FloatButtonMultiAction.SubActionFloatButton(BUTTON_GRIP_FORCE_LEFT, "/user/hand/left", Float.valueOf(0.0f)).putDefaultBindings(PROFILE, "input/squeeze/force"), new FloatButtonMultiAction.SubActionFloatButton(BUTTON_GRIP_FORCE_RIGHT, "/user/hand/right", Float.valueOf(0.0f)).putDefaultBindings(PROFILE, "input/squeeze/force")));
        this.triggerValue = new FloatButtonMultiAction(provider, this, "button.trigger", "Trigger Value", 0.7f, 0.65f, List.of(new FloatButtonMultiAction.SubActionFloatButton(BUTTON_TRIGGER_LEFT, "/user/hand/left", Float.valueOf(0.0f)).putDefaultBindings(PROFILE, "input/trigger/value"), new FloatButtonMultiAction.SubActionFloatButton(BUTTON_TRIGGER_RIGHT, "/user/hand/right", Float.valueOf(0.0f)).putDefaultBindings(PROFILE, "input/trigger/value")));
        this.triggerButton = new BoolButtonMultiAction(provider, (OpenXRActionSet)this, "button.trigger.click", "Trigger Button", List.of(new BoolButtonMultiAction.SubActionBoolButton(BUTTON_TRIGGER_CLICK_LEFT, "/user/hand/left", false).putDefaultBindings(PROFILE, "input/trigger/click"), new BoolButtonMultiAction.SubActionBoolButton(BUTTON_TRIGGER_CLICK_RIGHT, "/user/hand/right", false).putDefaultBindings(PROFILE, "input/trigger/click")));
        this.triggerButtonTouch = new BoolButtonMultiAction(provider, (OpenXRActionSet)this, "button.trigger.touch", "Trigger Button Touch", List.of(new BoolButtonMultiAction.SubActionBoolButton(BUTTON_TRIGGER_TOUCH_LEFT, "/user/hand/left", false).putDefaultBindings(PROFILE, "input/trigger/touch"), new BoolButtonMultiAction.SubActionBoolButton(BUTTON_TRIGGER_TOUCH_RIGHT, "/user/hand/right", false).putDefaultBindings(PROFILE, "input/trigger/touch")));
        this.thumbStick = new Vec2MultiAction(provider, (OpenXRActionSet)this, "vec2.thumbstick", "Thumbstick", List.of(new Vec2MultiAction.SubActionVec2(VEC2_THUMBSTICK_LEFT, "/user/hand/left", new Vector2f(0.0f, 0.0f)).putDefaultBindings(PROFILE, "input/thumbstick"), new Vec2MultiAction.SubActionVec2(VEC2_THUMBSTICK_RIGHT, "/user/hand/right", new Vector2f(0.0f, 0.0f)).putDefaultBindings(PROFILE, "input/thumbstick")));
        this.thumbStickButton = new BoolButtonMultiAction(provider, (OpenXRActionSet)this, "button.thumbstick", "ThumbStick Button", List.of(new BoolButtonMultiAction.SubActionBoolButton(BUTTON_THUMBSTICK_LEFT, "/user/hand/left", false).putDefaultBindings(PROFILE, "input/thumbstick/click"), new BoolButtonMultiAction.SubActionBoolButton(BUTTON_THUMBSTICK_RIGHT, "/user/hand/right", false).putDefaultBindings(PROFILE, "input/thumbstick/click")));
        this.thumbStickButtonTouch = new BoolButtonMultiAction(provider, (OpenXRActionSet)this, "button.thumbstick.touch", "ThumbStick Button Touch", List.of(new BoolButtonMultiAction.SubActionBoolButton(BUTTON_THUMBSTICK_TOUCH_LEFT, "/user/hand/left", false).putDefaultBindings(PROFILE, "input/thumbstick/touch"), new BoolButtonMultiAction.SubActionBoolButton(BUTTON_THUMBSTICK_TOUCH_RIGHT, "/user/hand/right", false).putDefaultBindings(PROFILE, "input/thumbstick/touch")));
        this.trackpad = new Vec2MultiAction(provider, (OpenXRActionSet)this, "vec2.trackpad", "Trackpad", List.of(new Vec2MultiAction.SubActionVec2(VEC2_TRACKPAD_LEFT, "/user/hand/left", new Vector2f(0.0f, 0.0f)).putDefaultBindings(PROFILE, "input/trackpad"), new Vec2MultiAction.SubActionVec2(VEC2_TRACKPAD_RIGHT, "/user/hand/right", new Vector2f(0.0f, 0.0f)).putDefaultBindings(PROFILE, "input/trackpad")));
        this.trackpadTouch = new BoolButtonMultiAction(provider, (OpenXRActionSet)this, "button.trackpad.touch", "Trackpad Touch", List.of(new BoolButtonMultiAction.SubActionBoolButton(BUTTON_TRACKPAD_TOUCH_LEFT, "/user/hand/left", false).putDefaultBindings(PROFILE, "input/trackpad/touch"), new BoolButtonMultiAction.SubActionBoolButton(BUTTON_TRACKPAD_TOUCH_RIGHT, "/user/hand/right", false).putDefaultBindings(PROFILE, "input/trackpad/touch")));
        this.trackpadForce = new FloatButtonMultiAction(provider, this, "button.trackpad.force", "Trackpad Force button", 0.3f, 0.1f, List.of(new FloatButtonMultiAction.SubActionFloatButton(BUTTON_TRACKPAD_FORCE_LEFT, "/user/hand/left", Float.valueOf(0.0f)).putDefaultBindings(PROFILE, "input/trackpad/force"), new FloatButtonMultiAction.SubActionFloatButton(BUTTON_TRACKPAD_FORCE_RIGHT, "/user/hand/right", Float.valueOf(0.0f)).putDefaultBindings(PROFILE, "input/trackpad/force")));
        ArrayList<OpenXRMultiAction.SubAction> listButton = new ArrayList<OpenXRMultiAction.SubAction>();
        listButton.addAll(this.systemButton.getSubActionsAsButton());
        listButton.addAll(this.systemButtonTouch.getSubActionsAsButton());
        listButton.addAll(this.buttonA.getSubActionsAsButton());
        listButton.addAll(this.buttonTouchA.getSubActionsAsButton());
        listButton.addAll(this.buttonB.getSubActionsAsButton());
        listButton.addAll(this.buttonTouchB.getSubActionsAsButton());
        listButton.addAll(this.gripValue.getSubActionsAsButton());
        listButton.addAll(this.gripForce.getSubActionsAsButton());
        listButton.addAll(this.triggerValue.getSubActionsAsButton());
        listButton.addAll(this.triggerButton.getSubActionsAsButton());
        listButton.addAll(this.triggerButtonTouch.getSubActionsAsButton());
        listButton.addAll(this.thumbStickButton.getSubActionsAsButton());
        listButton.addAll(this.thumbStickButtonTouch.getSubActionsAsButton());
        listButton.addAll(this.trackpadTouch.getSubActionsAsButton());
        listButton.addAll(this.trackpadForce.getSubActionsAsButton());
        this.buttonMap = new LinkedHashMap<String, VRActionDataButton>();
        for (VRActionDataButton vRActionDataButton : listButton) {
            this.buttonMap.put(vRActionDataButton.getId(), vRActionDataButton);
        }
        ArrayList<Vec2MultiAction.SubActionVec2> listVec2 = new ArrayList<Vec2MultiAction.SubActionVec2>();
        listVec2.addAll(this.thumbStick.getSubActionsAsVec2());
        listVec2.addAll(this.trackpad.getSubActionsAsVec2());
        this.vec2Map = new LinkedHashMap<String, VRActionDataVec2>();
        for (VRActionDataVec2 vRActionDataVec2 : listVec2) {
            this.vec2Map.put(vRActionDataVec2.getId(), vRActionDataVec2);
        }
        return List.of(this.systemButton, this.systemButtonTouch, this.buttonA, this.buttonTouchA, this.buttonB, this.buttonTouchB, this.gripValue, this.gripForce, this.triggerValue, this.triggerButton, this.triggerButtonTouch, this.thumbStick, this.thumbStickButton, this.thumbStickButtonTouch, this.trackpad, this.trackpadTouch, this.trackpadForce);
    }

    @Override
    public Collection<String> getButtonIds() {
        return Collections.unmodifiableCollection(this.buttonMap.keySet());
    }

    @Override
    public VRActionDataButton getButton(@NotNull String id) {
        return this.buttonMap.get(id);
    }

    @Override
    public Collection<String> getVec2Ids() {
        return Collections.unmodifiableCollection(this.vec2Map.keySet());
    }

    @Override
    public VRActionDataVec2 getVec2(@NotNull String id) {
        return this.vec2Map.get(id);
    }

    @Override
    @NotNull
    public XRInteractionProfile getType() {
        return PROFILE;
    }

    public BoolButtonMultiAction getSystemButton() {
        return this.systemButton;
    }

    public BoolButtonMultiAction getSystemButtonTouch() {
        return this.systemButtonTouch;
    }

    public BoolButtonMultiAction getButtonA() {
        return this.buttonA;
    }

    public BoolButtonMultiAction getButtonTouchA() {
        return this.buttonTouchA;
    }

    public BoolButtonMultiAction getButtonB() {
        return this.buttonB;
    }

    public BoolButtonMultiAction getButtonTouchB() {
        return this.buttonTouchB;
    }

    public FloatButtonMultiAction getGripValue() {
        return this.gripValue;
    }

    public FloatButtonMultiAction getGripForce() {
        return this.gripForce;
    }

    @Override
    public FloatButtonMultiAction getTriggerValue() {
        return this.triggerValue;
    }

    public BoolButtonMultiAction getTriggerButton() {
        return this.triggerButton;
    }

    public BoolButtonMultiAction getTriggerButtonTouch() {
        return this.triggerButtonTouch;
    }

    public Vec2MultiAction getThumbStick() {
        return this.thumbStick;
    }

    public BoolButtonMultiAction getThumbStickButton() {
        return this.thumbStickButton;
    }

    public BoolButtonMultiAction getThumbStickButtonTouch() {
        return this.thumbStickButtonTouch;
    }

    public Vec2MultiAction getTrackpad() {
        return this.trackpad;
    }

    public BoolButtonMultiAction getTrackpadTouch() {
        return this.trackpadTouch;
    }

    public FloatButtonMultiAction getTrackpadForce() {
        return this.trackpadForce;
    }

    public Map<String, VRActionDataButton> getButtonMap() {
        return this.buttonMap;
    }

    public Map<String, VRActionDataVec2> getVec2Map() {
        return this.vec2Map;
    }
}

