/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.atumvr.core.input.action.types.multi;

import java.util.List;
import java.util.function.Consumer;
import me.phoenixra.atumvr.core.OpenXRProvider;
import me.phoenixra.atumvr.core.enums.XRInputActionType;
import me.phoenixra.atumvr.core.input.action.OpenXRActionSet;
import me.phoenixra.atumvr.core.input.action.OpenXRMultiAction;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.openxr.XR10;
import org.lwjgl.openxr.XrActionStateFloat;
import org.lwjgl.openxr.XrActionStateGetInfo;
import org.lwjgl.openxr.XrSession;
import org.lwjgl.system.MemoryStack;

public class FloatMultiAction
extends OpenXRMultiAction<Float> {
    public FloatMultiAction(OpenXRProvider provider, OpenXRActionSet actionSet, String id, String localizedName, List<OpenXRMultiAction.SubAction<Float>> subActions) {
        super(provider, actionSet, id, localizedName, XRInputActionType.FLOAT, subActions);
    }

    @Override
    protected void onInit(OpenXRActionSet actionSet, MemoryStack stack) {
    }

    @Override
    public void update(@Nullable Consumer<String> listener) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            for (OpenXRMultiAction.SubAction entry : this.subActions) {
                XrActionStateFloat state = XrActionStateFloat.calloc((MemoryStack)stack).type(this.actionType.getStateId());
                getInfo.subactionPath(entry.getPathHandle());
                getInfo.action(this.handle);
                this.provider.checkXRError(XR10.xrGetActionStateFloat((XrSession)this.provider.getState().getVrSession().getHandle(), (XrActionStateGetInfo)getInfo, (XrActionStateFloat)state), "xrGetActionStateFloat", new String[0]);
                entry.update(Float.valueOf(state.currentState()), state.lastChangeTime(), state.changedSinceLastSync(), state.isActive());
                if (listener == null || !state.changedSinceLastSync()) continue;
                listener.accept(entry.getId());
            }
        }
    }
}

