/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.atumvr.core.input.action.types.multi;

import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import me.phoenixra.atumvr.api.misc.pose.VRPoseRecord;
import me.phoenixra.atumvr.core.OpenXRHelper;
import me.phoenixra.atumvr.core.OpenXRProvider;
import me.phoenixra.atumvr.core.enums.XRInputActionType;
import me.phoenixra.atumvr.core.input.action.OpenXRActionSet;
import me.phoenixra.atumvr.core.input.action.OpenXRMultiAction;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4fc;
import org.joml.Quaternionfc;
import org.joml.Vector3fc;
import org.lwjgl.PointerBuffer;
import org.lwjgl.openxr.XR10;
import org.lwjgl.openxr.XrActionSpaceCreateInfo;
import org.lwjgl.openxr.XrActionStateGetInfo;
import org.lwjgl.openxr.XrActionStatePose;
import org.lwjgl.openxr.XrSession;
import org.lwjgl.openxr.XrSpace;
import org.lwjgl.openxr.XrSpaceLocation;
import org.lwjgl.system.MemoryStack;

public class PoseMultiAction
extends OpenXRMultiAction<VRPoseRecord> {
    private HashMap<OpenXRMultiAction.SubAction<VRPoseRecord>, XrSpace> xrSpace = new HashMap();

    public PoseMultiAction(OpenXRProvider provider, OpenXRActionSet actionSet, String id, String localizedName, List<OpenXRMultiAction.SubAction<VRPoseRecord>> subActions) {
        super(provider, actionSet, id, localizedName, XRInputActionType.POSE, subActions);
    }

    @Override
    protected void onInit(OpenXRActionSet actionSet, MemoryStack stack) {
        for (OpenXRMultiAction.SubAction entry : this.subActions) {
            XrSession xrSession = this.provider.getState().getVrSession().getHandle();
            XrActionSpaceCreateInfo action_space_info = XrActionSpaceCreateInfo.calloc((MemoryStack)stack).set(38, 0L, this.handle, entry.getPathHandle(), OpenXRHelper.getPoseIdentity(stack));
            PointerBuffer pp = MemoryStack.stackCallocPointer((int)1);
            this.provider.checkXRError(XR10.xrCreateActionSpace((XrSession)xrSession, (XrActionSpaceCreateInfo)action_space_info, (PointerBuffer)pp), "xrCreateActionSpace", new String[0]);
            this.xrSpace.put(entry, new XrSpace(pp.get(0), xrSession));
        }
    }

    @Override
    public void update(@Nullable Consumer<String> listener) {
        for (OpenXRMultiAction.SubAction entry : this.subActions) {
            MemoryStack stack = MemoryStack.stackPush();
            try {
                XrActionStatePose state = XrActionStatePose.calloc((MemoryStack)stack).type(this.actionType.getStateId());
                getInfo.subactionPath(entry.getPathHandle());
                getInfo.action(this.handle);
                this.provider.checkXRError(XR10.xrGetActionStatePose((XrSession)this.provider.getState().getVrSession().getHandle(), (XrActionStateGetInfo)getInfo, (XrActionStatePose)state), "xrGetActionStateFloat", new String[0]);
                XrSpaceLocation loc = OpenXRHelper.xrLocationFromSpace(this.provider, this.xrSpace.get(entry), stack);
                VRPoseRecord entryState = loc == null ? VRPoseRecord.EMPTY : new VRPoseRecord((Matrix4fc)OpenXRHelper.normalizeXrPose(loc.pose()), (Quaternionfc)OpenXRHelper.normalizeXrQuaternion(loc.pose().orientation()), (Vector3fc)OpenXRHelper.normalizeXrVector(loc.pose().position$()));
                entry.update(entryState, System.nanoTime(), true, state.isActive());
            }
            finally {
                if (stack == null) continue;
                stack.close();
            }
        }
    }

    public HashMap<OpenXRMultiAction.SubAction<VRPoseRecord>, XrSpace> getXrSpace() {
        return this.xrSpace;
    }
}

