/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.atumvr.core.input.action.types.multi;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import me.phoenixra.atumvr.api.enums.ControllerType;
import me.phoenixra.atumvr.api.input.action.VRActionDataVec2;
import me.phoenixra.atumvr.core.OpenXRHelper;
import me.phoenixra.atumvr.core.OpenXRProvider;
import me.phoenixra.atumvr.core.enums.XRInputActionType;
import me.phoenixra.atumvr.core.enums.XRInteractionProfile;
import me.phoenixra.atumvr.core.input.action.OpenXRActionSet;
import me.phoenixra.atumvr.core.input.action.OpenXRMultiAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2f;
import org.lwjgl.openxr.XR10;
import org.lwjgl.openxr.XrActionStateGetInfo;
import org.lwjgl.openxr.XrActionStateVector2f;
import org.lwjgl.openxr.XrSession;
import org.lwjgl.system.MemoryStack;

public class Vec2MultiAction
extends OpenXRMultiAction<Vector2f> {
    private final List<SubActionVec2> subActionsAsVec2;

    public Vec2MultiAction(OpenXRProvider provider, OpenXRActionSet actionSet, String id, String localizedName, List<SubActionVec2> subActions) {
        super(provider, actionSet, id, localizedName, XRInputActionType.VECTOR2F, subActions);
        this.subActionsAsVec2 = Collections.unmodifiableList(subActions);
    }

    @Override
    protected void onInit(OpenXRActionSet actionSet, MemoryStack stack) {
    }

    @Override
    public void update(@Nullable Consumer<String> listener) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            for (OpenXRMultiAction.SubAction entry : this.subActions) {
                XrActionStateVector2f state = XrActionStateVector2f.calloc((MemoryStack)stack).type(this.actionType.getStateId());
                getInfo.subactionPath(entry.getPathHandle());
                getInfo.action(this.handle);
                this.provider.checkXRError(XR10.xrGetActionStateVector2f((XrSession)this.provider.getState().getVrSession().getHandle(), (XrActionStateGetInfo)getInfo, (XrActionStateVector2f)state), "xrGetActionStateFloat", new String[0]);
                entry.update(OpenXRHelper.normalizeXrVector(state.currentState()), state.lastChangeTime(), state.changedSinceLastSync(), state.isActive());
                if (listener == null || !state.changedSinceLastSync()) continue;
                listener.accept(entry.getId());
            }
        }
    }

    public SubActionVec2 getHandSubaction(ControllerType type) {
        return (SubActionVec2)super.getHandSubaction(type);
    }

    public List<SubActionVec2> getSubActionsAsVec2() {
        return this.subActionsAsVec2;
    }

    public static class SubActionVec2
    extends OpenXRMultiAction.SubAction<Vector2f>
    implements VRActionDataVec2 {
        public SubActionVec2(String id, String path, Vector2f initialState) {
            super(id, path, initialState);
        }

        public SubActionVec2 putDefaultBindings(@NotNull List<XRInteractionProfile> profiles, @Nullable String source) {
            return (SubActionVec2)super.putDefaultBindings(profiles, source);
        }

        public SubActionVec2 putDefaultBindings(@NotNull XRInteractionProfile profile, @Nullable String source) {
            return (SubActionVec2)super.putDefaultBindings(profile, source);
        }
    }
}

