/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.atumvr.core.input.action.types.single;

import java.util.List;
import java.util.function.Consumer;
import me.phoenixra.atumvr.api.input.action.VRActionDataButton;
import me.phoenixra.atumvr.core.OpenXRProvider;
import me.phoenixra.atumvr.core.enums.XRInputActionType;
import me.phoenixra.atumvr.core.enums.XRInteractionProfile;
import me.phoenixra.atumvr.core.input.action.OpenXRActionSet;
import me.phoenixra.atumvr.core.input.action.OpenXRSingleAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.openxr.XR10;
import org.lwjgl.openxr.XrActionStateBoolean;
import org.lwjgl.openxr.XrActionStateGetInfo;
import org.lwjgl.openxr.XrSession;
import org.lwjgl.system.MemoryStack;

public class BoolButtonAction
extends OpenXRSingleAction<Boolean>
implements VRActionDataButton {
    public BoolButtonAction(OpenXRProvider provider, OpenXRActionSet actionSet, String id, String localizedName) {
        super(provider, actionSet, id, localizedName, XRInputActionType.BOOLEAN);
        this.currentState = false;
    }

    @Override
    protected void onInit(OpenXRActionSet actionSet, MemoryStack stack) {
    }

    @Override
    public void update(@Nullable Consumer<String> listener) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            XrActionStateBoolean state = XrActionStateBoolean.calloc((MemoryStack)stack).type(this.actionType.getStateId());
            getInfo.action(this.handle);
            this.provider.checkXRError(XR10.xrGetActionStateBoolean((XrSession)this.provider.getState().getVrSession().getHandle(), (XrActionStateGetInfo)getInfo, (XrActionStateBoolean)state), "xrGetActionStateFloat", new String[0]);
            this.currentState = state.currentState();
            this.changed = state.changedSinceLastSync();
            this.lastChangeTime = state.lastChangeTime();
            this.active = state.isActive();
            if (listener != null && this.changed) {
                listener.accept(this.id);
            }
        }
    }

    @Override
    public boolean isPressed() {
        return (Boolean)this.currentState;
    }

    @Override
    public boolean isButtonChanged() {
        return this.changed;
    }

    @Override
    public long getButtonLastChangeTime() {
        return this.lastChangeTime;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public BoolButtonAction putDefaultBindings(@NotNull List<XRInteractionProfile> profiles, @Nullable String source) {
        return (BoolButtonAction)super.putDefaultBindings(profiles, source);
    }

    public BoolButtonAction putDefaultBindings(@NotNull XRInteractionProfile profile, @Nullable String source) {
        return (BoolButtonAction)super.putDefaultBindings(profile, source);
    }
}

