/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.atumvr.core.input.action.types.single;

import java.util.function.Consumer;
import me.phoenixra.atumvr.api.misc.pose.VRPoseRecord;
import me.phoenixra.atumvr.core.OpenXRHelper;
import me.phoenixra.atumvr.core.OpenXRProvider;
import me.phoenixra.atumvr.core.enums.XRInputActionType;
import me.phoenixra.atumvr.core.input.action.OpenXRActionSet;
import me.phoenixra.atumvr.core.input.action.OpenXRSingleAction;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4fc;
import org.joml.Quaternionfc;
import org.joml.Vector3fc;
import org.lwjgl.PointerBuffer;
import org.lwjgl.openxr.XR10;
import org.lwjgl.openxr.XrActionSpaceCreateInfo;
import org.lwjgl.openxr.XrActionStateGetInfo;
import org.lwjgl.openxr.XrActionStatePose;
import org.lwjgl.openxr.XrSession;
import org.lwjgl.openxr.XrSpace;
import org.lwjgl.openxr.XrSpaceLocation;
import org.lwjgl.system.MemoryStack;

public class PoseAction
extends OpenXRSingleAction<VRPoseRecord> {
    private XrSpace xrSpace;

    public PoseAction(OpenXRProvider provider, OpenXRActionSet actionSet, String id, String localizedName) {
        super(provider, actionSet, id, localizedName, XRInputActionType.POSE);
        this.currentState = VRPoseRecord.EMPTY;
    }

    @Override
    protected void onInit(OpenXRActionSet actionSet, MemoryStack stack) {
        XrSession xrSession = this.provider.getState().getVrSession().getHandle();
        XrActionSpaceCreateInfo action_space_info = XrActionSpaceCreateInfo.calloc((MemoryStack)stack).set(38, 0L, this.handle, 0L, OpenXRHelper.getPoseIdentity(stack));
        PointerBuffer pp = MemoryStack.stackCallocPointer((int)1);
        this.provider.checkXRError(XR10.xrCreateActionSpace((XrSession)xrSession, (XrActionSpaceCreateInfo)action_space_info, (PointerBuffer)pp), "xrCreateActionSpace", new String[0]);
        this.xrSpace = new XrSpace(pp.get(0), xrSession);
    }

    @Override
    public void update(@Nullable Consumer<String> listener) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            XrActionStatePose state = XrActionStatePose.calloc((MemoryStack)stack).type(this.actionType.getStateId());
            getInfo.action(this.handle);
            this.provider.checkXRError(XR10.xrGetActionStatePose((XrSession)this.provider.getState().getVrSession().getHandle(), (XrActionStateGetInfo)getInfo, (XrActionStatePose)state), "xrGetActionStateFloat", new String[0]);
            this.changed = true;
            this.lastChangeTime = System.nanoTime();
            this.active = state.isActive();
            XrSpaceLocation loc = OpenXRHelper.xrLocationFromSpace(this.provider, this.xrSpace, stack);
            this.currentState = loc == null ? VRPoseRecord.EMPTY : new VRPoseRecord((Matrix4fc)OpenXRHelper.normalizeXrPose(loc.pose()), (Quaternionfc)OpenXRHelper.normalizeXrQuaternion(loc.pose().orientation()), (Vector3fc)OpenXRHelper.normalizeXrVector(loc.pose().position$()));
        }
    }

    public XrSpace getXrSpace() {
        return this.xrSpace;
    }
}

