/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.atumvr.core.input.device;

import me.phoenixra.atumvr.api.enums.ControllerType;
import me.phoenixra.atumvr.api.input.device.VRDeviceController;
import me.phoenixra.atumvr.api.misc.pose.VRPose;
import me.phoenixra.atumvr.api.misc.pose.VRPoseMutable;
import me.phoenixra.atumvr.api.misc.pose.VRPoseRecord;
import me.phoenixra.atumvr.core.OpenXRProvider;
import me.phoenixra.atumvr.core.input.action.OpenXRMultiAction;
import me.phoenixra.atumvr.core.input.action.types.HapticPulseAction;
import me.phoenixra.atumvr.core.input.action.types.multi.PoseMultiAction;
import me.phoenixra.atumvr.core.input.device.OpenXRDevice;
import org.jetbrains.annotations.NotNull;

public class OpenXRDeviceController
extends OpenXRDevice
implements VRDeviceController {
    private final ControllerType type;
    private boolean gripActive;
    private final VRPoseMutable gripPose = new VRPoseMutable();
    private final PoseMultiAction aimAction;
    private final PoseMultiAction gripAction;
    private final HapticPulseAction hapticPulseAction;

    public OpenXRDeviceController(OpenXRProvider provider, ControllerType controllerType, PoseMultiAction aimAction, PoseMultiAction gripAction, HapticPulseAction hapticPulseAction) {
        super(provider, controllerType == ControllerType.LEFT ? "controller_left" : "controller_right");
        this.type = controllerType;
        this.aimAction = aimAction;
        this.gripAction = gripAction;
        this.hapticPulseAction = hapticPulseAction;
    }

    @Override
    public void update() {
        OpenXRMultiAction.SubAction subActionAim = this.aimAction.getSubActions().get(this.type.ordinal());
        OpenXRMultiAction.SubAction subActionGrip = this.gripAction.getSubActions().get(this.type.ordinal());
        this.pose.update((VRPoseRecord)subActionAim.getCurrentState());
        this.active = subActionAim.isActive();
        this.gripPose.update((VRPoseRecord)subActionGrip.getCurrentState());
        this.gripActive = subActionGrip.isActive();
    }

    @Override
    public void triggerHapticPulse(float frequency, float amplitude, long durationNanoSec) {
        this.hapticPulseAction.triggerHapticPulse(this.type, frequency, amplitude, durationNanoSec);
    }

    @Override
    @NotNull
    public VRPose getGripPose() {
        return this.gripPose;
    }

    @Override
    public ControllerType getType() {
        return this.type;
    }

    @Override
    public boolean isGripActive() {
        return this.gripActive;
    }
}

