/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.atumvr.core.input.device;

import me.phoenixra.atumvr.api.enums.EyeType;
import me.phoenixra.atumvr.api.input.device.VRDeviceHMD;
import me.phoenixra.atumvr.api.misc.pose.VRPose;
import me.phoenixra.atumvr.api.misc.pose.VRPoseMutable;
import me.phoenixra.atumvr.core.OpenXRHelper;
import me.phoenixra.atumvr.core.OpenXRProvider;
import me.phoenixra.atumvr.core.input.device.OpenXRDevice;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4fc;
import org.joml.Quaternionfc;
import org.joml.Vector3fc;
import org.lwjgl.openxr.XrPosef;
import org.lwjgl.openxr.XrSpace;
import org.lwjgl.openxr.XrSpaceLocation;
import org.lwjgl.openxr.XrView;
import org.lwjgl.system.MemoryStack;

public class OpenXRDeviceHMD
extends OpenXRDevice
implements VRDeviceHMD {
    private final VRPoseMutable eyeLeftPose = new VRPoseMutable();
    private final VRPoseMutable eyeRightPose = new VRPoseMutable();
    private final XrSpace space;

    public OpenXRDeviceHMD(OpenXRProvider provider) {
        super(provider, "hmd");
        this.space = provider.getState().getVrSession().getXrViewSpace();
    }

    @Override
    public void update() {
        try (MemoryStack stack = MemoryStack.stackPush();){
            XrSpaceLocation loc = OpenXRHelper.xrLocationFromSpace(this.provider, this.space, stack);
            boolean bl = this.active = loc != null;
            if (this.active) {
                this.pose.update((Matrix4fc)OpenXRHelper.normalizeXrPose(loc.pose()), (Quaternionfc)OpenXRHelper.normalizeXrQuaternion(loc.pose().orientation()), (Vector3fc)OpenXRHelper.normalizeXrVector(loc.pose().position$()));
            }
        }
        XrPosef eyePose = this.getXrView(EyeType.LEFT).pose();
        this.eyeLeftPose.update((Matrix4fc)OpenXRHelper.normalizeXrPose(eyePose), (Quaternionfc)OpenXRHelper.normalizeXrQuaternion(eyePose.orientation()), (Vector3fc)OpenXRHelper.normalizeXrVector(eyePose.position$()));
        eyePose = this.getXrView(EyeType.RIGHT).pose();
        this.eyeRightPose.update((Matrix4fc)OpenXRHelper.normalizeXrPose(eyePose), (Quaternionfc)OpenXRHelper.normalizeXrQuaternion(eyePose.orientation()), (Vector3fc)OpenXRHelper.normalizeXrVector(eyePose.position$()));
    }

    @Override
    @NotNull
    public VRPose getEyePose(@NotNull EyeType eyeType) {
        if (eyeType == EyeType.LEFT) {
            return this.eyeLeftPose;
        }
        return this.eyeRightPose;
    }

    public XrView getXrView(EyeType eyeType) {
        return (XrView)this.provider.getState().getVrSwapChain().getXrViewBuffer().get(eyeType.getIndex());
    }
}

