/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.atumvr.core.rendering;

import me.phoenixra.atumvr.api.enums.EyeType;
import me.phoenixra.atumvr.api.rendering.IRenderContext;
import me.phoenixra.atumvr.api.rendering.VRScene;
import me.phoenixra.atumvr.core.rendering.OpenXREyeCamera;
import me.phoenixra.atumvr.core.rendering.OpenXRRenderer;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.opengl.GL30;
import org.lwjgl.system.MemoryStack;

public abstract class OpenXRScene
implements VRScene {
    private OpenXRRenderer vrRenderer;
    protected OpenXREyeCamera rightEyeCamera;
    protected OpenXREyeCamera leftEyeCamera;

    public OpenXRScene(OpenXRRenderer vrRenderer) {
        this.vrRenderer = vrRenderer;
    }

    public abstract void updateEyeTexture(@NotNull EyeType var1);

    public abstract void onInit();

    @Override
    public void init() {
        this.leftEyeCamera = new OpenXREyeCamera(this.vrRenderer.getVrProvider());
        this.rightEyeCamera = new OpenXREyeCamera(this.vrRenderer.getVrProvider());
        this.setupMvp();
        this.onInit();
    }

    @Override
    public void render(@NotNull IRenderContext context) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            this.setupMvp();
            for (EyeType eyeType : EyeType.values()) {
                int fbo = eyeType == EyeType.LEFT ? this.vrRenderer.getTextureLeftEye().getFrameBufferId() : this.vrRenderer.getTextureRightEye().getFrameBufferId();
                GL30.glBindFramebuffer((int)36160, (int)fbo);
                GL30.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GL30.glClear((int)17664);
                this.updateEyeTexture(eyeType);
            }
            GL30.glBindFramebuffer((int)36160, (int)0);
        }
    }

    protected void setupMvp() {
        this.leftEyeCamera.updateProjectionMatrix(EyeType.LEFT, 0.02f, 100.0f);
        this.leftEyeCamera.updateViewMatrix(EyeType.LEFT);
        this.rightEyeCamera.updateProjectionMatrix(EyeType.RIGHT, 0.02f, 100.0f);
        this.rightEyeCamera.updateViewMatrix(EyeType.RIGHT);
    }

    @Override
    public OpenXRRenderer getVrRenderer() {
        return this.vrRenderer;
    }

    public OpenXREyeCamera getRightEyeCamera() {
        return this.rightEyeCamera;
    }

    public OpenXREyeCamera getLeftEyeCamera() {
        return this.leftEyeCamera;
    }
}

