/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.api;

import java.nio.file.Path;
import java.util.HashMap;
import java.util.LinkedHashMap;
import me.phoenixra.visor.api.ModLoader;
import me.phoenixra.visor.api.VisorClient;
import me.phoenixra.visor.api.VisorClientState;
import me.phoenixra.visor.api.VisorServer;
import me.phoenixra.visor.api.client.VRPlayMode;
import me.phoenixra.visor.api.client.VRStateMode;
import me.phoenixra.visor.api.client.gui.GuiTexture;
import me.phoenixra.visor.api.client.render.RenderPhase;
import me.phoenixra.visor.api.client.render.VRDisplay;
import me.phoenixra.visor.api.common.addon.AddonManager;
import me.phoenixra.visor.api.common.addon.VisorAddon;
import me.phoenixra.visor.api.common.eventbus.VREventBus;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2960;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface VisorAPI {
    public static final String MOD_ID = "visor";
    public static final String MOD_NAME = "Visor";
    public static final Path CONFIG_PATH = ModLoader.get().getConfigFolder().toPath().resolve("Visor");
    public static final GuiTexture NOD_ICON = new GuiTexture(new class_2960("visor", "icon.png"));

    public static void registerAddon(@NotNull VisorAddon addon) {
        if (VisorAPI.addonManager() != null) {
            throw new RuntimeException("Tried to register Visor addon after Visor instance is created");
        }
        if (Instance.getPreparedAddons().containsKey(addon.getAddonId())) {
            throw new RuntimeException("Tried to register addon with ID '" + addon.getAddonId() + "', that is already registered");
        }
        if (addon.getAddonId().equals("core")) {
            throw new RuntimeException("Not allowed to register Visor Addon with ID 'core'");
        }
        Instance.getPreparedAddons().put(addon.getAddonId(), addon);
    }

    @NotNull
    @Environment(value=EnvType.CLIENT)
    public static VisorClient client() {
        return Instance.client;
    }

    @NotNull
    @Environment(value=EnvType.CLIENT)
    public static VisorClientState clientState() {
        return Instance.clientState;
    }

    public static VisorServer server() {
        return Instance.server;
    }

    @NotNull
    public static AddonManager addonManager() {
        return Instance.addonManager;
    }

    @NotNull
    public static VREventBus eventBus() {
        return Instance.eventBus;
    }

    @ApiStatus.Internal
    public static final class Instance {
        @Environment(value=EnvType.CLIENT)
        private static VisorClient client;
        @Environment(value=EnvType.CLIENT)
        private static VisorClientState clientState;
        private static VisorServer server;
        private static AddonManager addonManager;
        private static VREventBus eventBus;
        private static HashMap<String, VisorAddon> preparedAddons;

        private Instance() {
            throw new UnsupportedOperationException("This is an utility class and cannot be instantiated");
        }

        @ApiStatus.Internal
        @Environment(value=EnvType.CLIENT)
        public static void setClient(VisorClient api) {
            client = api;
        }

        @ApiStatus.Internal
        @Environment(value=EnvType.CLIENT)
        public static void setClientState(VisorClientState api) {
            clientState = api;
        }

        @ApiStatus.Internal
        public static void setServer(VisorServer api) {
            server = api;
        }

        @ApiStatus.Internal
        public static void setAddonManager(AddonManager api) {
            addonManager = api;
        }

        @ApiStatus.Internal
        public static void setEventBus(VREventBus api) {
            eventBus = api;
        }

        public static HashMap<String, VisorAddon> getPreparedAddons() {
            return preparedAddons;
        }

        static {
            clientState = new VisorClientState(){

                @Override
                @NotNull
                public VRPlayMode playMode() {
                    return VRPlayMode.DISABLED;
                }

                @Override
                @NotNull
                public VRStateMode stateMode() {
                    return VRStateMode.OFF;
                }

                @Override
                @NotNull
                public RenderPhase renderPhase() {
                    return RenderPhase.VANILLA;
                }

                @Override
                @Nullable(value="Not rendering VR display")
                public @Nullable(value="Not rendering VR display") VRDisplay renderingDisplay() {
                    return null;
                }
            };
            preparedAddons = new LinkedHashMap<String, VisorAddon>();
        }
    }
}

