/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.api.client.data;

import java.util.function.Function;
import me.phoenixra.visor.api.VisorAPI;
import me.phoenixra.visor.api.client.data.PoseData;
import me.phoenixra.visor.api.client.data.PoseDataType;
import me.phoenixra.visor.api.client.data.PoseElement;
import net.minecraft.class_2561;
import net.minecraft.class_3532;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public enum PoseAnchor {
    NONE(it -> PoseElement.EMPTY),
    HMD(PoseData::getHmd),
    MAIN_HAND(PoseData::getControllerMain),
    OFFHAND(PoseData::getControllerOffhand);

    @NotNull
    private final Function<PoseData, PoseElement> supplier;

    private PoseAnchor(Function<PoseData, PoseElement> supplier) {
        this.supplier = supplier;
    }

    @NotNull
    public PoseElement getAnchor(@NotNull PoseData poseData) {
        return this.supplier.apply(poseData);
    }

    @NotNull
    public class_2561 getName() {
        return class_2561.method_43471((String)("visor.options.enums.PoseAnchor." + this.name()));
    }

    @NotNull
    public Vector3f anchorPos(@NotNull PoseData poseData, @NotNull Vector3fc offset) {
        PoseElement anchor = this.getAnchor(poseData);
        float worldScale = poseData.getWorldScale();
        offset = new Vector3f(offset.x() * worldScale, offset.y() * worldScale, offset.z() * worldScale);
        if (anchor == PoseElement.EMPTY) {
            return new Vector3f(offset.x(), offset.y(), offset.z());
        }
        return anchor.getCustomVector(offset).add(anchor.getPosition());
    }

    @NotNull
    public Matrix4f anchorRotation(@NotNull PoseData poseData, @NotNull Vector3fc offset) {
        PoseElement anchor = this.getAnchor(poseData);
        if (anchor == PoseElement.EMPTY) {
            return new Matrix4f().rotationZYX(offset.z(), offset.y(), offset.x());
        }
        return anchor.getRotation().mul((Matrix4fc)new Matrix4f().rotationZYX(offset.z(), offset.y(), offset.x()), new Matrix4f());
    }

    @NotNull
    public Matrix4f anchorRotationAim(@NotNull PoseData poseData, @NotNull Vector3fc offset, @NotNull Vector3fc objPosition) {
        PoseElement anchor = this.getAnchor(poseData);
        if (anchor == PoseElement.EMPTY) {
            return new Matrix4f().rotationZYX(offset.z(), offset.y(), offset.x());
        }
        Vector3fc anchorPos = anchor.getPosition();
        Vector3f directionToTarget = new Vector3f(objPosition.x() - anchorPos.x(), objPosition.y() - anchorPos.y(), objPosition.z() - anchorPos.z());
        float rotationX = (float)Math.asin(directionToTarget.y() / directionToTarget.length());
        float rotationY = (float)(3.1415927410125732 + class_3532.method_15349((double)directionToTarget.x(), (double)directionToTarget.z()));
        return new Matrix4f().rotationZYX(offset.z(), rotationY + offset.y(), rotationX + offset.x());
    }

    @NotNull
    public Vector3f reverseAnchoredRotation(@NotNull Matrix4fc anchorRotation, @NotNull Matrix4fc objRotation) {
        Matrix4f invRotation = objRotation.invert(new Matrix4f());
        Matrix4f matrix4f = invRotation.mul(anchorRotation);
        float offsetY = (float)Math.asin(-matrix4f.m20());
        float offsetZ = (float)class_3532.method_15349((double)matrix4f.m10(), (double)matrix4f.m00());
        float offsetX = (float)class_3532.method_15349((double)matrix4f.m21(), (double)matrix4f.m22());
        return new Vector3f(offsetX, offsetY, offsetZ);
    }

    public static Vector3f getAnchorPos(@NotNull Vector3fc anchorPosition, @NotNull Matrix4fc anchorRotation, @NotNull Vector3fc offset) {
        PoseData renderPose = VisorAPI.client().getPlayer().getPoseData(PoseDataType.RENDER);
        float worldScale = renderPose.getWorldScale();
        offset = new Vector3f(offset.x() * worldScale, offset.y() * worldScale, offset.z() * worldScale);
        return PoseAnchor.getCustomVector(offset, anchorRotation).add(anchorPosition);
    }

    public static Matrix4f getAnchorRotation(@NotNull Matrix4fc anchorRotation, @NotNull Vector3fc offset) {
        return anchorRotation.mul((Matrix4fc)new Matrix4f().rotationZYX(offset.z(), offset.y(), offset.x()), new Matrix4f());
    }

    public static Matrix4f getAnchorRotationAimed(@NotNull Vector3fc objPosition, @NotNull Vector3fc anchorPosition, @NotNull Vector3fc offset) {
        Vector3f directionToTarget = new Vector3f(objPosition.x() - anchorPosition.x(), objPosition.y() - anchorPosition.y(), objPosition.z() - anchorPosition.z());
        float rotationX = (float)Math.asin(directionToTarget.y() / directionToTarget.length());
        float rotationY = (float)(3.1415927410125732 + class_3532.method_15349((double)directionToTarget.x(), (double)directionToTarget.z()));
        return new Matrix4f().rotationZYX(offset.z(), rotationY + offset.y(), rotationX + offset.x());
    }

    @NotNull
    private static Vector3f getCustomVector(@NotNull Vector3fc vec, @NotNull Matrix4fc rotationMatrix) {
        return rotationMatrix.transformDirection(new Vector3f(vec.x(), vec.y(), vec.z()));
    }

    @NotNull
    public Function<PoseData, PoseElement> getSupplier() {
        return this.supplier;
    }
}

