/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.api.client.gui;

import java.util.function.Function;
import me.phoenixra.visor.api.client.data.PoseData;
import me.phoenixra.visor.api.client.data.PoseElement;
import me.phoenixra.visor.api.client.gui.overlays.VROverlay;
import me.phoenixra.visor.api.client.gui.overlays.framework.VROverlayScreen;
import me.phoenixra.visor.api.common.ControllerHand;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4fc;
import org.joml.Vector2f;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public interface VRCursorHandler {
    @NotNull
    public ControllerHand getCursorHand();

    public void setCursorHand(@NotNull ControllerHand var1);

    @Nullable
    public VROverlay getForceFocused();

    public void setForceFocused(@Nullable VROverlay var1);

    public boolean isTwoHandedCursor();

    @Nullable(value="Not focused, or hand is not a cursor")
    public @Nullable(value="Not focused, or hand is not a cursor") VROverlay getFocusedOverlay(@NotNull ControllerHand var1);

    @Nullable(value="Not focused")
    default public @Nullable(value="Not focused") VROverlay getFocusedOverlay() {
        return this.getFocusedOverlay(this.getCursorHand());
    }

    @Nullable(value="Not focused, or focused at different overlay type, or hand is not a cursor")
    default public @Nullable(value="Not focused, or focused at different overlay type, or hand is not a cursor") VROverlayScreen getFocusedOverlayScreen(@NotNull ControllerHand hand) {
        VROverlay vROverlay = this.getFocusedOverlay(hand);
        if (vROverlay instanceof VROverlayScreen) {
            VROverlayScreen overlayScreen = (VROverlayScreen)vROverlay;
            return overlayScreen;
        }
        return null;
    }

    @Nullable(value="Not focused or focused at different overlay type")
    default public @Nullable(value="Not focused or focused at different overlay type") VROverlayScreen getFocusedOverlayScreen() {
        return this.getFocusedOverlayScreen(this.getCursorHand());
    }

    default public boolean isCursorHandFocused() {
        return this.getFocusedOverlay(this.getCursorHand()) != null;
    }

    default public boolean isHandFocused(@NotNull ControllerHand hand) {
        return this.getFocusedOverlay(hand) != null;
    }

    default public boolean isAnyHandFocused() {
        return this.isHandFocused(ControllerHand.MAIN) || this.isHandFocused(ControllerHand.OFFHAND);
    }

    @NotNull
    public CursorResult getCursorResult(@NotNull ControllerHand var1, @NotNull PoseData var2, @Nullable Function<VROverlay, Boolean> var3, boolean var4);

    public double getCursorLineLength(@NotNull ControllerHand var1);

    public boolean isFacingOverlay(@NotNull PoseElement var1, @NotNull VROverlay var2, boolean var3);

    @NotNull
    public Vector3f findCursorPosition3D(@NotNull PoseElement var1, @NotNull Vector3fc var2, @NotNull Matrix4fc var3, float var4, float var5);

    @NotNull
    default public Vector2f findCursorPosition2D(@NotNull PoseElement element, @NotNull Vector3fc guiPosition, @NotNull Matrix4fc guiRotation, float guiScale, float guiAspectRatio) {
        Vector3f vec3 = this.findCursorPosition3D(element, guiPosition, guiRotation, guiScale, guiAspectRatio);
        return new Vector2f(vec3.x, vec3.y);
    }

    public record CursorResult(@NotNull Vector3fc cursorPos, @Nullable VROverlay focusedOverlay) {
    }
}

