/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.api.client.gui.helpers;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import me.phoenixra.atumvr.api.misc.color.AtumColor;
import me.phoenixra.visor.api.client.gui.GuiTexture;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_2960;
import net.minecraft.class_310;

public class TexturesHelper {
    private static final Map<AtumColor, class_2960> CACHE = new ConcurrentHashMap<AtumColor, class_2960>();
    private static final Map<AtumColor, GuiTexture> CACHE_GUI = new ConcurrentHashMap<AtumColor, GuiTexture>();
    private static final AtumColor WHITE_COLOR = AtumColor.WHITE;
    private static final AtumColor BLACK_COLOR = AtumColor.BLACK;

    private TexturesHelper() {
        throw new UnsupportedOperationException("This is an utility class and cannot be instantiated");
    }

    public static class_2960 getWhiteTexture() {
        return TexturesHelper.getColorTexture(WHITE_COLOR);
    }

    public static class_2960 getBlackTexture() {
        return TexturesHelper.getColorTexture(BLACK_COLOR);
    }

    public static class_2960 getColorTexture(AtumColor color) {
        return CACHE.computeIfAbsent(color, TexturesHelper::createAndRegister);
    }

    public static GuiTexture getColorGuiTexture(AtumColor color) {
        return CACHE_GUI.computeIfAbsent(color, it -> new GuiTexture(TexturesHelper.getColorTexture(color), 0, 0, 1, 1));
    }

    private static class_2960 createAndRegister(AtumColor color) {
        class_1011 img = new class_1011(class_1011.class_1012.field_4997, 1, 1, true);
        img.method_4305(0, 0, color.toInt());
        class_1043 tex = new class_1043(img);
        String name = String.format("visor_%02x%02x%02x%02x", color.getRedInt(), color.getGreenInt(), color.getBlueInt(), color.getAlphaInt());
        return class_310.method_1551().method_1531().method_4617(name, tex);
    }
}

