/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.api.client.gui.overlays;

import java.util.Collection;
import me.phoenixra.atumconfig.api.config.ConfigFile;
import me.phoenixra.visor.api.VisorAPI;
import me.phoenixra.visor.api.client.data.PoseAnchor;
import me.phoenixra.visor.api.client.data.PoseDataType;
import me.phoenixra.visor.api.client.gui.GuiTexture;
import me.phoenixra.visor.api.client.gui.overlays.VROverlayCursorData;
import me.phoenixra.visor.api.client.gui.overlays.VROverlayPose;
import me.phoenixra.visor.api.client.gui.overlays.VROverlayTemplate;
import me.phoenixra.visor.api.client.gui.overlays.options.OverlayOptionGroup;
import me.phoenixra.visor.api.common.addon.element.PrioritySupporter;
import me.phoenixra.visor.api.common.addon.element.VisorElement;
import net.minecraft.class_2561;
import net.minecraft.class_276;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3fc;

public interface VROverlay
extends VisorElement,
PrioritySupporter {
    public void method_25393();

    public void updatePose(float var1);

    @NotNull
    public VROverlayPose getPose();

    @Nullable
    public class_276 getRenderTarget();

    default public boolean isInViewDistance() {
        Vector3fc hmdPos = VisorAPI.client().getPlayer().getPoseData(PoseDataType.PRE_TICK).getHmd().getPosition();
        return hmdPos.distance(this.getPose().getPosition()) < 5.0f;
    }

    public boolean isVisible();

    default public boolean isCustom() {
        return this.asTemplate() != null;
    }

    default public boolean isBuiltIn() {
        return this.asTemplate() == null;
    }

    @NotNull
    default public class_2561 getName() {
        return class_2561.method_43470((String)this.getId());
    }

    @NotNull
    default public class_2561 getDescription() {
        return class_2561.method_43470((String)"No description");
    }

    @NotNull
    default public GuiTexture getIcon() {
        return this.getOwner().getAddonIcon();
    }

    @NotNull
    public Collection<OverlayOptionGroup<?>> getOptions();

    @Nullable
    public OverlayOptionGroup<?> getOption(@NotNull String var1);

    @Nullable
    default public <T extends OverlayOptionGroup<?>> T getOption(@NotNull String id, @NotNull Class<T> type) {
        OverlayOptionGroup<?> optionGroup = this.getOption(id);
        if (type.isInstance(optionGroup)) {
            return (T)((OverlayOptionGroup)type.cast(optionGroup));
        }
        return null;
    }

    @Nullable
    public ConfigFile getOptionsConfig();

    default public void reloadOptions() {
        boolean reloadFile = true;
        for (OverlayOptionGroup<?> option : this.getOptions()) {
            option.loadFromFile(reloadFile);
            reloadFile = false;
        }
    }

    default public void reloadOption(@NotNull String id) {
        OverlayOptionGroup<?> option = this.getOption(id);
        if (option == null) {
            return;
        }
        option.loadFromFile(true);
    }

    @Nullable
    public PoseAnchor getForcedAnchor();

    public void setForcedAnchor(@Nullable PoseAnchor var1);

    @Nullable
    default public VROverlayTemplate asTemplate() {
        VROverlay vROverlay = this;
        if (vROverlay instanceof VROverlayTemplate) {
            VROverlayTemplate overlayTemplate = (VROverlayTemplate)vROverlay;
            return overlayTemplate;
        }
        return null;
    }

    default public boolean supportsVisibilityUpdateOnRender() {
        return false;
    }

    default public boolean supportsDepth() {
        return false;
    }

    default public boolean supportsLight() {
        return true;
    }

    default public boolean supportsCursor() {
        return true;
    }

    default public boolean supportsCursorIgnoreVisible() {
        return false;
    }

    default public boolean supportsTwoCursors() {
        return false;
    }

    @NotNull
    public VROverlayCursorData getActiveCursorData();

    @NotNull
    public VROverlayCursorData getInactiveCursorData();

    default public int getWidth() {
        return VisorAPI.client().getGuiManager().getGuiScaledWidth();
    }

    default public int getHeight() {
        return VisorAPI.client().getGuiManager().getGuiScaledHeight();
    }

    default public float getAspectRatio() {
        return (float)this.getHeight() / (float)this.getWidth();
    }

    default public int getCursorBoundsX() {
        return -1;
    }

    default public int getCursorBoundsY() {
        return -1;
    }

    default public int getCursorBoundsWidth() {
        return -1;
    }

    default public int getCursorBoundsHeight() {
        return -1;
    }

    public void updateCursorData(boolean var1, float var2, float var3);

    default public boolean isWithinCursorBounds(float rawX, float rawY) {
        if (rawX < 0.0f || rawX > 1.0f || rawY < 0.0f || rawY > 1.0f) {
            return false;
        }
        int edgeX = this.getCursorBoundsX();
        int edgeY = this.getCursorBoundsY();
        int edgeWidth = this.getCursorBoundsWidth();
        int edgeHeight = this.getCursorBoundsHeight();
        int width = this.getWidth();
        int height = this.getHeight();
        if (width > 0 && height > 0 && edgeX >= 0 && edgeY >= 0 && edgeWidth >= 0 && edgeHeight >= 0) {
            int px = (int)(rawX * (float)width);
            int py = (int)(rawY * (float)height);
            return px >= edgeX && px <= edgeX + edgeWidth && py >= edgeY && py <= edgeY + edgeHeight;
        }
        return true;
    }

    default public int getMouseX() {
        return this.getActiveCursorData().getCursorX();
    }

    default public int getMouseY() {
        return this.getActiveCursorData().getCursorY();
    }

    default public float getRawMouseX() {
        return this.getActiveCursorData().getRawCursorX();
    }

    default public float getRawMouseY() {
        return this.getActiveCursorData().getRawCursorY();
    }

    public boolean method_25402(double var1, double var3, int var5);

    public boolean method_25406(double var1, double var3, int var5);

    public boolean method_25401(double var1, double var3, double var5);

    public void method_16014(double var1, double var3);

    public boolean method_25403(double var1, double var3, int var5, double var6, double var8);

    public boolean method_25404(int var1, int var2, int var3);

    public boolean method_16803(int var1, int var2, int var3);

    public boolean method_25400(char var1, int var2);

    @Override
    default public int compareTo(@NotNull PrioritySupporter o) {
        return Integer.compare(-o.getPriority().getWeight(), -this.getPriority().getWeight());
    }
}

