/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.api.client.gui.overlays;

import me.phoenixra.visor.api.VisorAPI;
import me.phoenixra.visor.api.client.data.PoseAnchor;
import me.phoenixra.visor.api.client.data.PoseData;
import me.phoenixra.visor.api.client.data.PoseDataType;
import me.phoenixra.visor.api.client.gui.overlays.VROverlay;
import me.phoenixra.visor.api.client.gui.overlays.VROverlayPose;
import me.phoenixra.visor.api.common.utils.VRMathUtils;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class VROverlayHelper {
    private VROverlayHelper() {
        throw new UnsupportedOperationException("This is an utility class and cannot be instantiated");
    }

    public static void applyRoomPose(@NotNull VROverlay overlay, float overlayScale, @NotNull Vector3fc roomPosition, @NotNull Matrix4f roomRotation) {
        PoseData renderPose = VisorAPI.client().getPlayer().getPoseData(PoseDataType.RENDER);
        Vector3f renderScreenPos = renderPose.convertPositionFrom(PoseDataType.ROOM, roomPosition);
        Matrix4f renderScreenRotation = renderPose.convertRotationFrom(PoseDataType.ROOM, (Matrix4fc)roomRotation);
        overlay.getPose().update((Vector3fc)renderScreenPos, (Matrix4fc)renderScreenRotation, overlayScale);
    }

    public static void applyPose(@NotNull VROverlay overlay, @NotNull PoseAnchor positionAnchor, @NotNull PoseAnchor rotationAnchor, float overlayScale, boolean aimRotation, @NotNull Vector3fc positionOffset, @NotNull Vector3fc rotationOffset) {
        PoseData renderPose = VisorAPI.client().getPlayer().getPoseData(PoseDataType.RENDER);
        Vector3f newPosition = positionAnchor.anchorPos(renderPose, positionOffset);
        Matrix4f newRotation = aimRotation ? rotationAnchor.anchorRotationAim(renderPose, rotationOffset, (Vector3fc)newPosition) : rotationAnchor.anchorRotation(renderPose, rotationOffset);
        overlay.getPose().update((Vector3fc)newPosition, (Matrix4fc)newRotation, overlayScale);
    }

    public static void applyPose(@NotNull VROverlay overlay, @NotNull PoseAnchor positionAnchor, @NotNull PoseAnchor rotationAnchor, float overlayScale, boolean aimRotation) {
        VROverlayHelper.applyPose(overlay, positionAnchor, rotationAnchor, overlayScale, aimRotation, VRMathUtils.ZERO_VECTOR, VRMathUtils.ZERO_VECTOR);
    }

    public static void anchorWithOverlay(@NotNull VROverlay targetOverlay, float targetNormalX, float targetNormalY, boolean targetUseCursorBounds, @NotNull VROverlay anchorOverlay, float anchorNormalX, float anchorNormalY, boolean anchorUseCursorBounds, @NotNull Vector3fc positionOffset, @NotNull Vector3fc rotationOffset) {
        VROverlayPose targetPose = targetOverlay.getPose();
        VROverlayPose anchorPose = anchorOverlay.getPose();
        PoseData renderPose = VisorAPI.client().getPlayer().getPoseData(PoseDataType.RENDER);
        float worldScale = renderPose.getWorldScale();
        Vector3f anchorPointWorld = anchorPose.getPositionAt(anchorNormalX, anchorNormalY, anchorUseCursorBounds, PoseDataType.RENDER);
        Vector3f originWorld = new Vector3f(targetPose.getPosition());
        Vector3f targetPointWorld = targetPose.getPositionAt(targetNormalX, targetNormalY, targetUseCursorBounds, PoseDataType.RENDER);
        Vector3f worldOffsetOld = new Vector3f((Vector3fc)targetPointWorld).sub((Vector3fc)originWorld);
        Matrix4f invTargetRot = new Matrix4f(targetPose.getRotation()).invert();
        Vector3f localOffset = invTargetRot.transformDirection((Vector3fc)worldOffsetOld, new Vector3f());
        Matrix4f newRot = new Matrix4f(anchorPose.getRotation()).mul((Matrix4fc)new Matrix4f().rotationZYX(rotationOffset.z(), rotationOffset.y(), rotationOffset.x()), new Matrix4f());
        Vector3f worldOffsetNew = new Vector3f((Vector3fc)localOffset).mul(worldScale);
        newRot.transformDirection(worldOffsetNew);
        Vector3f posOffScaled = new Vector3f(positionOffset).mul(worldScale);
        Vector3f posOffWorld = new Vector3f((Vector3fc)posOffScaled);
        anchorPose.getRotation().transformDirection(posOffWorld);
        Vector3f newOrigin = new Vector3f((Vector3fc)anchorPointWorld).add((Vector3fc)posOffWorld).sub((Vector3fc)worldOffsetNew);
        targetPose.updateOnlyPosAndRotation((Vector3fc)newOrigin, (Matrix4fc)newRot);
    }

    public static void anchorWithOverlay(@NotNull VROverlay targetOverlay, float targetNormalX, float targetNormalY, int[] targetCustomBounds, @NotNull VROverlay anchorOverlay, float anchorNormalX, float anchorNormalY, int[] anchorCustomBounds, @NotNull Vector3fc positionOffset, @NotNull Vector3fc rotationOffset) {
        VROverlayPose targetPose = targetOverlay.getPose();
        VROverlayPose anchorPose = anchorOverlay.getPose();
        PoseData renderPose = VisorAPI.client().getPlayer().getPoseData(PoseDataType.RENDER);
        float worldScale = renderPose.getWorldScale();
        Vector3f anchorPointWorld = anchorPose.getPositionAt(anchorNormalX, anchorNormalY, anchorCustomBounds, PoseDataType.RENDER);
        Vector3f originWorld = new Vector3f(targetPose.getPosition());
        Vector3f targetPointWorld = targetPose.getPositionAt(targetNormalX, targetNormalY, targetCustomBounds, PoseDataType.RENDER);
        Vector3f worldOffsetOld = new Vector3f((Vector3fc)targetPointWorld).sub((Vector3fc)originWorld);
        Matrix4f invTargetRot = new Matrix4f(targetPose.getRotation()).invert();
        Vector3f localOffset = invTargetRot.transformDirection((Vector3fc)worldOffsetOld, new Vector3f());
        Matrix4f newRot = new Matrix4f(anchorPose.getRotation()).mul((Matrix4fc)new Matrix4f().rotationZYX(rotationOffset.z(), rotationOffset.y(), rotationOffset.x()), new Matrix4f());
        Vector3f worldOffsetNew = new Vector3f((Vector3fc)localOffset).mul(worldScale);
        newRot.transformDirection(worldOffsetNew);
        Vector3f posOffScaled = new Vector3f(positionOffset).mul(worldScale);
        Vector3f posOffWorld = new Vector3f((Vector3fc)posOffScaled);
        anchorPose.getRotation().transformDirection(posOffWorld);
        Vector3f newOrigin = new Vector3f((Vector3fc)anchorPointWorld).add((Vector3fc)posOffWorld).sub((Vector3fc)worldOffsetNew);
        targetPose.updateOnlyPosAndRotation((Vector3fc)newOrigin, (Matrix4fc)newRot);
    }
}

