/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.api.client.gui.overlays.framework;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import me.phoenixra.atumconfig.api.config.ConfigFile;
import me.phoenixra.visor.api.VisorAPI;
import me.phoenixra.visor.api.client.data.PoseAnchor;
import me.phoenixra.visor.api.client.gui.VRKeyboardAccessor;
import me.phoenixra.visor.api.client.gui.overlays.VROverlay;
import me.phoenixra.visor.api.client.gui.overlays.VROverlayCursorData;
import me.phoenixra.visor.api.client.gui.overlays.VROverlayHelper;
import me.phoenixra.visor.api.client.gui.overlays.VROverlayPose;
import me.phoenixra.visor.api.client.gui.overlays.options.OverlayOptionGroup;
import me.phoenixra.visor.api.common.addon.VisorAddon;
import me.phoenixra.visor.api.common.addon.element.ElementPriority;
import net.minecraft.class_2561;
import net.minecraft.class_276;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public abstract class VROverlayScreen
extends class_437
implements VROverlay {
    @NotNull
    private final String id;
    @NotNull
    private final VisorAddon owner;
    private final ElementPriority priority;
    private final VROverlayPose pose;
    @Nullable
    private PoseAnchor forcedAnchor;
    private class_276 renderTarget;
    protected final Map<String, OverlayOptionGroup<?>> optionsMap;
    @NotNull
    private final Collection<OverlayOptionGroup<?>> options;
    protected final ConfigFile optionsConfig;
    private final VROverlayCursorData activeCursorData = new VROverlayCursorData();
    private final VROverlayCursorData inactiveCursorData = new VROverlayCursorData();
    protected int guiScaleFactor = 0;
    protected int cursorBoundsX = -1;
    protected int cursorBoundsY = -1;
    protected int cursorBoundsWidth = -1;
    protected int cursorBoundsHeight = -1;
    private boolean enabled = false;
    private boolean visible;
    protected boolean initAgain;
    private static long mouseDragDelay;

    public VROverlayScreen(@NotNull VisorAddon owner, @NotNull String id) {
        this(owner, id, ElementPriority.NORMAL, 1.0f);
    }

    public VROverlayScreen(@NotNull VisorAddon owner, @NotNull String id, @NotNull ElementPriority priority, float overlayScale) {
        super((class_2561)class_2561.method_43470((String)id));
        Objects.requireNonNull(owner);
        Objects.requireNonNull(id);
        Objects.requireNonNull(priority);
        if (overlayScale <= 0.0f) {
            throw new RuntimeException("overlayScale cannot be less or equal '0'");
        }
        this.owner = owner;
        this.id = id;
        this.priority = priority;
        this.pose = new VROverlayPose(this, overlayScale);
        this.field_22787 = class_310.method_1551();
        this.optionsMap = new LinkedHashMap();
        List<OverlayOptionGroup<?>> preOptions = this.createOptions();
        preOptions.forEach(it -> this.optionsMap.put(it.getId(), (OverlayOptionGroup<?>)it));
        this.options = Collections.unmodifiableCollection(this.optionsMap.values());
        if (!this.optionsMap.isEmpty()) {
            try {
                this.optionsConfig = VisorAPI.client().getGuiManager().getOverlayManager().getOverlayConfigAccessor().getConfigOrCreate(this);
                this.initOptions();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else {
            this.optionsConfig = null;
        }
    }

    protected void onPreTick() {
    }

    protected void onTick() {
    }

    protected void onPreRender(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
    }

    protected void onRender(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
    }

    protected abstract void onUpdatePose(float var1);

    protected abstract boolean updateVisibility();

    protected void onEnable() {
    }

    protected void onDisable() {
    }

    public int getRequestedWidth() {
        return VisorAPI.client().getGuiManager().getGuiWidth();
    }

    public int getRequestedHeight() {
        return VisorAPI.client().getGuiManager().getGuiHeight();
    }

    public final int getRequestedWidthScaled() {
        return class_3532.method_15386((float)((float)this.getRequestedWidth() / (float)this.guiScaleFactor));
    }

    public final int getRequestedHeightScaled() {
        return class_3532.method_15386((float)((float)this.getRequestedHeight() / (float)this.guiScaleFactor));
    }

    @NotNull
    protected List<OverlayOptionGroup<?>> createOptions() {
        return List.of();
    }

    protected void initOptions() {
        for (OverlayOptionGroup<?> option : this.options) {
            option.init();
        }
    }

    @Override
    public final void method_25393() {
        this.onPreTick();
        this.visible = this.enabled && this.updateVisibility();
        VisorAPI.client().getRenderer().updateOverlayTarget(this);
        this.visible = this.visible && this.renderTarget != null;
        this.onTick();
    }

    public final void method_25394(@NotNull class_332 guiGraphics, int pMouseX, int pMouseY, float partialTicks) {
        if (this.initAgain) {
            this.method_25426();
            this.initAgain = false;
        }
        if (this.supportsVisibilityUpdateOnRender()) {
            this.visible = this.enabled && this.updateVisibility();
            VisorAPI.client().getRenderer().updateOverlayTarget(this);
            boolean bl = this.visible = this.visible && this.renderTarget != null;
            if (!this.visible) {
                return;
            }
        }
        this.onPreRender(guiGraphics, pMouseX, pMouseY, partialTicks);
        super.method_25394(guiGraphics, pMouseX, pMouseY, partialTicks);
        this.onRender(guiGraphics, pMouseX, pMouseY, partialTicks);
    }

    @Override
    public final void updatePose(float partialTicks) {
        if (this.forcedAnchor != null) {
            VROverlayHelper.applyPose(this, this.forcedAnchor, this.forcedAnchor, this.getPose().getScale(), false, (Vector3fc)new Vector3f(0.0f, 0.0f, -0.3f), (Vector3fc)new Vector3f(0.0f, 0.0f, 0.0f));
            return;
        }
        this.onUpdatePose(partialTicks);
    }

    public void method_25420(@NotNull class_332 guiGraphics) {
    }

    @Override
    public void setEnabled(boolean flag) {
        if (flag == this.enabled) {
            return;
        }
        if (flag) {
            this.enabled = true;
            this.updateSize();
            this.onEnable();
        } else {
            this.enabled = false;
            this.visible = false;
            VRKeyboardAccessor keyboardAccessor = VisorAPI.client().getGuiManager().getOverlayManager().getKeyboardAccessor();
            if (keyboardAccessor.getAttachedTo() == this) {
                keyboardAccessor.setVisible(false);
            }
            this.onDisable();
        }
    }

    public boolean canDragMouse() {
        return mouseDragDelay < System.currentTimeMillis();
    }

    public void startDragMouse() {
        mouseDragDelay = System.currentTimeMillis() + 100L;
    }

    public void finishDragMouse() {
        mouseDragDelay = Long.MAX_VALUE;
    }

    public void updateSize() {
        this.guiScaleFactor = VisorAPI.client().getGuiManager().calculateScale(0, this.getRequestedWidth(), this.getRequestedHeight());
        this.method_25423(class_310.method_1551(), this.getRequestedWidthScaled(), this.getRequestedHeightScaled());
    }

    @Override
    public void updateCursorData(boolean activeCursor, float rawX, float rawY) {
        if (!this.enabled) {
            return;
        }
        if (rawX < 0.0f || rawX > 1.0f || rawY < 0.0f || rawY > 1.0f) {
            return;
        }
        VROverlayCursorData cursorData = activeCursor ? this.activeCursorData : this.inactiveCursorData;
        int oldMouseX = cursorData.getCursorX();
        int oldMouseY = cursorData.getCursorY();
        cursorData.setRawCursorX(rawX);
        cursorData.setRawCursorY(rawY);
        cursorData.setCursorX((int)((double)rawX * (double)this.field_22789));
        cursorData.setCursorY((int)((double)rawY * (double)this.field_22790));
        if (!activeCursor) {
            return;
        }
        this.method_16014(cursorData.getCursorX(), cursorData.getCursorY());
        if (this.canDragMouse()) {
            int deltaX = cursorData.getCursorX() - oldMouseX;
            int deltaY = cursorData.getCursorY() - oldMouseY;
            this.method_25403(cursorData.getCursorX(), cursorData.getCursorY(), 0, deltaX, deltaY);
        }
    }

    @Override
    public boolean isVisible() {
        return this.visible && this.enabled;
    }

    @Override
    @Nullable
    public OverlayOptionGroup<?> getOption(@NotNull String id) {
        return this.optionsMap.get(id);
    }

    @Override
    public boolean method_25402(double mouseX, double mouseY, int buttonType) {
        return super.method_25402(mouseX, mouseY, buttonType);
    }

    @Override
    public boolean method_25406(double mouseX, double mouseY, int buttonType) {
        return super.method_25406(mouseX, mouseY, buttonType);
    }

    @Override
    public boolean method_25401(double mouseX, double mouseY, double scrollDelta) {
        return super.method_25401(mouseX, mouseY, scrollDelta);
    }

    @Override
    public void method_16014(double mouseX, double mouseY) {
        super.method_16014(mouseX, mouseY);
    }

    @Override
    public boolean method_25403(double mouseX, double mouseY, int buttonType, double deltaX, double deltaY) {
        return super.method_25403(mouseX, mouseY, buttonType, deltaX, deltaY);
    }

    @Override
    public boolean method_16803(int i, int j, int k) {
        return super.method_16803(i, j, k);
    }

    @Override
    public boolean method_25400(char chr, int modifiers) {
        return super.method_25400(chr, modifiers);
    }

    @Override
    public int getWidth() {
        return this.field_22789;
    }

    @Override
    public int getHeight() {
        return this.field_22790;
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    @Override
    @NotNull
    public VisorAddon getOwner() {
        return this.owner;
    }

    @Override
    public ElementPriority getPriority() {
        return this.priority;
    }

    @Override
    public VROverlayPose getPose() {
        return this.pose;
    }

    @Override
    @Nullable
    public PoseAnchor getForcedAnchor() {
        return this.forcedAnchor;
    }

    @Override
    public void setForcedAnchor(@Nullable PoseAnchor forcedAnchor) {
        this.forcedAnchor = forcedAnchor;
    }

    @Override
    public class_276 getRenderTarget() {
        return this.renderTarget;
    }

    public void setRenderTarget(class_276 renderTarget) {
        this.renderTarget = renderTarget;
    }

    @Override
    @NotNull
    public Collection<OverlayOptionGroup<?>> getOptions() {
        return this.options;
    }

    @Override
    public ConfigFile getOptionsConfig() {
        return this.optionsConfig;
    }

    @Override
    public VROverlayCursorData getActiveCursorData() {
        return this.activeCursorData;
    }

    @Override
    public VROverlayCursorData getInactiveCursorData() {
        return this.inactiveCursorData;
    }

    public int getGuiScaleFactor() {
        return this.guiScaleFactor;
    }

    @Override
    public int getCursorBoundsX() {
        return this.cursorBoundsX;
    }

    @Override
    public int getCursorBoundsY() {
        return this.cursorBoundsY;
    }

    @Override
    public int getCursorBoundsWidth() {
        return this.cursorBoundsWidth;
    }

    @Override
    public int getCursorBoundsHeight() {
        return this.cursorBoundsHeight;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }
}

