/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.api.client.gui.overlays.framework.template;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import me.phoenixra.visor.api.client.gui.GuiTexture;
import me.phoenixra.visor.api.client.gui.overlays.RegisterVROverlayTemplate;
import me.phoenixra.visor.api.client.gui.overlays.VROverlay;
import me.phoenixra.visor.api.client.gui.overlays.VROverlayHelper;
import me.phoenixra.visor.api.client.gui.overlays.VROverlayTemplate;
import me.phoenixra.visor.api.client.gui.overlays.framework.VROverlayScreen;
import me.phoenixra.visor.api.client.gui.overlays.options.OverlayOptionGroup;
import me.phoenixra.visor.api.client.gui.overlays.options.types.OverlayOptionsIdentity;
import me.phoenixra.visor.api.client.gui.overlays.options.types.OverlayOptionsMisc;
import me.phoenixra.visor.api.client.gui.overlays.options.types.OverlayOptionsPose;
import me.phoenixra.visor.api.common.addon.VisorAddon;
import me.phoenixra.visor.api.common.addon.element.ElementPriority;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3fc;

public abstract class VROverlayTemplateScreen
extends VROverlayScreen
implements VROverlayTemplate {
    private final String templateId;
    private final class_2561 templateName;
    private final class_2561 templateDescription;
    private class_2561 name;
    private class_2561 description;
    private GuiTexture icon;
    protected final OverlayOptionsIdentity optionsIdentity;
    protected final OverlayOptionsMisc optionsMisc;
    protected final OverlayOptionsPose optionsPose;
    protected boolean initializedPose;

    public VROverlayTemplateScreen(@NotNull VisorAddon owner, @NotNull String id) {
        this(owner, id, ElementPriority.NORMAL, 1.0f);
    }

    public VROverlayTemplateScreen(@NotNull VisorAddon owner, @NotNull String id, @NotNull ElementPriority priority, float overlayScale) {
        super(owner, id, priority, overlayScale);
        RegisterVROverlayTemplate annotation = this.getClass().getAnnotation(RegisterVROverlayTemplate.class);
        this.templateId = annotation.id();
        this.templateName = class_2561.method_43471((String)annotation.name());
        this.templateDescription = class_2561.method_43471((String)annotation.description());
        if (this.getOptions().isEmpty()) {
            throw new IllegalArgumentException("Tried to instantiate an overlay template '%s' with NO OPTIONS".formatted(this.templateId));
        }
        this.optionsIdentity = (OverlayOptionsIdentity)this.getOption("identity", OverlayOptionsIdentity.class);
        this.optionsMisc = (OverlayOptionsMisc)this.getOption("misc", OverlayOptionsMisc.class);
        this.optionsPose = (OverlayOptionsPose)this.getOption("pose", OverlayOptionsPose.class);
        Objects.requireNonNull(this.optionsIdentity);
        this.updateIdentity();
    }

    @NotNull
    protected abstract List<OverlayOptionGroup<?>> createTemplateOptions();

    @Override
    @NotNull
    protected final List<OverlayOptionGroup<?>> createOptions() {
        ArrayList options = new ArrayList();
        options.add(new OverlayOptionsIdentity((VROverlay)this, it -> {
            class_2960 defIcon = VisorAddon.MISSING_ICON.getResourceLocation();
            it.setName(this.getId());
            it.setDescription("No description");
            it.setIcon(defIcon.method_12836() + ":" + defIcon.method_12832());
        }));
        options.addAll(this.createTemplateOptions());
        return options;
    }

    @Override
    protected final void initOptions() {
        RegisterVROverlayTemplate annotation = this.getClass().getAnnotation(RegisterVROverlayTemplate.class);
        this.optionsConfig.set("template", annotation.id());
        super.initOptions();
    }

    @Override
    protected void onPreTick() {
        if (this.optionsMisc != null && this.optionsMisc.getOptionsUpdaterType() == OverlayOptionsMisc.OptionsUpdaterType.TICK) {
            this.optionsMap.forEach((key, value) -> value.update(false));
        }
        if (this.optionsPose != null && this.optionsPose.isTickPose()) {
            this.updatePose(1.0f);
        }
    }

    @Override
    protected void onPreRender(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
        if (this.optionsMisc != null && this.optionsMisc.getOptionsUpdaterType() == OverlayOptionsMisc.OptionsUpdaterType.FRAME) {
            this.optionsMap.forEach((key, value) -> value.update(false));
        }
    }

    @Override
    public void onUpdatePose(float partialTicks) {
        if (this.optionsPose == null) {
            return;
        }
        if (!this.initializedPose || this.optionsPose.isTickPose()) {
            VROverlayHelper.applyPose(this, this.optionsPose.getPositionAnchor(), this.optionsPose.getRotationAnchor(), this.optionsPose.getScale(), this.optionsPose.isAimedRotation(), (Vector3fc)this.optionsPose.getPositionOffset(), (Vector3fc)this.optionsPose.getRotationOffset());
            this.initializedPose = true;
        }
    }

    @Override
    public void updateIdentity() {
        if (this.optionsIdentity == null) {
            return;
        }
        this.name = this.optionsIdentity.getName();
        this.description = this.optionsIdentity.getDescription();
        this.icon = this.optionsIdentity.getIcon();
    }

    @Override
    public void setEnabled(boolean flag) {
        super.setEnabled(flag);
        if (!flag) {
            this.initializedPose = false;
        }
    }

    @Override
    public final String getTemplateId() {
        return this.templateId;
    }

    @Override
    public final class_2561 getTemplateName() {
        return this.templateName;
    }

    @Override
    public final class_2561 getTemplateDescription() {
        return this.templateDescription;
    }

    @Override
    public final class_2561 getName() {
        return this.name;
    }

    public final void setName(class_2561 name) {
        this.name = name;
    }

    @Override
    public final class_2561 getDescription() {
        return this.description;
    }

    public final void setDescription(class_2561 description) {
        this.description = description;
    }

    @Override
    public final GuiTexture getIcon() {
        return this.icon;
    }

    public final void setIcon(GuiTexture icon) {
        this.icon = icon;
    }
}

