/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.api.client.gui.overlays.options;

import me.phoenixra.visor.api.client.gui.GuiTexture;
import me.phoenixra.visor.api.client.gui.overlays.options.OptionTextures;
import me.phoenixra.visor.api.client.gui.overlays.options.OverlayOptionGroup;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_437;
import org.jetbrains.annotations.NotNull;

public abstract class OptionsScreen<T extends OverlayOptionGroup<?>>
extends class_437 {
    protected final T optionsGroup;
    protected Background background;
    protected int cursorBoundsX = -1;
    protected int cursorBoundsY = -1;
    protected int cursorBoundsWidth = -1;
    protected int cursorBoundsHeight = -1;

    protected OptionsScreen(@NotNull T optionsGroup, @NotNull Background background) {
        super((class_2561)class_2561.method_43473());
        this.optionsGroup = optionsGroup;
        this.background = background;
    }

    protected abstract void onInit();

    protected abstract void onRender(class_332 var1, int var2, int var3, float var4);

    protected void method_25426() {
        if (this.background != Background.EMPTY) {
            this.cursorBoundsX = (this.field_22789 - this.background.texture.getWidth()) / 2;
            this.cursorBoundsY = (this.field_22790 - this.background.texture.getHeight()) / 2;
            this.cursorBoundsWidth = this.background.texture.getWidth();
            this.cursorBoundsHeight = this.background.texture.getHeight();
        }
        this.method_37067();
        this.onInit();
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (this.background != Background.EMPTY) {
            this.background.render(guiGraphics, this.cursorBoundsX, this.cursorBoundsY);
        }
        this.onRender(guiGraphics, mouseX, mouseY, partialTick);
        super.method_25394(guiGraphics, mouseX, mouseY, partialTick);
    }

    public T getOptionsGroup() {
        return this.optionsGroup;
    }

    public Background getBackground() {
        return this.background;
    }

    public int getCursorBoundsX() {
        return this.cursorBoundsX;
    }

    public int getCursorBoundsY() {
        return this.cursorBoundsY;
    }

    public int getCursorBoundsWidth() {
        return this.cursorBoundsWidth;
    }

    public int getCursorBoundsHeight() {
        return this.cursorBoundsHeight;
    }

    protected static enum Background {
        FULL(OptionTextures.BACKGROUND_256x256),
        HORIZONTAL(OptionTextures.BACKGROUND_256x128),
        VERTICAL(OptionTextures.BACKGROUND_128x256),
        VERTICAL_WIDER(OptionTextures.BACKGROUND_175x256),
        EMPTY(null);

        private final GuiTexture texture;

        private Background(GuiTexture texture) {
            this.texture = texture;
        }

        public void render(class_332 guiGraphics, int x, int y) {
            if (this.texture == null) {
                return;
            }
            this.texture.blit(guiGraphics, x, y, this.texture.getWidth(), this.texture.getHeight());
        }

        public GuiTexture getTexture() {
            return this.texture;
        }
    }
}

