/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.api.client.gui.overlays.options;

import java.util.function.Consumer;
import me.phoenixra.atumconfig.api.config.Config;
import me.phoenixra.atumconfig.api.config.ConfigFile;
import me.phoenixra.visor.api.client.gui.overlays.VROverlay;
import me.phoenixra.visor.api.client.gui.overlays.options.OptionsScreen;
import net.minecraft.class_2561;
import org.jetbrains.annotations.NotNull;

public abstract class OverlayOptionGroup<T extends OverlayOptionGroup<T>> {
    protected final VROverlay owner;
    protected final Consumer<T> defaultsSupplier;
    protected ConfigFile overlayConfig;
    protected boolean initialized;
    protected boolean changesNotSaved;

    public OverlayOptionGroup(@NotNull VROverlay owner, @NotNull Consumer<T> defaultsSupplier) {
        this.owner = owner;
        this.defaultsSupplier = defaultsSupplier;
    }

    public void init() {
        this.overlayConfig = this.owner.getOptionsConfig();
        if (this.overlayConfig.getSubsectionOrNull(this.getId().toUpperCase()) == null) {
            this.loadDefaults();
            this.save();
        } else {
            this.loadFromFile(false);
        }
        this.onInit();
        this.initialized = true;
    }

    public final void loadFromFile(boolean reloadFile) {
        if (reloadFile) {
            try {
                this.overlayConfig.reload();
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
        this.onLoad(this.getConfigSection());
        this.changesNotSaved = false;
    }

    public final void loadFromConfig(@NotNull Config config) {
        this.onLoad(config);
        this.changesNotSaved = true;
    }

    public final void loadFromOther(@NotNull OverlayOptionGroup<?> other) {
        if (!this.canCopy()) {
            throw new RuntimeException("This option group does not support direct copying");
        }
        if (!this.canCopyFrom(other)) {
            throw new IllegalArgumentException("This option group cannot copy from the specified option group");
        }
        this.onLoad(other.getConfigSection());
        this.changesNotSaved = true;
    }

    public void loadDefaults() {
        this.defaultsSupplier.accept(this);
        this.update(true);
        this.changesNotSaved = true;
    }

    public final void save() {
        try {
            Config section = this.overlayConfig.getSubsection(this.getId().toUpperCase());
            this.onSave(section);
            this.overlayConfig.set(this.getId().toUpperCase(), section);
            this.overlayConfig.save();
            this.changesNotSaved = false;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public final Config getConfigSection() {
        return this.overlayConfig.getSubsection(this.getId().toUpperCase());
    }

    protected void onInit() {
    }

    public void update(boolean reset) {
    }

    protected abstract void onLoad(@NotNull Config var1);

    protected abstract void onSave(@NotNull Config var1);

    protected abstract boolean supportsCopying();

    public final boolean canCopy() {
        return this.supportsCopying() && !this.changesNotSaved;
    }

    public boolean canCopyFrom(@NotNull OverlayOptionGroup<?> other) {
        if (!this.getClass().isAssignableFrom(other.getClass())) {
            return false;
        }
        return other.canCopy() && this.canCopy();
    }

    @NotNull
    public abstract OptionsScreen<?> getScreen();

    @NotNull
    public abstract class_2561 getDisplayName();

    @NotNull
    public abstract String getId();

    public VROverlay getOwner() {
        return this.owner;
    }

    public Consumer<T> getDefaultsSupplier() {
        return this.defaultsSupplier;
    }

    public ConfigFile getOverlayConfig() {
        return this.overlayConfig;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public boolean isChangesNotSaved() {
        return this.changesNotSaved;
    }
}

