/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.api.client.gui.overlays.options.types;

import java.util.function.Consumer;
import me.phoenixra.atumconfig.api.config.Config;
import me.phoenixra.visor.api.VisorAPI;
import me.phoenixra.visor.api.client.data.PoseAnchor;
import me.phoenixra.visor.api.client.gui.overlays.VROverlay;
import me.phoenixra.visor.api.client.gui.overlays.options.OptionsScreen;
import me.phoenixra.visor.api.client.gui.overlays.options.OverlayOptionGroup;
import net.minecraft.class_2561;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

public class OverlayOptionsPose
extends OverlayOptionGroup<OverlayOptionsPose> {
    public static final String ID = "pose";
    private static final class_2561 NAME = class_2561.method_43471((String)"visor.overlay.options.pose");
    private PoseAnchor positionAnchor;
    private PoseAnchor rotationAnchor;
    private Vector3f positionOffset = new Vector3f();
    private Vector3f rotationOffset = new Vector3f();
    private float scale;
    private boolean aimedRotation;
    private boolean tickPose;

    public OverlayOptionsPose(@NotNull VROverlay owner, @NotNull Consumer<OverlayOptionsPose> defaultSettings) {
        super(owner, defaultSettings);
    }

    @Override
    public void update(boolean force) {
    }

    @Override
    protected void onLoad(@NotNull Config config) {
        this.tickPose = config.getBool("tick");
        this.aimedRotation = config.getBool("rotation.aim");
        this.positionAnchor = PoseAnchor.valueOf(config.getStringOrDefault("position.type", "HMD").toUpperCase());
        this.rotationAnchor = PoseAnchor.valueOf(config.getStringOrDefault("rotation.type", "HMD").toUpperCase());
        this.positionOffset = new Vector3f(config.getFloatOrDefault("position.offset.x", 0.0f), config.getFloatOrDefault("position.offset.y", 0.0f), config.getFloatOrDefault("position.offset.z", 0.0f));
        this.rotationOffset = new Vector3f(config.getFloatOrDefault("rotation.offset.x", 0.0f), config.getFloatOrDefault("rotation.offset.y", 0.0f), config.getFloatOrDefault("rotation.offset.z", 0.0f));
        this.scale = config.getFloatOrDefault("scale", 1.0f);
        this.scale = this.scale <= 0.0f ? 1.0f : this.scale;
    }

    @Override
    public void onSave(@NotNull Config config) {
        config.set("tick", this.tickPose);
        config.set("position.type", this.positionAnchor.name());
        config.set("rotation.type", this.rotationAnchor.name());
        config.set("rotation.aim", this.aimedRotation);
        config.set("position.offset.x", Float.valueOf(this.positionOffset.x));
        config.set("position.offset.y", Float.valueOf(this.positionOffset.y));
        config.set("position.offset.z", Float.valueOf(this.positionOffset.z));
        config.set("rotation.offset.x", Float.valueOf(this.rotationOffset.x));
        config.set("rotation.offset.y", Float.valueOf(this.rotationOffset.y));
        config.set("rotation.offset.z", Float.valueOf(this.rotationOffset.z));
        config.set("scale", Float.valueOf(this.scale));
    }

    public void setPositionAnchor(PoseAnchor newValue) {
        if (this.positionAnchor == newValue) {
            return;
        }
        this.positionAnchor = newValue;
        this.onChanged();
    }

    public void setRotationAnchor(PoseAnchor newValue) {
        if (this.rotationAnchor == newValue) {
            return;
        }
        this.rotationAnchor = newValue;
        this.onChanged();
    }

    public void setTickPose(boolean newValue) {
        if (this.tickPose == newValue) {
            return;
        }
        this.tickPose = newValue;
        this.onChanged();
    }

    public void setAimedRotation(boolean newValue) {
        if (this.aimedRotation == newValue) {
            return;
        }
        this.aimedRotation = newValue;
        this.onChanged();
    }

    public void setPositionOffset(Vector3f newValue) {
        if (this.positionOffset == newValue) {
            return;
        }
        this.positionOffset = newValue;
        this.onChanged();
    }

    public void setPositionOffset(float x, float y, float z) {
        if (this.positionOffset.x == x && this.positionOffset.y == y && this.positionOffset.z == z) {
            return;
        }
        this.positionOffset = new Vector3f(x, y, z);
        this.onChanged();
    }

    public void setPositionOffsetX(float x) {
        if (this.positionOffset.x == x) {
            return;
        }
        this.positionOffset.x = x;
        this.onChanged();
    }

    public void setPositionOffsetY(float y) {
        if (this.positionOffset.y == y) {
            return;
        }
        this.positionOffset.y = y;
        this.onChanged();
    }

    public void setPositionOffsetZ(float z) {
        if (this.positionOffset.z == z) {
            return;
        }
        this.positionOffset.z = z;
        this.onChanged();
    }

    public void setRotationOffset(Vector3f newValue) {
        if (this.rotationOffset == newValue) {
            return;
        }
        this.rotationOffset = newValue;
        this.onChanged();
    }

    public void setRotationOffset(float radianX, float radianY, float radianZ) {
        if (this.rotationOffset.x == radianX && this.rotationOffset.y == radianY && this.rotationOffset.z == radianZ) {
            return;
        }
        this.rotationOffset = new Vector3f(radianX, radianY, radianZ);
        this.onChanged();
    }

    public void setRotationOffsetX(float radianX) {
        if (this.rotationOffset.x == radianX) {
            return;
        }
        this.rotationOffset.x = radianX;
        this.onChanged();
    }

    public void setRotationOffsetY(float radianY) {
        if (this.rotationOffset.y == radianY) {
            return;
        }
        this.rotationOffset.y = radianY;
        this.onChanged();
    }

    public void setRotationOffsetZ(float radianZ) {
        if (this.rotationOffset.z == radianZ) {
            return;
        }
        this.rotationOffset.z = radianZ;
        this.onChanged();
    }

    public void setScale(float newValue) {
        if (this.scale == newValue) {
            return;
        }
        this.scale = newValue;
        this.onChanged();
    }

    private void onChanged() {
        this.changesNotSaved = true;
    }

    @Override
    public boolean supportsCopying() {
        return true;
    }

    @Override
    @NotNull
    public OptionsScreen<?> getScreen() {
        return VisorAPI.client().getGuiManager().getOverlayManager().getOptionsScreenFor(this);
    }

    @Override
    @NotNull
    public class_2561 getDisplayName() {
        return NAME;
    }

    @Override
    @NotNull
    public String getId() {
        return ID;
    }

    public PoseAnchor getPositionAnchor() {
        return this.positionAnchor;
    }

    public PoseAnchor getRotationAnchor() {
        return this.rotationAnchor;
    }

    public Vector3f getPositionOffset() {
        return this.positionOffset;
    }

    public Vector3f getRotationOffset() {
        return this.rotationOffset;
    }

    public float getScale() {
        return this.scale;
    }

    public boolean isAimedRotation() {
        return this.aimedRotation;
    }

    public boolean isTickPose() {
        return this.tickPose;
    }
}

