/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.api.client.gui.overlays.options.types.properties;

import java.math.BigDecimal;
import java.util.Locale;
import me.phoenixra.atumconfig.api.config.Config;
import me.phoenixra.visor.api.client.gui.overlays.options.types.properties.Property;
import me.phoenixra.visor.api.client.gui.widgets.EditBoxImage;
import me.phoenixra.visor.api.client.gui.widgets.info.WidgetInfoEditBox;
import net.minecraft.class_3532;
import org.jetbrains.annotations.NotNull;

public class PropertyDouble
extends Property<Double> {
    protected final double minValue;
    protected final double maxValue;
    protected final WidgetInfoEditBox widgetInfo;

    public PropertyDouble(@NotNull String key, double defaultValue, double minValue, double maxValue, @NotNull WidgetInfoEditBox widgetInfo) {
        super(key, defaultValue);
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.widgetInfo = widgetInfo;
    }

    @Override
    public void onLoad(@NotNull Config config) {
        this.setValue(config.getDoubleOrDefault(this.key, (Double)this.defaultValue));
    }

    @Override
    public void onSave(@NotNull Config config) {
        config.set(this.key, this.getValue());
    }

    @Override
    public void setValue(Double value) {
        super.setValue(class_3532.method_15350((double)value, (double)this.minValue, (double)this.maxValue));
    }

    public EditBoxImage createWidget() {
        WidgetInfoEditBox widgetInfo = new WidgetInfoEditBox(this.widgetInfo);
        EditBoxImage widget = new EditBoxImage(widgetInfo);
        widget.method_1852(PropertyDouble.formatDouble((Double)this.getValue()));
        widget.method_1890(s -> {
            if (s.isEmpty() || s.equals("-") || s.equals(".") || s.equals("-.")) {
                return true;
            }
            try {
                double v = Double.parseDouble(s);
                return Double.isFinite(v) && v >= this.minValue && v <= this.maxValue;
            }
            catch (NumberFormatException e) {
                return false;
            }
        });
        widget.method_1863(s -> {
            try {
                double v = Double.parseDouble(s);
                if (Double.isFinite(v) && v >= this.minValue && v <= this.maxValue) {
                    this.setValue(v);
                    this.onValueChanged();
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        });
        int intPartWidth = Math.max(PropertyDouble.intPartWidth(this.minValue), PropertyDouble.intPartWidth(this.maxValue));
        int maxLen = intPartWidth + 1 + 15 + (this.minValue < 0.0 ? 1 : 0);
        widget.method_1880(Math.max(maxLen, 8));
        widget.method_1870();
        return widget;
    }

    private static int intPartWidth(double v) {
        double absFloor = Math.floor(Math.abs(v));
        String s = BigDecimal.valueOf(absFloor).toPlainString();
        return Math.max(1, s.length());
    }

    private static String formatDouble(double v) {
        String s = String.format(Locale.ROOT, "%.12f", v);
        int dot = s.indexOf(46);
        if (dot >= 0) {
            int end;
            for (end = s.length(); end > dot + 1 && s.charAt(end - 1) == '0'; --end) {
            }
            if (end == dot + 1) {
                end = dot;
            }
            s = s.substring(0, end);
        }
        return s;
    }
}

