/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.api.client.gui.overlays.options.types.properties;

import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Function;
import me.phoenixra.atumconfig.api.config.Config;
import me.phoenixra.visor.api.client.gui.overlays.options.types.properties.Property;
import me.phoenixra.visor.api.client.gui.widgets.ButtonImaged;
import me.phoenixra.visor.api.client.gui.widgets.info.WidgetInfoButtonImaged;
import net.minecraft.class_2561;
import org.jetbrains.annotations.NotNull;

public class PropertyEnum<E extends Enum<E>>
extends Property<E> {
    private final Class<E> enumClass;
    private final WidgetInfoButtonImaged widgetInfo;
    private final List<E> values;
    @NotNull
    private final Function<E, class_2561> labeler;

    public PropertyEnum(@NotNull String key, @NotNull E defaultValue, @NotNull Class<E> enumClass, @NotNull WidgetInfoButtonImaged widgetInfo) {
        this(key, (Enum)defaultValue, (Class<Enum>)enumClass, e -> class_2561.method_43470((String)PropertyEnum.humanize(e.name())), widgetInfo);
    }

    public PropertyEnum(@NotNull String key, @NotNull E defaultValue, @NotNull Class<E> enumClass, @NotNull Function<E, class_2561> labeler, @NotNull WidgetInfoButtonImaged widgetInfo) {
        super(key, defaultValue);
        this.enumClass = Objects.requireNonNull(enumClass, "enumClass");
        this.widgetInfo = Objects.requireNonNull(widgetInfo, "infoButton");
        this.labeler = Objects.requireNonNull(labeler, "labeller");
        this.values = List.of((Enum[])enumClass.getEnumConstants());
        if (this.values.isEmpty()) {
            throw new IllegalArgumentException("Enum " + enumClass.getName() + " has no constants");
        }
    }

    @Override
    public void onLoad(@NotNull Config config) {
        String raw = config.getStringOrDefault(this.key, ((Enum)this.getDefaultValue()).name());
        Object parsed = this.tryParseEnum(raw);
        if (parsed == null) {
            int ordinal = config.getIntOrDefault(this.key, ((Enum)this.getDefaultValue()).ordinal());
            parsed = ordinal >= 0 && ordinal < this.values.size() ? (Enum)this.values.get(ordinal) : (Enum)this.getDefaultValue();
        }
        this.setValue(this.values.contains(parsed) ? parsed : (Enum)this.values.get(0));
    }

    @Override
    public void onSave(@NotNull Config config) {
        config.set(this.key, ((Enum)this.getValue()).name());
    }

    public ButtonImaged createWidget() {
        WidgetInfoButtonImaged widgetInfo = new WidgetInfoButtonImaged(this.widgetInfo);
        ButtonImaged button = new ButtonImaged(widgetInfo, imgBtn -> {
            int i = Math.max(0, this.values.indexOf(this.getValue()));
            Enum next = (Enum)this.values.get((i + 1) % this.values.size());
            this.setValue(next);
            this.onValueChanged();
            imgBtn.method_25355(this.labeler.apply(next));
            imgBtn.setSelected(false);
        });
        Enum current = this.values.contains(this.getValue()) ? (Enum)this.getValue() : (Enum)this.values.get(0);
        this.setValue(current);
        button.method_25355(this.labeler.apply(current));
        button.setSelected(false);
        return button;
    }

    private E tryParseEnum(String s) {
        if (s == null) {
            return null;
        }
        try {
            return Enum.valueOf(this.enumClass, s);
        }
        catch (IllegalArgumentException e) {
            for (Enum e2 : (Enum[])this.enumClass.getEnumConstants()) {
                if (!e2.name().equalsIgnoreCase(s)) continue;
                return (E)e2;
            }
            return null;
        }
    }

    private static String humanize(String name) {
        String[] parts = name.toLowerCase(Locale.ROOT).split("_");
        StringBuilder sb = new StringBuilder();
        for (String p : parts) {
            if (p.isEmpty()) continue;
            sb.append(Character.toUpperCase(p.charAt(0))).append(p.substring(1)).append(' ');
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }
}

