/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.api.client.gui.overlays.options.types.properties;

import java.util.Locale;
import me.phoenixra.atumconfig.api.config.Config;
import me.phoenixra.visor.api.client.gui.overlays.options.types.properties.Property;
import me.phoenixra.visor.api.client.gui.widgets.EditBoxImage;
import me.phoenixra.visor.api.client.gui.widgets.info.WidgetInfoEditBox;
import net.minecraft.class_3532;
import org.jetbrains.annotations.NotNull;

public class PropertyFloat
extends Property<Float> {
    protected final float minValue;
    protected final float maxValue;
    protected final WidgetInfoEditBox widgetInfo;

    public PropertyFloat(@NotNull String key, float defaultValue, float minValue, float maxValue, @NotNull WidgetInfoEditBox widgetInfo) {
        super(key, Float.valueOf(defaultValue));
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.widgetInfo = widgetInfo;
    }

    @Override
    public void onLoad(@NotNull Config config) {
        this.setValue(Float.valueOf(config.getFloatOrDefault(this.key, ((Float)this.defaultValue).floatValue())));
    }

    @Override
    public void onSave(@NotNull Config config) {
        config.set(this.key, this.getValue());
    }

    @Override
    public void setValue(Float value) {
        super.setValue(Float.valueOf(class_3532.method_15363((float)value.floatValue(), (float)this.minValue, (float)this.maxValue)));
    }

    public EditBoxImage createWidget() {
        WidgetInfoEditBox widgetInfo = new WidgetInfoEditBox(this.widgetInfo);
        EditBoxImage widget = new EditBoxImage(widgetInfo);
        widget.method_1852(PropertyFloat.formatFloat(((Float)this.getValue()).floatValue()));
        widget.method_1890(s -> {
            if (s.isEmpty()) {
                return true;
            }
            if (this.minValue < 0.0f && (s.equals("-") || s.equals("-."))) {
                return true;
            }
            if (s.equals(".")) {
                return true;
            }
            try {
                float v = Float.parseFloat(s);
                return Float.isFinite(v) && v >= this.minValue && v <= this.maxValue;
            }
            catch (NumberFormatException e) {
                return false;
            }
        });
        widget.method_1863(s -> {
            try {
                float v = Float.parseFloat(s);
                if (Float.isFinite(v) && v >= this.minValue && v <= this.maxValue) {
                    this.setValue(Float.valueOf(v));
                    this.onValueChanged();
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        });
        int intPartWidth = Math.max(Integer.toString((int)Math.floor(Math.abs(this.minValue))).length(), Integer.toString((int)Math.floor(Math.abs(this.maxValue))).length());
        int maxLen = intPartWidth + 1 + 8 + (this.minValue < 0.0f ? 1 : 0);
        widget.method_1880(Math.max(maxLen, 6));
        widget.method_1870();
        return widget;
    }

    private static String formatFloat(float v) {
        String s = String.format(Locale.ROOT, "%.6f", Float.valueOf(v));
        int dot = s.indexOf(46);
        if (dot >= 0) {
            int end;
            for (end = s.length(); end > dot + 1 && s.charAt(end - 1) == '0'; --end) {
            }
            if (end == dot + 1) {
                end = dot;
            }
            s = s.substring(0, end);
        }
        return s;
    }
}

