/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.api.client.gui.overlays.options.types.properties;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import me.phoenixra.atumconfig.api.config.Config;
import me.phoenixra.visor.api.client.gui.overlays.options.types.properties.Property;
import me.phoenixra.visor.api.client.gui.widgets.SliderWidget;
import me.phoenixra.visor.api.client.gui.widgets.info.WidgetInfoSlider;
import net.minecraft.class_2561;
import org.jetbrains.annotations.NotNull;

public class PropertySlider<T>
extends Property<T> {
    private final List<T> entries;
    private final WidgetInfoSlider widgetInfo;
    @NotNull
    private final Function<T, class_2561> labeler;

    public PropertySlider(@NotNull String key, @NotNull T defaultValue, @NotNull List<T> entries, @NotNull WidgetInfoSlider widgetInfo) {
        this(key, defaultValue, entries, it -> class_2561.method_43470((String)it.toString()), widgetInfo);
    }

    public PropertySlider(@NotNull String key, @NotNull T defaultValue, @NotNull List<T> entries, @NotNull Function<T, class_2561> labeler, @NotNull WidgetInfoSlider widgetInfo) {
        super(key, defaultValue);
        this.entries = List.copyOf((Collection)Objects.requireNonNull(entries, "entries"));
        if (this.entries.isEmpty()) {
            throw new IllegalArgumentException("entries list must not be empty");
        }
        this.widgetInfo = new WidgetInfoSlider(Objects.requireNonNull(widgetInfo, "widgetInfo"));
        this.labeler = Objects.requireNonNull(labeler, "labeler");
        T initial = this.entries.contains(defaultValue) ? defaultValue : this.entries.get(0);
        super.setValue(initial);
    }

    @Override
    public void onLoad(@NotNull Config config) {
        int defaultIdx = this.indexOf(this.getDefaultValue());
        int idx = config.getIntOrDefault(this.key, defaultIdx);
        idx = this.clampIndex(idx);
        super.setValue(this.entries.get(idx));
    }

    @Override
    public void onSave(@NotNull Config config) {
        int idx = this.indexOf(this.getValue());
        config.set(this.key, idx);
    }

    @Override
    public void setValue(T value) {
        if (this.entries.contains(value)) {
            super.setValue(value);
        } else {
            super.setValue(this.entries.get(0));
        }
    }

    @Override
    public SliderWidget<T> createWidget() {
        WidgetInfoSlider info = new WidgetInfoSlider(this.widgetInfo);
        SliderWidget slider = new SliderWidget(info, this.entries, it -> {
            Object v = it.getSelected();
            this.setValue(v);
            this.onValueChanged();
            it.setText(this.labeler.apply(v));
        });
        Object current = this.entries.contains(this.getValue()) ? this.getValue() : this.entries.get(0);
        this.setValue(current);
        slider.setSelected(current, false);
        slider.setText(this.labeler.apply(current));
        return slider;
    }

    private int indexOf(T v) {
        int i = this.entries.indexOf(v);
        return Math.max(i, 0);
    }

    private int clampIndex(int i) {
        if (this.entries.isEmpty()) {
            return 0;
        }
        if (i < 0) {
            return 0;
        }
        int max = this.entries.size() - 1;
        return Math.min(i, max);
    }
}

