/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.api.client.gui.widgets;

import java.util.Objects;
import java.util.function.Consumer;
import me.phoenixra.visor.api.client.gui.GuiTexture;
import me.phoenixra.visor.api.client.gui.helpers.GuiHelper;
import me.phoenixra.visor.api.client.gui.widgets.info.WidgetInfoButtonImaged;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4264;
import net.minecraft.class_6382;

public class ButtonImaged
extends class_4264 {
    private final WidgetInfoButtonImaged widgetInfo;
    private final Consumer<ButtonImaged> onPress;
    private boolean selected;

    public ButtonImaged(WidgetInfoButtonImaged widgetInfo, Consumer<ButtonImaged> onPress) {
        super(widgetInfo.getX(), widgetInfo.getY(), widgetInfo.getWidth(), widgetInfo.getHeight(), widgetInfo.getText());
        this.widgetInfo = widgetInfo;
        this.onPress = onPress;
        this.method_47400(widgetInfo.getTooltip());
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
        this.field_22763 = !this.widgetInfo.isInactiveOnSelected() || !selected;
    }

    public void method_25306() {
        if (this.onPress != null) {
            this.onPress.accept(this);
        }
    }

    public void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        GuiTexture texture;
        if (!this.field_22763) {
            texture = this.selected ? this.widgetInfo.getTextureSelected() : this.widgetInfo.getTextureInactive();
        } else if (this.selected) {
            texture = this.widgetInfo.getTextureHoveredSelected();
            if (!this.field_22762 || texture == null) {
                texture = this.widgetInfo.getTextureSelected();
            }
        } else {
            texture = this.field_22762 ? this.widgetInfo.getTextureHovered() : this.widgetInfo.getTexture();
        }
        if (texture == null) {
            texture = this.widgetInfo.getTexture();
        }
        this.widgetInfo.pos(this.method_46426(), this.method_46427()).size(this.method_25368(), this.method_25364());
        texture.blit(guiGraphics, this.method_46426(), this.method_46427(), this.field_22758, this.field_22759);
        this.widgetInfo.drawHighlight(guiGraphics, this.field_22763, this.field_22762, this.selected);
        String text = this.method_25369().getString();
        int textX = this.method_46426() + this.widgetInfo.getTextPosOffset().x;
        int textY = this.method_46427() + this.widgetInfo.getTextPosOffset().y;
        int textW = this.method_25368() + this.widgetInfo.getTextSizeOffset().x;
        int textH = this.method_25364() + this.widgetInfo.getTextSizeOffset().y;
        if (!text.isEmpty()) {
            class_327 font = class_310.method_1551().field_1772;
            int color = this.widgetInfo.getTextColor().toInt();
            if (this.widgetInfo.isScaleText()) {
                GuiHelper.renderScalableText(guiGraphics, font, text, color, textX, textY, textW, textH, true);
                return;
            }
            int textWidth = font.method_1727(text);
            Objects.requireNonNull(font);
            int textHeight = 9;
            int x = textX + (textW - textWidth) / 2;
            int y = textY + (textH - textHeight) / 2;
            if (textWidth <= textW) {
                guiGraphics.method_51433(font, text, x, y, color, false);
            } else {
                int overflow = textWidth - textW;
                double cycleSecs = 4.0;
                double t = (double)(System.currentTimeMillis() % (long)(cycleSecs * 1000.0)) / (cycleSecs * 1000.0);
                double phase = (Math.sin(Math.PI * 2 * t) + 1.0) * 0.5;
                int offset = (int)(phase * (double)overflow);
                guiGraphics.method_44379(textX, textY, textX + textW, textY + textH);
                guiGraphics.method_51433(font, text, x - offset, y, color, false);
                guiGraphics.method_44380();
            }
        }
    }

    protected void method_47399(class_6382 narrationElementOutput) {
        this.method_37021(narrationElementOutput);
    }

    public WidgetInfoButtonImaged getWidgetInfo() {
        return this.widgetInfo;
    }

    public boolean isSelected() {
        return this.selected;
    }
}

