/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.api.client.gui.widgets;

import java.util.List;
import java.util.function.Consumer;
import me.phoenixra.atumconfig.api.tuples.PairRecord;
import net.minecraft.class_2561;
import net.minecraft.class_3532;
import net.minecraft.class_357;

public class DiscreteSliderWidget<T>
extends class_357 {
    private final List<T> entries;
    private final Consumer<PairRecord<DiscreteSliderWidget<T>, T>> onChange;
    private class_2561 message;
    private int index;

    public DiscreteSliderWidget(int x, int y, int width, int height, List<T> entries, int initialIndex, Consumer<PairRecord<DiscreteSliderWidget<T>, T>> onChange) {
        super(x, y, width, height, (class_2561)class_2561.method_43473(), DiscreteSliderWidget.normalizeIndex(Math.max(0, Math.min(entries.size() - 1, initialIndex)), entries.size()));
        this.entries = List.copyOf(entries);
        this.onChange = onChange != null ? onChange : t -> {};
        this.index = this.clampIndex(initialIndex);
        this.snapToIndex();
        this.method_25346();
    }

    protected void method_25346() {
        this.method_25355(this.message);
    }

    protected void method_25344() {
        int newIndex = this.valueToNearestIndex(this.field_22753);
        if (newIndex != this.index) {
            this.index = newIndex;
            this.onChange.accept(new PairRecord<DiscreteSliderWidget, T>(this, this.entries.get(this.index)));
        }
        this.snapToIndex();
        this.method_25346();
    }

    public T getSelected() {
        return this.entries.get(this.index);
    }

    public void setIndex(int newIndex) {
        if (this.entries.isEmpty()) {
            return;
        }
        int clamped = this.clampIndex(newIndex);
        if (clamped != this.index) {
            this.index = clamped;
            this.snapToIndex();
            this.method_25346();
            this.onChange.accept(new PairRecord<DiscreteSliderWidget, T>(this, this.entries.get(this.index)));
        }
    }

    public void setSelected(T value) {
        int idx = this.entries.indexOf(value);
        if (idx >= 0) {
            this.setIndex(idx);
        }
    }

    private int clampIndex(int idx) {
        return class_3532.method_15340((int)idx, (int)0, (int)(this.entries.size() - 1));
    }

    private void snapToIndex() {
        this.field_22753 = DiscreteSliderWidget.normalizeIndex(this.index, this.entries.size());
    }

    private static double normalizeIndex(int idx, int size) {
        if (size <= 1) {
            return 0.0;
        }
        return (double)idx / (double)(size - 1);
    }

    private int valueToNearestIndex(double v) {
        if (this.entries.size() <= 1) {
            return 0;
        }
        double clamped = class_3532.method_15350((double)v, (double)0.0, (double)1.0);
        int nearest = (int)Math.round(clamped * (double)(this.entries.size() - 1));
        return class_3532.method_15340((int)nearest, (int)0, (int)(this.entries.size() - 1));
    }

    public class_2561 method_25369() {
        return this.message;
    }

    public void method_25355(class_2561 message) {
        this.message = message;
    }

    public int getIndex() {
        return this.index;
    }
}

