/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.api.client.gui.widgets;

import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import me.phoenixra.visor.api.client.gui.GuiTexture;
import me.phoenixra.visor.api.client.gui.helpers.GuiHelper;
import me.phoenixra.visor.api.client.gui.widgets.info.WidgetInfoSlider;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_5250;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SliderWidget<T>
extends class_339 {
    private final WidgetInfoSlider widgetInfo;
    private final List<T> entries;
    private final Consumer<SliderWidget<T>> responder;
    private int knobX;
    private int knobY;
    private int knobWidth;
    private int knobHeight;
    private class_2561 text;
    private int index = -1;
    private T selected;

    public SliderWidget(@NotNull WidgetInfoSlider widgetInfo, @NotNull List<T> entries, @Nullable Consumer<SliderWidget<T>> responder) {
        super(widgetInfo.getX(), widgetInfo.getY(), widgetInfo.getWidth(), widgetInfo.getHeight(), (class_2561)class_2561.method_43473());
        if (entries.size() <= 1) {
            throw new IllegalArgumentException("entries list of slider widget cannot be empty or size less than 2");
        }
        this.widgetInfo = widgetInfo;
        this.entries = List.copyOf(entries);
        this.responder = responder != null ? responder : it -> {};
        this.knobY = this.method_46427();
        this.knobWidth = widgetInfo.getKnobWidth();
        this.knobHeight = this.method_25364();
        this.method_47400(widgetInfo.getTooltip());
        this.setIndex(0, false);
    }

    private void setIndex(int newIndex, boolean callResponder) {
        int clamped = this.clampIndex(newIndex);
        if (clamped != this.index) {
            this.index = clamped;
            this.selected = this.entries.get(this.index);
            if (callResponder) {
                this.responder.accept(this);
            }
        }
    }

    public void setSelected(@Nullable T value, boolean callResponder) {
        this.setIndex(this.entries.indexOf(value), callResponder);
    }

    protected void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        boolean knobHovered;
        GuiTexture knob;
        this.widgetInfo.pos(this.method_46426(), this.method_46427()).size(this.method_25368(), this.method_25364());
        this.repositionKnob();
        GuiTexture bg = this.widgetInfo.getBackgroundTexture();
        if (bg != null) {
            bg.blit(guiGraphics, this.method_46426(), this.method_46427(), this.method_25368(), this.method_25364());
        }
        if ((knob = this.resolveKnobTexture(knobHovered = this.field_22763 && mouseX >= this.knobX && mouseX < this.knobX + this.knobWidth && mouseY >= this.knobY && mouseY < this.knobY + this.knobHeight)) != null) {
            knob.blit(guiGraphics, this.knobX, this.knobY, this.knobWidth, this.knobHeight);
        }
        this.widgetInfo.drawHighlight(guiGraphics, this.knobX, this.knobY, this.knobWidth, this.knobHeight, this.field_22763, knobHovered);
        String text = this.resolveDisplayText();
        if (!text.isEmpty()) {
            class_327 font = this.widgetInfo.getTextFont() != null ? this.widgetInfo.getTextFont() : class_310.method_1551().field_1772;
            int color = this.widgetInfo.getTextColor().toInt();
            int textX = this.method_46426();
            int textY = this.method_46427();
            int textW = this.method_25368();
            int textH = this.method_25364();
            if (this.widgetInfo.isScaleText()) {
                GuiHelper.renderScalableText(guiGraphics, font, text, color, textX, textY, textW, textH, true);
            } else {
                int strW = font.method_1727(text);
                Objects.requireNonNull(font);
                int strH = 9;
                int x = textX + (textW - strW) / 2;
                int y = textY + (textH - strH) / 2;
                if (strW <= textW) {
                    guiGraphics.method_51433(font, text, x, y, color, false);
                } else {
                    int overflow = strW - textW;
                    double cycleSecs = 4.0;
                    double t = (double)(System.currentTimeMillis() % (long)(cycleSecs * 1000.0)) / (cycleSecs * 1000.0);
                    double phase = (Math.sin(Math.PI * 2 * t) + 1.0) * 0.5;
                    int offset = (int)(phase * (double)overflow);
                    guiGraphics.method_44379(textX, textY, textX + textW, textY + textH);
                    guiGraphics.method_51433(font, text, x - offset, y, color, false);
                    guiGraphics.method_44380();
                }
            }
        }
    }

    private GuiTexture resolveKnobTexture(boolean knobHovered) {
        if (!this.field_22763) {
            return this.widgetInfo.getKnobTextureInactive() != null ? this.widgetInfo.getKnobTextureInactive() : this.widgetInfo.getKnobTexture();
        }
        if (knobHovered && this.widgetInfo.getKnobTextureHovered() != null) {
            return this.widgetInfo.getKnobTextureHovered();
        }
        return this.widgetInfo.getKnobTexture();
    }

    private void repositionKnob() {
        double normalized = (double)this.index / (double)(this.entries.size() - 1);
        int left = this.method_46426();
        int right = this.method_46426() + this.method_25368() - this.knobWidth;
        this.knobX = left + (int)Math.round(normalized * (double)(right - left));
        this.knobY = this.method_46427();
        this.knobWidth = this.widgetInfo.getKnobWidth();
        this.knobHeight = this.method_25364();
    }

    private int clampIndex(int idx) {
        return class_3532.method_15340((int)idx, (int)0, (int)Math.max(0, this.entries.size() - 1));
    }

    private String resolveDisplayText() {
        if (this.text != null && !this.text.getString().isEmpty()) {
            return this.text.getString();
        }
        if (this.selected == null) {
            return "";
        }
        String s = String.valueOf(this.selected);
        return s != null ? s : "";
    }

    private void selectFromMouse(double mouseX) {
        double start = (double)this.method_46426() + (double)this.knobWidth * 0.5;
        double end = (double)(this.method_46426() + this.method_25368()) - (double)this.knobWidth * 0.5;
        double span = end - start;
        if (span <= 0.0) {
            this.setIndex(0, true);
            return;
        }
        double t = (mouseX - start) / span;
        t = class_3532.method_15350((double)t, (double)0.0, (double)1.0);
        double scaled = t * (double)(this.entries.size() - 1);
        int nearest = (int)Math.round(scaled);
        this.setIndex(nearest, true);
    }

    public void method_25348(double mouseX, double mouseY) {
        this.selectFromMouse(mouseX);
    }

    protected void method_25349(double mouseX, double mouseY, double dragX, double dragY) {
        super.method_25349(mouseX, mouseY, dragX, dragY);
        this.selectFromMouse(mouseX);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (!this.field_22763) {
            return false;
        }
        if (keyCode == 263) {
            this.setIndex(this.index - 1, true);
            return true;
        }
        if (keyCode == 262) {
            this.setIndex(this.index + 1, true);
            return true;
        }
        if (keyCode == 268) {
            this.setIndex(0, true);
            return true;
        }
        if (keyCode == 269) {
            this.setIndex(this.entries.size() - 1, true);
            return true;
        }
        return false;
    }

    protected void method_47399(class_6382 narrationElementOutput) {
        String text = this.resolveDisplayText();
        class_5250 title = class_2561.method_43469((String)"gui.narrate.slider", (Object[])new Object[]{class_2561.method_43470((String)text)});
        narrationElementOutput.method_37034(class_6381.field_33788, (class_2561)title);
        if (this.field_22763) {
            if (this.method_25370()) {
                narrationElementOutput.method_37034(class_6381.field_33791, (class_2561)class_2561.method_43471((String)"narration.slider.usage.focused"));
            } else {
                narrationElementOutput.method_37034(class_6381.field_33791, (class_2561)class_2561.method_43471((String)"narration.slider.usage.hovered"));
            }
        }
    }

    public WidgetInfoSlider getWidgetInfo() {
        return this.widgetInfo;
    }

    public class_2561 getText() {
        return this.text;
    }

    public void setText(class_2561 text) {
        this.text = text;
    }

    public int getIndex() {
        return this.index;
    }

    public T getSelected() {
        return this.selected;
    }
}

