/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.api.client.gui.widgets;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.phoenixra.visor.api.VisorAPI;
import me.phoenixra.visor.api.client.gui.GuiTexture;
import me.phoenixra.visor.api.client.gui.VRCursorHandler;
import me.phoenixra.visor.api.client.gui.VRKeyboardAccessor;
import me.phoenixra.visor.api.client.gui.overlays.VROverlay;
import me.phoenixra.visor.api.client.gui.overlays.framework.VROverlayScreen;
import me.phoenixra.visor.api.client.gui.widgets.info.WidgetInfoTextBoxEditable;
import net.minecraft.class_1144;
import net.minecraft.class_155;
import net.minecraft.class_156;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5481;
import net.minecraft.class_6382;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextBoxEditable
extends class_339 {
    private static final int CURSOR_INSERT_COLOR = -3092272;
    private static final int LINE_PADDING = 2;
    private static final Pattern TOKEN_SPLIT = Pattern.compile("\\s+|\\S+");
    protected final GuiTexture background;
    protected final GuiTexture textureScrollBar;
    protected final GuiTexture textureScrollBarActive;
    protected final class_327 font;
    protected final int textColor;
    protected final int textHintColor;
    protected final int highlightColor;
    protected final float textScale;
    protected final int paddingX;
    protected final int paddingY;
    protected final int scrollBarWidth;
    private String value = "";
    private int maxLength;
    @Nullable
    private class_2561 hint;
    @Nullable
    private Consumer<String> responder;
    private Predicate<String> filter;
    private boolean readOnly = false;
    private final List<String> textLines = new ArrayList<String>();
    private final List<Integer> lineStartIndices = new ArrayList<Integer>();
    private int cursorLine = 0;
    private int cursorColumn = 0;
    private int cursorPos;
    private int selectionAnchor;
    private boolean updateCursorCoordinates = true;
    protected boolean recalculateLines = true;
    protected int scrollOffset = 0;
    protected int maxScrollOffset = 0;
    protected long lastScrollingCall = -1L;
    protected boolean scrolling = false;
    private int thumbGrabOffset = -1;
    private boolean shiftPressed;
    private boolean followCaret = true;
    private int frame;

    public TextBoxEditable(@NotNull WidgetInfoTextBoxEditable widgetInfo) {
        super(widgetInfo.getX(), widgetInfo.getY(), widgetInfo.getWidth(), widgetInfo.getHeight(), (class_2561)class_2561.method_43473());
        this.background = widgetInfo.getBackground();
        this.textureScrollBar = widgetInfo.getTextureScrollBar();
        this.textureScrollBarActive = widgetInfo.getTextureScrollBarActive();
        this.font = widgetInfo.getTextFont();
        this.textColor = widgetInfo.getTextColor().toInt();
        this.textHintColor = widgetInfo.getTextHintColor().toInt();
        this.highlightColor = widgetInfo.getHighlightColor().toInt();
        this.textScale = widgetInfo.getTextScale() <= 0.0f ? 1.0f : widgetInfo.getTextScale();
        this.paddingX = 4;
        this.paddingY = 4;
        this.scrollBarWidth = widgetInfo.getScrollBarWidth();
        this.maxLength = widgetInfo.getMaxLength() > 0 ? widgetInfo.getMaxLength() : 32;
        this.value = widgetInfo.getText() != null ? widgetInfo.getText().getString() : "";
        this.hint = widgetInfo.getHint();
        this.filter = Objects::nonNull;
        this.selectionAnchor = this.cursorPos = 0;
    }

    public void tick() {
        ++this.frame;
    }

    private boolean caretVisible() {
        return this.method_25370() && !this.readOnly;
    }

    protected void method_48579(@NotNull class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        class_4587 poseStack;
        block11: {
            int lineY;
            int lineHeight;
            int textMaxY;
            int textY;
            block9: {
                block10: {
                    this.calculateLines();
                    if (this.scrolling && this.lastScrollingCall + 200L < System.currentTimeMillis()) {
                        this.scrolling = false;
                        this.lastScrollingCall = -1L;
                        this.thumbGrabOffset = -1;
                    }
                    if (this.background != null) {
                        this.background.blit(guiGraphics, this.method_46426(), this.method_46427(), this.field_22758, this.field_22759);
                    }
                    int textX = this.method_46426() + this.paddingX;
                    textY = this.method_46427() + this.paddingY;
                    int textMaxX = this.method_46426() + this.field_22758 - this.paddingX - this.scrollBarWidth;
                    textMaxY = this.method_46427() + this.field_22759 - this.paddingY;
                    guiGraphics.method_44379(textX, textY, textMaxX, textMaxY);
                    poseStack = guiGraphics.method_51448();
                    poseStack.method_22903();
                    poseStack.method_46416((float)textX, (float)textY, 0.0f);
                    poseStack.method_22905(this.textScale, this.textScale, 1.0f);
                    lineHeight = this.getLineHeight();
                    lineY = -this.scrollOffset;
                    if (!this.value.isEmpty()) break block9;
                    if (this.hint == null || this.method_25370()) break block10;
                    guiGraphics.method_27535(this.font, this.hint, 0, lineY, this.textHintColor);
                    break block11;
                }
                if (!this.caretVisible() || this.frame / 6 % 2 != 0) break block11;
                guiGraphics.method_25303(this.font, "_", 0, lineY, this.textColor);
                break block11;
            }
            if (this.updateCursorCoordinates) {
                this.updateCursorCoordinates();
            }
            int visibleHeightUnscaled = (int)((float)(textMaxY - textY) / this.textScale);
            for (int i = 0; i < this.textLines.size(); ++i) {
                if (lineY + lineHeight >= 0 && lineY <= visibleHeightUnscaled) {
                    String lineText = this.textLines.get(i);
                    class_5481 line = class_5481.method_30747((String)lineText, (class_2583)class_2583.field_24360);
                    guiGraphics.method_35720(this.font, line, 0, lineY, this.textColor);
                    if (!this.readOnly && this.isLineSelected(i)) {
                        this.renderSelectionHighlight(guiGraphics, i, lineY, lineHeight);
                    }
                    if (this.caretVisible() && this.frame / 6 % 2 == 0 && i == this.cursorLine) {
                        boolean isCursorAtLineEnd;
                        int cursorX = this.getCursorPosX();
                        int lineVisualEnd = this.getLineVisualEndIndex(i);
                        boolean bl = isCursorAtLineEnd = this.cursorPos == lineVisualEnd;
                        if (isCursorAtLineEnd) {
                            guiGraphics.method_25303(this.font, "_", cursorX, lineY, this.textColor);
                        } else {
                            class_1921 class_19212 = class_1921.method_51785();
                            Objects.requireNonNull(this.font);
                            guiGraphics.method_51739(class_19212, cursorX, lineY + 2, cursorX + 1, lineY + 9 + 2, -3092272);
                        }
                    }
                }
                lineY += lineHeight;
            }
        }
        poseStack.method_22909();
        guiGraphics.method_44380();
        this.renderScrollBar(guiGraphics);
    }

    protected void renderScrollBar(@NotNull class_332 guiGraphics) {
        GuiTexture scrollBarTex;
        if (this.maxScrollOffset <= 0) {
            return;
        }
        int trackX = this.getScrollbarX();
        int trackY = this.method_46427() + this.paddingY;
        int trackHeight = this.field_22759 - this.paddingY * 2;
        int contentHeightUnscaled = this.textLines.size() * this.getLineHeight();
        int visibleHeightUnscaled = (int)((float)(this.field_22759 - this.paddingY * 2) / this.textScale);
        if (contentHeightUnscaled <= 0 || trackHeight <= 0) {
            return;
        }
        int thumbHeight = Math.max(16, Math.min(trackHeight, (int)Math.round((double)visibleHeightUnscaled / (double)contentHeightUnscaled * (double)trackHeight)));
        int thumbY = trackY;
        if (this.maxScrollOffset > 0) {
            double ratio = (double)this.scrollOffset / (double)this.maxScrollOffset;
            thumbY = trackY + (int)Math.round((double)(trackHeight - thumbHeight) * ratio);
        }
        GuiTexture guiTexture = scrollBarTex = this.scrolling ? this.textureScrollBarActive : this.textureScrollBar;
        if (scrollBarTex != null) {
            scrollBarTex.blit(guiGraphics, trackX, thumbY, this.scrollBarWidth, thumbHeight);
        } else {
            guiGraphics.method_51739(class_1921.method_51785(), trackX, thumbY, trackX + this.scrollBarWidth, thumbY + thumbHeight, Integer.MIN_VALUE);
        }
    }

    private void renderSelectionHighlight(class_332 guiGraphics, int lineIndex, int lineY, int lineHeight) {
        int minCursor = Math.min(this.cursorPos, this.selectionAnchor);
        int maxCursor = Math.max(this.cursorPos, this.selectionAnchor);
        int lineStart = this.getLineStartIndex(lineIndex);
        int lineEnd = this.getLineEndIndex(lineIndex);
        if (maxCursor <= lineStart || minCursor >= lineEnd) {
            return;
        }
        int selStart = Math.max(minCursor, lineStart) - lineStart;
        int selEnd = Math.min(maxCursor, lineEnd) - lineStart;
        String lineText = this.textLines.get(lineIndex);
        int textLen = lineText.length();
        selStart = class_3532.method_15340((int)selStart, (int)0, (int)textLen);
        selEnd = class_3532.method_15340((int)selEnd, (int)0, (int)textLen);
        int startX = textLen == 0 ? 0 : this.font.method_1727(lineText.substring(0, selStart));
        int endX = textLen == 0 ? this.font.method_1727(" ") : this.font.method_1727(lineText.substring(0, selEnd));
        int halfPadding = 1;
        class_1921 class_19212 = class_1921.method_51786();
        Objects.requireNonNull(this.font);
        guiGraphics.method_51739(class_19212, startX, lineY - halfPadding, endX, lineY + halfPadding + 9, this.highlightColor);
    }

    protected void calculateLines() {
        if (!this.recalculateLines) {
            return;
        }
        this.textLines.clear();
        this.lineStartIndices.clear();
        int textWidth = (int)((float)(this.field_22758 - this.paddingX * 2 - this.scrollBarWidth) / this.textScale);
        if (textWidth <= 0) {
            this.recalculateLines = false;
            return;
        }
        if (this.value.isEmpty()) {
            this.lineStartIndices.add(0);
            this.textLines.add("");
            this.recalculateLines = false;
            this.updateCursorCoordinates = true;
            this.maxScrollOffset = 0;
            this.scrollOffset = 0;
            return;
        }
        String[] explicitLines = this.value.split("\n", -1);
        int currentPos = 0;
        for (int i = 0; i < explicitLines.length; ++i) {
            String explicitLine = explicitLines[i];
            if (i > 0) {
                ++currentPos;
            }
            if (explicitLine.isEmpty()) {
                this.textLines.add("");
                this.lineStartIndices.add(currentPos);
                continue;
            }
            ArrayList<String> tokens = new ArrayList<String>();
            Matcher m = TOKEN_SPLIT.matcher(explicitLine);
            while (m.find()) {
                tokens.add(m.group());
            }
            int tokenIdx = 0;
            while (tokenIdx < tokens.size()) {
                this.lineStartIndices.add(currentPos);
                StringBuilder sb = new StringBuilder();
                int lineW = 0;
                while (tokenIdx < tokens.size()) {
                    String tok = (String)tokens.get(tokenIdx);
                    int w = this.font.method_1727(tok);
                    if (lineW + w <= textWidth) {
                        sb.append(tok);
                        lineW += w;
                        currentPos += tok.length();
                        ++tokenIdx;
                        continue;
                    }
                    if (lineW != 0) break;
                    String fit = this.font.method_27523(tok, textWidth);
                    if (!fit.isEmpty()) {
                        sb.append(fit);
                        currentPos += fit.length();
                        tokens.set(tokenIdx, tok.substring(fit.length()));
                        break;
                    }
                    tokens.set(tokenIdx, tok.substring(1));
                    ++currentPos;
                    sb.append(tok.charAt(0));
                    break;
                }
                this.textLines.add(sb.toString());
            }
        }
        int scaledVisibleHeight = (int)((float)(this.field_22759 - this.paddingY * 2) / this.textScale);
        int totalTextHeightUnscaled = this.textLines.size() * this.getLineHeight();
        this.maxScrollOffset = Math.max(0, totalTextHeightUnscaled - scaledVisibleHeight);
        this.scrollOffset = class_3532.method_15340((int)this.scrollOffset, (int)0, (int)this.maxScrollOffset);
        this.recalculateLines = false;
        this.updateCursorCoordinates = true;
    }

    private void updateCursorCoordinates() {
        if (this.textLines.isEmpty()) {
            this.cursorLine = 0;
            this.cursorColumn = 0;
            return;
        }
        this.cursorLine = -1;
        for (int i = 0; i < this.lineStartIndices.size(); ++i) {
            int end;
            int start = this.lineStartIndices.get(i);
            int n = end = i < this.lineStartIndices.size() - 1 ? this.lineStartIndices.get(i + 1).intValue() : this.value.length();
            if (this.cursorPos < start || this.cursorPos >= end) continue;
            this.cursorLine = i;
            this.cursorColumn = this.cursorPos - start;
            break;
        }
        if (this.cursorLine == -1) {
            this.cursorLine = this.lineStartIndices.size() - 1;
            this.cursorColumn = this.cursorPos - this.lineStartIndices.get(this.cursorLine);
        }
        if (!this.readOnly && this.followCaret) {
            this.ensureCursorVisible();
        }
        this.updateCursorCoordinates = false;
    }

    private void ensureCursorVisible() {
        int lineHeight = this.getLineHeight();
        int cursorY = this.cursorLine * lineHeight;
        int visibleTop = this.scrollOffset;
        int visibleBottom = this.scrollOffset + (int)((float)(this.field_22759 - this.paddingY * 2) / this.textScale);
        if (cursorY < visibleTop) {
            this.scrollOffset = cursorY;
        } else if (cursorY + lineHeight > visibleBottom) {
            this.scrollOffset = cursorY - (int)((float)(this.field_22759 - this.paddingY * 2) / this.textScale) + lineHeight;
        }
        this.scrollOffset = class_3532.method_15340((int)this.scrollOffset, (int)0, (int)this.maxScrollOffset);
    }

    public void setValue(String text) {
        if (this.filter.test(text)) {
            this.value = text.length() > this.maxLength ? text.substring(0, this.maxLength) : text;
            this.moveCursorToEnd();
            this.setSelectionAnchor(this.cursorPos);
            this.onValueChange(this.value);
        }
    }

    public void insertText(String textToWrite) {
        String string2;
        if (this.readOnly) {
            return;
        }
        int i = Math.min(this.cursorPos, this.selectionAnchor);
        int j = Math.max(this.cursorPos, this.selectionAnchor);
        int k = this.maxLength - this.value.length() - (i - j);
        if (k <= 0) {
            return;
        }
        String string = class_155.method_44355((String)textToWrite, (boolean)true);
        if (string.length() > k) {
            string = string.substring(0, k);
        }
        if (this.filter.test(string2 = new StringBuilder(this.value).replace(i, j, string).toString())) {
            this.value = string2;
            this.setCursorPosition(i + string.length());
            this.setSelectionAnchor(this.cursorPos);
            this.onValueChange(this.value);
        }
    }

    private void deleteText(int count) {
        if (this.readOnly) {
            return;
        }
        if (class_437.method_25441()) {
            this.deleteWords(count);
        } else {
            this.deleteChars(count);
        }
    }

    public void deleteWords(int num) {
        if (this.readOnly) {
            return;
        }
        if (!this.value.isEmpty()) {
            if (this.selectionAnchor != this.cursorPos) {
                this.insertText("");
            } else {
                this.deleteChars(this.getWordPosition(num) - this.cursorPos);
            }
        }
    }

    public void deleteChars(int num) {
        if (this.readOnly) {
            return;
        }
        if (!this.value.isEmpty()) {
            if (this.selectionAnchor != this.cursorPos) {
                this.insertText("");
            } else {
                String string;
                int k;
                int i = this.getCursorPos(num);
                int j = Math.min(i, this.cursorPos);
                if (j != (k = Math.max(i, this.cursorPos)) && this.filter.test(string = new StringBuilder(this.value).delete(j, k).toString())) {
                    this.value = string;
                    this.moveCursorTo(j);
                    this.onValueChange(this.value);
                }
            }
        }
    }

    private void onValueChange(String newText) {
        this.recalculateLines = true;
        if (this.responder != null) {
            this.responder.accept(newText);
        }
    }

    public void setCursorPosition(int pos) {
        this.cursorPos = class_3532.method_15340((int)pos, (int)0, (int)this.value.length());
        this.followCaret = !this.readOnly;
        this.updateCursorCoordinates = true;
    }

    public void moveCursorTo(int pos) {
        this.setCursorPosition(pos);
        if (!this.shiftPressed) {
            this.setSelectionAnchor(this.cursorPos);
        }
    }

    public void moveCursor(int delta) {
        this.moveCursorTo(this.getCursorPos(delta));
    }

    private void moveCursorVertical(int lines) {
        if (this.textLines.isEmpty()) {
            return;
        }
        this.updateCursorCoordinates();
        int targetLine = class_3532.method_15340((int)(this.cursorLine + lines), (int)0, (int)(this.textLines.size() - 1));
        if (targetLine != this.cursorLine) {
            String targetLineText = this.textLines.get(targetLine);
            String currentLineText = this.textLines.get(this.cursorLine);
            int cursorX = this.font.method_1727(currentLineText.substring(0, Math.min(this.cursorColumn, currentLineText.length())));
            int targetColumn = this.font.method_27523(targetLineText, cursorX).length();
            int newPos = this.lineStartIndices.get(targetLine) + targetColumn;
            this.moveCursorTo(newPos);
        }
    }

    public void moveCursorToStart() {
        this.moveCursorTo(0);
    }

    public void moveCursorToEnd() {
        this.moveCursorTo(this.value.length());
    }

    private int getCursorPosX() {
        if (this.cursorLine < 0 || this.cursorLine >= this.textLines.size()) {
            return 0;
        }
        String lineText = this.textLines.get(this.cursorLine);
        int lineStart = this.getLineStartIndex(this.cursorLine);
        int relativePos = this.cursorPos - lineStart;
        if (relativePos < 0) {
            relativePos = 0;
        }
        if (relativePos > lineText.length()) {
            relativePos = lineText.length();
        }
        return this.font.method_1727(lineText.substring(0, relativePos));
    }

    private int getCursorPos(int delta) {
        return class_156.method_27761((String)this.value, (int)this.cursorPos, (int)delta);
    }

    public int getCursorPosition() {
        return this.cursorPos;
    }

    public int getWordPosition(int numWords) {
        return this.getWordPosition(numWords, this.getCursorPosition());
    }

    private static boolean isWordChar(char c) {
        return Character.isLetterOrDigit(c) || c == '_';
    }

    private int nextWordBoundary(int pos) {
        int i;
        int len = this.value.length();
        for (i = class_3532.method_15340((int)pos, (int)0, (int)this.value.length()); i < len && Character.isWhitespace(this.value.charAt(i)); ++i) {
        }
        if (i >= len) {
            return len;
        }
        if (TextBoxEditable.isWordChar(this.value.charAt(i))) {
            while (i < len && TextBoxEditable.isWordChar(this.value.charAt(i))) {
                ++i;
            }
        } else {
            while (i < len && !Character.isWhitespace(this.value.charAt(i)) && !TextBoxEditable.isWordChar(this.value.charAt(i))) {
                ++i;
            }
        }
        return i;
    }

    private int prevWordBoundary(int pos) {
        int i;
        for (i = class_3532.method_15340((int)pos, (int)0, (int)this.value.length()); i > 0 && Character.isWhitespace(this.value.charAt(i - 1)); --i) {
        }
        if (i <= 0) {
            return 0;
        }
        if (TextBoxEditable.isWordChar(this.value.charAt(i - 1))) {
            while (i > 0 && TextBoxEditable.isWordChar(this.value.charAt(i - 1))) {
                --i;
            }
        } else {
            while (i > 0 && !Character.isWhitespace(this.value.charAt(i - 1)) && !TextBoxEditable.isWordChar(this.value.charAt(i - 1))) {
                --i;
            }
        }
        return i;
    }

    private int getWordPosition(int n, int pos) {
        int i = pos;
        if (n == 0) {
            return i;
        }
        int steps = Math.abs(n);
        boolean backward = n < 0;
        for (int k = 0; k < steps; ++k) {
            i = backward ? this.prevWordBoundary(i) : this.nextWordBoundary(i);
        }
        return i;
    }

    private int getLineStartIndex(int lineIndex) {
        if (lineIndex < 0 || lineIndex >= this.lineStartIndices.size()) {
            return 0;
        }
        return this.lineStartIndices.get(lineIndex);
    }

    private int getLineEndIndex(int lineIndex) {
        if (lineIndex < 0 || lineIndex >= this.lineStartIndices.size()) {
            return 0;
        }
        if (lineIndex == this.lineStartIndices.size() - 1) {
            return this.value.length();
        }
        return this.lineStartIndices.get(lineIndex + 1);
    }

    private int getLineVisualEndIndex(int lineIndex) {
        int start = this.getLineStartIndex(lineIndex);
        String lineText = lineIndex >= 0 && lineIndex < this.textLines.size() ? this.textLines.get(lineIndex) : "";
        return start + lineText.length();
    }

    private boolean isLineSelected(int lineIndex) {
        int maxCursor;
        int minCursor = Math.min(this.cursorPos, this.selectionAnchor);
        if (minCursor == (maxCursor = Math.max(this.cursorPos, this.selectionAnchor))) {
            return false;
        }
        int lineStart = this.getLineStartIndex(lineIndex);
        int lineEnd = this.getLineEndIndex(lineIndex);
        return minCursor < lineEnd && maxCursor > lineStart;
    }

    public String getHighlighted() {
        int i = Math.min(this.cursorPos, this.selectionAnchor);
        int j = Math.max(this.cursorPos, this.selectionAnchor);
        return this.value.substring(i, j);
    }

    public boolean canConsumeInput() {
        return this.field_22764 && this.method_25370();
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (!this.canConsumeInput()) {
            return false;
        }
        this.shiftPressed = class_437.method_25442();
        if (class_437.method_25438((int)keyCode)) {
            class_310.method_1551().field_1774.method_1455(this.getHighlighted());
            return true;
        }
        if (class_437.method_25439((int)keyCode)) {
            this.setSelectionAnchor(0);
            this.moveCursorToEnd();
            return true;
        }
        if (class_437.method_25437((int)keyCode)) {
            if (!this.readOnly) {
                this.insertText(class_310.method_1551().field_1774.method_1460());
            }
            return true;
        }
        if (class_437.method_25436((int)keyCode)) {
            class_310.method_1551().field_1774.method_1455(this.getHighlighted());
            if (!this.readOnly) {
                this.insertText("");
            }
            return true;
        }
        if (this.readOnly) {
            switch (keyCode) {
                case 266: {
                    this.setScrollAmount(this.getScrollAmount() - (double)(this.getLineHeightScaled() * 4));
                    return true;
                }
                case 267: {
                    this.setScrollAmount(this.getScrollAmount() + (double)(this.getLineHeightScaled() * 4));
                    return true;
                }
                case 265: {
                    this.setScrollAmount(this.getScrollAmount() - (double)this.getLineHeightScaled());
                    return true;
                }
                case 264: {
                    this.setScrollAmount(this.getScrollAmount() + (double)this.getLineHeightScaled());
                    return true;
                }
                case 268: {
                    this.setScrollAmount(0.0);
                    return true;
                }
                case 269: {
                    this.setScrollAmount(this.maxScrollOffset);
                    return true;
                }
            }
            return false;
        }
        switch (keyCode) {
            case 257: 
            case 335: {
                if (!this.readOnly) {
                    this.insertText("\n");
                }
                return true;
            }
            case 259: {
                if (!this.readOnly) {
                    this.shiftPressed = false;
                    this.deleteText(-1);
                    this.shiftPressed = class_437.method_25442();
                }
                return true;
            }
            case 261: {
                if (!this.readOnly) {
                    this.shiftPressed = false;
                    this.deleteText(1);
                    this.shiftPressed = class_437.method_25442();
                }
                return true;
            }
            case 262: {
                if (class_437.method_25441()) {
                    this.moveCursorTo(this.getWordPosition(1));
                } else {
                    this.moveCursor(1);
                }
                return true;
            }
            case 263: {
                if (class_437.method_25441()) {
                    this.moveCursorTo(this.getWordPosition(-1));
                } else {
                    this.moveCursor(-1);
                }
                return true;
            }
            case 264: {
                this.moveCursorVertical(1);
                return true;
            }
            case 265: {
                this.moveCursorVertical(-1);
                return true;
            }
            case 268: {
                if (class_437.method_25441()) {
                    this.moveCursorToStart();
                } else {
                    this.calculateLines();
                    this.updateCursorCoordinates();
                    int start = this.getLineStartIndex(this.cursorLine);
                    this.moveCursorTo(start);
                }
                return true;
            }
            case 269: {
                if (class_437.method_25441()) {
                    this.moveCursorToEnd();
                } else {
                    this.calculateLines();
                    this.updateCursorCoordinates();
                    int end = this.getLineVisualEndIndex(this.cursorLine);
                    this.moveCursorTo(end);
                }
                return true;
            }
        }
        return false;
    }

    public void method_25354(class_1144 handler) {
    }

    public void method_25365(boolean focused) {
        super.method_25365(focused);
        if (!focused) {
            this.selectionAnchor = this.cursorPos;
            this.shiftPressed = false;
        }
    }

    public boolean method_25400(char codePoint, int modifiers) {
        if (!this.canConsumeInput()) {
            return false;
        }
        if (class_155.method_643((char)codePoint)) {
            if (!this.readOnly) {
                this.insertText(Character.toString(codePoint));
            }
            return true;
        }
        return false;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (!(this.field_22763 && this.field_22764 && this.method_25351(button))) {
            return false;
        }
        if (this.isScrollbarHovered(mouseX, mouseY)) {
            int currentThumbY;
            boolean consumed = super.method_25402(mouseX, mouseY, button);
            this.scrolling = true;
            this.followCaret = false;
            this.lastScrollingCall = System.currentTimeMillis();
            int trackY = this.method_46427() + this.paddingY;
            int trackHeight = this.field_22759 - this.paddingY * 2;
            int contentHeightUnscaled = this.textLines.size() * this.getLineHeight();
            int visibleHeightUnscaled = (int)((float)(this.field_22759 - this.paddingY * 2) / this.textScale);
            int thumbHeight = Math.max(16, Math.min(trackHeight, (int)Math.round((double)visibleHeightUnscaled / (double)contentHeightUnscaled * (double)trackHeight)));
            if (this.maxScrollOffset > 0) {
                double ratio = (double)this.scrollOffset / (double)this.maxScrollOffset;
                currentThumbY = trackY + (int)Math.round((double)(trackHeight - thumbHeight) * ratio);
            } else {
                currentThumbY = trackY;
            }
            int offset = (int)Math.round(mouseY) - currentThumbY;
            this.thumbGrabOffset = class_3532.method_15340((int)offset, (int)0, (int)thumbHeight);
            return true;
        }
        boolean bl = this.shiftPressed = this.readOnly ? false : class_437.method_25442();
        if (!this.readOnly && !this.shiftPressed) {
            this.setSelectionAnchor(this.cursorPos);
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public void method_25348(double mouseX, double mouseY) {
        if (this.readOnly) {
            return;
        }
        if (mouseX >= (double)(this.method_46426() + this.paddingX) && mouseX < (double)(this.method_46426() + this.field_22758 - this.paddingX - this.scrollBarWidth) && mouseY >= (double)(this.method_46427() + this.paddingY) && mouseY < (double)(this.method_46427() + this.field_22759 - this.paddingY)) {
            if (VisorAPI.clientState().stateMode().isActive()) {
                VRKeyboardAccessor keyboardAccessor = VisorAPI.client().getGuiManager().getOverlayManager().getKeyboardAccessor();
                VRCursorHandler cursorHandler = VisorAPI.client().getGuiManager().getCursorHandler();
                if (cursorHandler.isCursorHandFocused()) {
                    class_437 overlayBase = null;
                    VROverlay vROverlay = cursorHandler.getFocusedOverlay();
                    if (vROverlay instanceof VROverlayScreen) {
                        VROverlayScreen overlayScreen = (VROverlayScreen)vROverlay;
                        overlayBase = overlayScreen;
                    }
                    class_437 screenFocused = overlayBase == null ? class_310.method_1551().field_1755 : overlayBase;
                    keyboardAccessor.showKeyboard(screenFocused);
                }
            }
            this.followCaret = true;
            this.calculateLines();
            double relativeX = (mouseX - (double)(this.method_46426() + this.paddingX)) / (double)this.textScale;
            double relativeY = (mouseY - (double)(this.method_46427() + this.paddingY)) / (double)this.textScale + (double)this.scrollOffset;
            int lineIndex = class_3532.method_15357((double)(relativeY / (double)this.getLineHeight()));
            if (lineIndex >= 0 && lineIndex < this.textLines.size()) {
                String lineText = this.textLines.get(lineIndex);
                int lineStart = this.lineStartIndices.get(lineIndex);
                if (lineText.isEmpty() || lineText.trim().isEmpty()) {
                    this.moveCursorTo(lineStart);
                } else {
                    int charPos = this.findClosestCharPosition(lineText, relativeX);
                    int newCursorPos = lineStart + charPos;
                    this.moveCursorTo(newCursorPos);
                }
            } else if (lineIndex >= this.textLines.size()) {
                this.moveCursorToEnd();
            }
        }
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        this.followCaret = false;
        if (button == 0 && !this.scrolling && !this.readOnly) {
            this.calculateLines();
            if (mouseY < (double)(this.method_46427() + this.paddingY)) {
                this.setScrollAmount(this.getScrollAmount() - (double)this.getLineHeightScaled());
            } else if (mouseY > (double)(this.method_46427() + this.field_22759 - this.paddingY)) {
                this.setScrollAmount(this.getScrollAmount() + (double)this.getLineHeightScaled());
            }
            double relativeX = (mouseX - (double)(this.method_46426() + this.paddingX)) / (double)this.textScale;
            double relativeY = (mouseY - (double)(this.method_46427() + this.paddingY)) / (double)this.textScale + (double)this.scrollOffset;
            int lineIndex = class_3532.method_15357((double)(relativeY / (double)this.getLineHeight()));
            if (lineIndex < 0) {
                this.setCursorPositionKeepAnchor(0);
            } else if (lineIndex >= this.textLines.size()) {
                this.setCursorPositionKeepAnchor(this.value.length());
            } else {
                String lineText = this.textLines.get(lineIndex);
                int lineStart = this.lineStartIndices.get(lineIndex);
                if (lineText.isEmpty() || lineText.trim().isEmpty()) {
                    this.setCursorPositionKeepAnchor(lineStart);
                } else {
                    int charPos = this.findClosestCharPosition(lineText, relativeX);
                    this.setCursorPositionKeepAnchor(lineStart + charPos);
                }
            }
            return true;
        }
        if (button == 0 && this.scrolling) {
            this.lastScrollingCall = System.currentTimeMillis();
            int trackY = this.method_46427() + this.paddingY;
            int trackHeight = this.field_22759 - this.paddingY * 2;
            int contentHeightUnscaled = this.textLines.size() * this.getLineHeight();
            int visibleHeightUnscaled = (int)((float)(this.field_22759 - this.paddingY * 2) / this.textScale);
            int thumbHeight = Math.max(16, Math.min(trackHeight, (int)Math.round((double)visibleHeightUnscaled / (double)contentHeightUnscaled * (double)trackHeight)));
            double thumbTravel = Math.max(0.0, (double)(trackHeight - thumbHeight));
            double grab = this.thumbGrabOffset >= 0 ? (double)this.thumbGrabOffset : (double)thumbHeight / 2.0;
            double thumbPos = class_3532.method_15350((double)(mouseY - (double)trackY - grab), (double)0.0, (double)thumbTravel);
            double ratio = thumbTravel <= 0.0 ? 0.0 : thumbPos / thumbTravel;
            this.setScrollAmount(ratio * (double)this.maxScrollOffset);
            return true;
        }
        return false;
    }

    public boolean method_25401(double mouseX, double mouseY, double scrollDelta) {
        if (this.method_25367() && this.field_22764) {
            this.followCaret = false;
            this.setScrollAmount(this.getScrollAmount() - scrollDelta * (double)this.getLineHeightScaled() / 2.0);
            return true;
        }
        return false;
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.scrolling = false;
            this.thumbGrabOffset = -1;
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    private int findClosestCharPosition(String text, double relativeX) {
        int atWidth;
        int beforeWidth;
        if (text.isEmpty()) {
            return 0;
        }
        int clickX = (int)relativeX;
        if (clickX <= 0) {
            return 0;
        }
        if (clickX >= this.font.method_1727(text)) {
            return text.length();
        }
        int low = 0;
        int high = text.length();
        while (low < high) {
            int mid = (low + high) / 2;
            int width = this.font.method_1727(text.substring(0, mid));
            if (width < clickX) {
                low = mid + 1;
                continue;
            }
            high = mid;
        }
        if (low > 0 && clickX - (beforeWidth = this.font.method_1727(text.substring(0, low - 1))) < (atWidth = this.font.method_1727(text.substring(0, low))) - clickX) {
            return low - 1;
        }
        return low;
    }

    protected boolean isScrollbarHovered(double mouseX, double mouseY) {
        int scrollbarX = this.getScrollbarX();
        return mouseX >= (double)scrollbarX && mouseX < (double)(scrollbarX + this.scrollBarWidth) && mouseY >= (double)this.method_46427() && mouseY < (double)(this.method_46427() + this.field_22759);
    }

    protected int getScrollbarX() {
        return this.method_46426() + this.field_22758 - this.scrollBarWidth;
    }

    protected int getLineHeightScaled() {
        return (int)((float)this.getLineHeight() * this.textScale);
    }

    protected int getLineHeight() {
        Objects.requireNonNull(this.font);
        return 9 + 2;
    }

    public double getScrollAmount() {
        return this.scrollOffset;
    }

    public void setScrollAmount(double amount) {
        this.calculateLines();
        this.scrollOffset = (int)class_3532.method_15350((double)amount, (double)0.0, (double)this.maxScrollOffset);
    }

    public void setSelectionAnchor(int position) {
        this.selectionAnchor = class_3532.method_15340((int)position, (int)0, (int)this.value.length());
        this.updateCursorCoordinates = true;
    }

    private void setCursorPositionKeepAnchor(int pos) {
        this.cursorPos = class_3532.method_15340((int)pos, (int)0, (int)this.value.length());
        this.updateCursorCoordinates = true;
    }

    public boolean isTextSelected() {
        return this.selectionAnchor != this.cursorPos;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
        if (readOnly) {
            this.followCaret = false;
            this.selectionAnchor = this.cursorPos;
        }
    }

    public void setMaxLength(int length) {
        this.maxLength = length;
        if (this.value.length() > length) {
            this.setValue(this.value.substring(0, length));
        }
    }

    protected void method_47399(@NotNull class_6382 narrationElementOutput) {
    }

    public String getValue() {
        return this.value;
    }

    public void setHint(@Nullable class_2561 hint) {
        this.hint = hint;
    }

    public void setResponder(@Nullable Consumer<String> responder) {
        this.responder = responder;
    }

    public void setFilter(Predicate<String> filter) {
        this.filter = filter;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public int getScrollOffset() {
        return this.scrollOffset;
    }
}

