/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.api.client.gui.widgets.info;

import me.phoenixra.atumvr.api.misc.color.AtumColor;
import me.phoenixra.visor.api.client.gui.GuiTexture;
import me.phoenixra.visor.api.client.gui.widgets.info.WidgetInfo;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_7919;
import org.jetbrains.annotations.NotNull;

public class WidgetInfoSlider
extends WidgetInfo {
    private GuiTexture backgroundTexture;
    private GuiTexture knobTexture;
    private GuiTexture knobTextureHovered;
    private GuiTexture knobTextureInactive;
    private boolean knobHighlightEnabled = false;
    private boolean knobHighlightCorners = true;
    private AtumColor knobHighlightHovered = AtumColor.WHITE;
    private float knobHighlightThickness = 0.65f;
    private int knobWidth = 6;
    private class_327 textFont;
    private AtumColor textColor;
    private boolean scaleText;
    private class_7919 tooltip;
    private int knobHighlightHoveredInt;
    private int knobHighlightCornerHoveredInt;

    public WidgetInfoSlider(@NotNull WidgetInfoSlider copyFrom) {
        super(copyFrom);
        this.textFont = class_310.method_1551().field_1772;
        this.textColor = AtumColor.WHITE;
        this.scaleText = false;
        this.knobHighlightHoveredInt = AtumColor.WHITE.toInt();
        this.knobHighlightCornerHoveredInt = AtumColor.WHITE.toInt();
        this.backgroundTexture = copyFrom.backgroundTexture;
        this.knobTexture = copyFrom.knobTexture;
        this.knobTextureHovered = copyFrom.knobTextureHovered;
        this.knobTextureInactive = copyFrom.knobTextureInactive;
        this.knobHighlightEnabled = copyFrom.knobHighlightEnabled;
        this.knobHighlightCorners = copyFrom.knobHighlightCorners;
        this.knobHighlightHovered = copyFrom.knobHighlightHovered;
        this.knobHighlightThickness = copyFrom.knobHighlightThickness;
        this.knobHighlightHoveredInt = copyFrom.knobHighlightHoveredInt;
        this.knobHighlightCornerHoveredInt = copyFrom.knobHighlightCornerHoveredInt;
        this.knobWidth = copyFrom.knobWidth;
        this.textFont = copyFrom.textFont;
        this.textColor = copyFrom.textColor;
        this.scaleText = copyFrom.scaleText;
        this.tooltip = copyFrom.tooltip;
    }

    public WidgetInfoSlider() {
        this.textFont = class_310.method_1551().field_1772;
        this.textColor = AtumColor.WHITE;
        this.scaleText = false;
        this.knobHighlightHoveredInt = AtumColor.WHITE.toInt();
        this.knobHighlightCornerHoveredInt = AtumColor.WHITE.toInt();
    }

    public WidgetInfoSlider textures(GuiTexture background, GuiTexture knob, GuiTexture knobHovered, GuiTexture knobInactive) {
        return this.setBackgroundTexture(background).setKnobTexture(knob).setKnobTextureHovered(knobHovered).setKnobTextureInactive(knobInactive);
    }

    public WidgetInfoSlider textures(GuiTexture background, GuiTexture knob, GuiTexture knobHovered) {
        return this.setBackgroundTexture(background).setKnobTexture(knob).setKnobTextureHovered(knobHovered).setKnobTextureInactive(knob);
    }

    public WidgetInfoSlider highlight(AtumColor hovered, float thickness) {
        return this.setKnobHighlightEnabled(true).setKnobHighlightHovered(hovered).setKnobHighlightThickness(thickness);
    }

    public WidgetInfoSlider highlight(AtumColor hovered) {
        return this.setKnobHighlightEnabled(true).setKnobHighlightHovered(hovered);
    }

    public WidgetInfoSlider setKnobHighlightHovered(AtumColor color) {
        this.knobHighlightHovered = color;
        this.knobHighlightHoveredInt = color.toInt();
        this.knobHighlightCornerHoveredInt = color.lighten(0.25f).toInt();
        return this;
    }

    @Override
    public WidgetInfoSlider pos(int x, int y) {
        return (WidgetInfoSlider)super.pos(x, y);
    }

    @Override
    public WidgetInfoSlider size(int width, int height) {
        return (WidgetInfoSlider)super.size(width, height);
    }

    public void drawHighlight(class_332 guiGraphics, int x, int y, int width, int height, boolean active, boolean hovered) {
        if (!this.knobHighlightEnabled) {
            return;
        }
        if (!hovered || !active) {
            return;
        }
        int baseColor = this.knobHighlightHoveredInt;
        int cornerColor = this.knobHighlightCornerHoveredInt;
        float s = Math.max(0.0f, this.knobHighlightThickness);
        if (s <= 0.0f) {
            return;
        }
        float x0 = x;
        float y0 = y;
        float x1 = x + width;
        float y1 = y + height;
        float innerW = Math.max(0.0f, x1 - x0);
        float innerH = Math.max(0.0f, y1 - y0);
        if (innerW <= 0.0f || innerH <= 0.0f) {
            return;
        }
        float innerHAvail = Math.max(0.0f, innerH - 2.0f * s);
        class_4587 pose = guiGraphics.method_51448();
        pose.method_22903();
        pose.method_46416(x0, y0, 0.0f);
        pose.method_22905(innerW, s, 1.0f);
        guiGraphics.method_25294(0, 0, 1, 1, baseColor);
        pose.method_22909();
        pose.method_22903();
        pose.method_46416(x0, y1 - s, 0.0f);
        pose.method_22905(innerW, s, 1.0f);
        guiGraphics.method_25294(0, 0, 1, 1, baseColor);
        pose.method_22909();
        if (innerHAvail > 0.0f) {
            pose.method_22903();
            pose.method_46416(x0, y0 + s, 0.0f);
            pose.method_22905(s, innerHAvail, 1.0f);
            guiGraphics.method_25294(0, 0, 1, 1, baseColor);
            pose.method_22909();
            pose.method_22903();
            pose.method_46416(x1 - s, y0 + s, 0.0f);
            pose.method_22905(s, innerHAvail, 1.0f);
            guiGraphics.method_25294(0, 0, 1, 1, baseColor);
            pose.method_22909();
        }
        if (this.knobHighlightCorners) {
            pose.method_22903();
            pose.method_46416(x0, y0, 0.0f);
            pose.method_22905(s, s, 1.0f);
            guiGraphics.method_25294(0, 0, 1, 1, cornerColor);
            pose.method_22909();
            pose.method_22903();
            pose.method_46416(x1 - s, y0, 0.0f);
            pose.method_22905(s, s, 1.0f);
            guiGraphics.method_25294(0, 0, 1, 1, cornerColor);
            pose.method_22909();
            pose.method_22903();
            pose.method_46416(x0, y1 - s, 0.0f);
            pose.method_22905(s, s, 1.0f);
            guiGraphics.method_25294(0, 0, 1, 1, cornerColor);
            pose.method_22909();
            pose.method_22903();
            pose.method_46416(x1 - s, y1 - s, 0.0f);
            pose.method_22905(s, s, 1.0f);
            guiGraphics.method_25294(0, 0, 1, 1, cornerColor);
            pose.method_22909();
        }
    }

    public WidgetInfoSlider setBackgroundTexture(GuiTexture backgroundTexture) {
        this.backgroundTexture = backgroundTexture;
        return this;
    }

    public GuiTexture getBackgroundTexture() {
        return this.backgroundTexture;
    }

    public WidgetInfoSlider setKnobTexture(GuiTexture knobTexture) {
        this.knobTexture = knobTexture;
        return this;
    }

    public GuiTexture getKnobTexture() {
        return this.knobTexture;
    }

    public WidgetInfoSlider setKnobTextureHovered(GuiTexture knobTextureHovered) {
        this.knobTextureHovered = knobTextureHovered;
        return this;
    }

    public GuiTexture getKnobTextureHovered() {
        return this.knobTextureHovered;
    }

    public WidgetInfoSlider setKnobTextureInactive(GuiTexture knobTextureInactive) {
        this.knobTextureInactive = knobTextureInactive;
        return this;
    }

    public GuiTexture getKnobTextureInactive() {
        return this.knobTextureInactive;
    }

    public WidgetInfoSlider setKnobHighlightEnabled(boolean knobHighlightEnabled) {
        this.knobHighlightEnabled = knobHighlightEnabled;
        return this;
    }

    public boolean isKnobHighlightEnabled() {
        return this.knobHighlightEnabled;
    }

    public WidgetInfoSlider setKnobHighlightCorners(boolean knobHighlightCorners) {
        this.knobHighlightCorners = knobHighlightCorners;
        return this;
    }

    public boolean isKnobHighlightCorners() {
        return this.knobHighlightCorners;
    }

    public AtumColor getKnobHighlightHovered() {
        return this.knobHighlightHovered;
    }

    public WidgetInfoSlider setKnobHighlightThickness(float knobHighlightThickness) {
        this.knobHighlightThickness = knobHighlightThickness;
        return this;
    }

    public float getKnobHighlightThickness() {
        return this.knobHighlightThickness;
    }

    public WidgetInfoSlider setKnobWidth(int knobWidth) {
        this.knobWidth = knobWidth;
        return this;
    }

    public int getKnobWidth() {
        return this.knobWidth;
    }

    public WidgetInfoSlider setTextFont(class_327 textFont) {
        this.textFont = textFont;
        return this;
    }

    public class_327 getTextFont() {
        return this.textFont;
    }

    public WidgetInfoSlider setTextColor(AtumColor textColor) {
        this.textColor = textColor;
        return this;
    }

    public AtumColor getTextColor() {
        return this.textColor;
    }

    public WidgetInfoSlider setScaleText(boolean scaleText) {
        this.scaleText = scaleText;
        return this;
    }

    public boolean isScaleText() {
        return this.scaleText;
    }

    public WidgetInfoSlider setTooltip(class_7919 tooltip) {
        this.tooltip = tooltip;
        return this;
    }

    public class_7919 getTooltip() {
        return this.tooltip;
    }
}

