/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.api.client.gui.widgets.info;

import java.util.Objects;
import java.util.function.DoubleConsumer;
import java.util.function.DoubleSupplier;
import me.phoenixra.atumvr.api.misc.color.AtumColor;
import me.phoenixra.visor.api.client.gui.GuiTexture;
import me.phoenixra.visor.api.client.gui.widgets.info.WidgetInfoImage;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import org.jetbrains.annotations.NotNull;

public class WidgetInfoValueDrag
extends WidgetInfoImage {
    private GuiTexture textureHovered;
    private GuiTexture textureDragged;
    private GuiTexture textureInactive;
    private boolean highlightEnabled = false;
    private boolean highlightCorners = true;
    private AtumColor highlightHovered = AtumColor.WHITE;
    private AtumColor highlightDragged = AtumColor.WHITE;
    private float highlightThickness = 0.65f;
    private Direction direction;
    private NumericAdapter adapter;
    private double step = 1.0;
    private double sensitivity = 1.0;
    private int highlightHoveredInt = AtumColor.WHITE.toInt();
    private int highlightDraggedInt = AtumColor.WHITE.toInt();
    private int highlightCornerHoveredInt = AtumColor.WHITE.toInt();
    private int highlightCornerDraggedInt = AtumColor.WHITE.toInt();

    public WidgetInfoValueDrag(@NotNull WidgetInfoValueDrag copyFrom) {
        super(copyFrom);
        this.direction = copyFrom.direction;
        this.adapter = copyFrom.adapter;
        this.step = copyFrom.step;
        this.sensitivity = copyFrom.sensitivity;
    }

    public WidgetInfoValueDrag() {
    }

    @Override
    public WidgetInfoValueDrag pos(int x, int y) {
        return (WidgetInfoValueDrag)super.pos(x, y);
    }

    @Override
    public WidgetInfoValueDrag size(int width, int height) {
        return (WidgetInfoValueDrag)super.size(width, height);
    }

    @Override
    public WidgetInfoValueDrag setTexture(GuiTexture texture) {
        return (WidgetInfoValueDrag)super.setTexture(texture);
    }

    public WidgetInfoValueDrag highlight(AtumColor hovered, AtumColor dragged, float thickness) {
        return this.setHighlightEnabled(true).setHighlightHovered(hovered).setHighlightDragged(dragged).setHighlightThickness(thickness);
    }

    public WidgetInfoValueDrag highlight(AtumColor hovered, AtumColor dragged) {
        return this.setHighlightEnabled(true).setHighlightHovered(hovered).setHighlightDragged(dragged);
    }

    public WidgetInfoValueDrag setHighlightHovered(AtumColor color) {
        this.highlightHovered = color;
        this.highlightHoveredInt = color.toInt();
        this.highlightCornerHoveredInt = color.lighten(0.25f).toInt();
        return this;
    }

    public WidgetInfoValueDrag setHighlightDragged(AtumColor color) {
        this.highlightDragged = color;
        this.highlightDraggedInt = color.toInt();
        this.highlightCornerDraggedInt = color.lighten(0.25f).toInt();
        return this;
    }

    public void drawHighlight(class_332 guiGraphics, int x, int y, int width, int height, boolean active, boolean hovered, boolean dragged) {
        if (!this.highlightEnabled) {
            return;
        }
        if (!active) {
            return;
        }
        if (!hovered && !dragged) {
            return;
        }
        int baseColor = hovered ? this.highlightHoveredInt : this.highlightDraggedInt;
        int cornerColor = hovered ? this.highlightCornerHoveredInt : this.highlightCornerDraggedInt;
        float s = Math.max(0.0f, this.highlightThickness);
        if (s <= 0.0f) {
            return;
        }
        float x0 = x;
        float y0 = y;
        float x1 = x + width;
        float y1 = y + height;
        float innerW = Math.max(0.0f, x1 - x0);
        float innerH = Math.max(0.0f, y1 - y0);
        if (innerW <= 0.0f || innerH <= 0.0f) {
            return;
        }
        float innerHAvail = Math.max(0.0f, innerH - 2.0f * s);
        class_4587 pose = guiGraphics.method_51448();
        pose.method_22903();
        pose.method_46416(x0, y0, 0.0f);
        pose.method_22905(innerW, s, 1.0f);
        guiGraphics.method_25294(0, 0, 1, 1, baseColor);
        pose.method_22909();
        pose.method_22903();
        pose.method_46416(x0, y1 - s, 0.0f);
        pose.method_22905(innerW, s, 1.0f);
        guiGraphics.method_25294(0, 0, 1, 1, baseColor);
        pose.method_22909();
        if (innerHAvail > 0.0f) {
            pose.method_22903();
            pose.method_46416(x0, y0 + s, 0.0f);
            pose.method_22905(s, innerHAvail, 1.0f);
            guiGraphics.method_25294(0, 0, 1, 1, baseColor);
            pose.method_22909();
            pose.method_22903();
            pose.method_46416(x1 - s, y0 + s, 0.0f);
            pose.method_22905(s, innerHAvail, 1.0f);
            guiGraphics.method_25294(0, 0, 1, 1, baseColor);
            pose.method_22909();
        }
        if (this.highlightCorners) {
            pose.method_22903();
            pose.method_46416(x0, y0, 0.0f);
            pose.method_22905(s, s, 1.0f);
            guiGraphics.method_25294(0, 0, 1, 1, cornerColor);
            pose.method_22909();
            pose.method_22903();
            pose.method_46416(x1 - s, y0, 0.0f);
            pose.method_22905(s, s, 1.0f);
            guiGraphics.method_25294(0, 0, 1, 1, cornerColor);
            pose.method_22909();
            pose.method_22903();
            pose.method_46416(x0, y1 - s, 0.0f);
            pose.method_22905(s, s, 1.0f);
            guiGraphics.method_25294(0, 0, 1, 1, cornerColor);
            pose.method_22909();
            pose.method_22903();
            pose.method_46416(x1 - s, y1 - s, 0.0f);
            pose.method_22905(s, s, 1.0f);
            guiGraphics.method_25294(0, 0, 1, 1, cornerColor);
            pose.method_22909();
        }
    }

    public WidgetInfoValueDrag setTextureHovered(GuiTexture textureHovered) {
        this.textureHovered = textureHovered;
        return this;
    }

    public GuiTexture getTextureHovered() {
        return this.textureHovered;
    }

    public WidgetInfoValueDrag setTextureDragged(GuiTexture textureDragged) {
        this.textureDragged = textureDragged;
        return this;
    }

    public GuiTexture getTextureDragged() {
        return this.textureDragged;
    }

    public WidgetInfoValueDrag setTextureInactive(GuiTexture textureInactive) {
        this.textureInactive = textureInactive;
        return this;
    }

    public GuiTexture getTextureInactive() {
        return this.textureInactive;
    }

    public WidgetInfoValueDrag setHighlightEnabled(boolean highlightEnabled) {
        this.highlightEnabled = highlightEnabled;
        return this;
    }

    public boolean isHighlightEnabled() {
        return this.highlightEnabled;
    }

    public WidgetInfoValueDrag setHighlightCorners(boolean highlightCorners) {
        this.highlightCorners = highlightCorners;
        return this;
    }

    public boolean isHighlightCorners() {
        return this.highlightCorners;
    }

    public AtumColor getHighlightHovered() {
        return this.highlightHovered;
    }

    public AtumColor getHighlightDragged() {
        return this.highlightDragged;
    }

    public WidgetInfoValueDrag setHighlightThickness(float highlightThickness) {
        this.highlightThickness = highlightThickness;
        return this;
    }

    public float getHighlightThickness() {
        return this.highlightThickness;
    }

    public WidgetInfoValueDrag setDirection(Direction direction) {
        this.direction = direction;
        return this;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public WidgetInfoValueDrag setAdapter(NumericAdapter adapter) {
        this.adapter = adapter;
        return this;
    }

    public NumericAdapter getAdapter() {
        return this.adapter;
    }

    public WidgetInfoValueDrag setStep(double step) {
        this.step = step;
        return this;
    }

    public double getStep() {
        return this.step;
    }

    public WidgetInfoValueDrag setSensitivity(double sensitivity) {
        this.sensitivity = sensitivity;
        return this;
    }

    public double getSensitivity() {
        return this.sensitivity;
    }

    public static enum Direction {
        LEFT,
        RIGHT;


        public boolean isPositive() {
            return this == RIGHT;
        }

        public boolean isNegative() {
            return this == LEFT;
        }
    }

    public static interface NumericAdapter {
        public double get();

        public void set(double var1);

        public static NumericAdapter of(final @NotNull DoubleSupplier getter, final @NotNull DoubleConsumer setter) {
            Objects.requireNonNull(getter, "getter");
            Objects.requireNonNull(setter, "setter");
            return new NumericAdapter(){

                @Override
                public double get() {
                    return getter.getAsDouble();
                }

                @Override
                public void set(double value) {
                    setter.accept(value);
                }
            };
        }
    }
}

