/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.api.client.gui.widgets.lists;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import me.phoenixra.visor.api.client.gui.GuiTexture;
import me.phoenixra.visor.api.client.gui.helpers.GuiHelper;
import me.phoenixra.visor.api.client.gui.widgets.info.WidgetInfoCheckboxList;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1144;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import net.minecraft.class_350;
import net.minecraft.class_3532;
import net.minecraft.class_6382;
import net.minecraft.class_6880;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CheckboxList
extends class_350<CheckboxEntry> {
    private final int paddingTop;
    private final int paddingLeft;
    private final int paddingCheckbox;
    private final int scrollBarWidth;
    private final WidgetInfoCheckboxList widgetInfo;
    private final Consumer<CheckboxEntry> onChanged;
    private final Map<String, CheckboxEntry> entriesMap = new HashMap<String, CheckboxEntry>();
    private Map<String, String> rawEntries;
    private Map<String, Boolean> rawEntriesState;
    private long lastDragCall = -1L;

    public CheckboxList(@NotNull WidgetInfoCheckboxList widgetInfo, @NotNull Map<String, String> rawEntries, @NotNull List<String> selectedEntries, @Nullable Consumer<CheckboxEntry> onChanged) {
        super(class_310.method_1551(), widgetInfo.getWidth(), widgetInfo.getHeight(), widgetInfo.getY(), widgetInfo.getY() + widgetInfo.getHeight(), widgetInfo.getItemHeight());
        this.widgetInfo = widgetInfo;
        this.paddingTop = widgetInfo.getPaddingTop();
        this.paddingLeft = widgetInfo.getPaddingLeft();
        this.paddingCheckbox = widgetInfo.getPaddingCheckbox();
        this.scrollBarWidth = widgetInfo.getScrollBarWidth();
        this.onChanged = onChanged;
        this.method_25333(widgetInfo.getX());
        this.method_31323(false);
        this.method_31322(false);
        this.method_29344(false);
        this.resetEntries(rawEntries, selectedEntries);
    }

    public void method_25394(@NotNull class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        CheckboxEntry checkboxEntry = this.field_33780 = this.method_25405(mouseX, mouseY) ? this.getEntryAtPosition(mouseX, mouseY) : null;
        if (this.field_22750 && this.lastDragCall + 200L < System.currentTimeMillis()) {
            this.field_22750 = false;
            this.lastDragCall = -1L;
        }
        this.method_49603(guiGraphics);
        this.method_25311(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.method_44380();
        int scrollX = this.method_25329();
        int maxScroll = this.method_25331();
        if (maxScroll > 0) {
            int trackTop = this.field_19085 + this.paddingTop;
            int trackBottom = this.field_19086 - this.paddingTop;
            int viewH = trackBottom - trackTop;
            int thumbH = (int)((float)viewH * (float)viewH / ((float)viewH + (float)maxScroll));
            thumbH = class_3532.method_15340((int)thumbH, (int)32, (int)(viewH - 8));
            int thumbY = trackTop + (int)(this.method_25341() * (double)(viewH - thumbH) / (double)maxScroll);
            GuiTexture scrollBarTex = this.field_22750 ? this.widgetInfo.getTextureScrollBarActive() : this.widgetInfo.getTextureScrollBar();
            scrollBarTex.blit(guiGraphics, scrollX, thumbY, this.scrollBarWidth, thumbH);
        }
        RenderSystem.disableBlend();
    }

    protected void method_25311(@NotNull class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        int i = this.method_25342();
        int j = this.method_25322();
        int k = this.field_22741 - this.paddingTop;
        int l = this.method_25340();
        for (int m = 0; m < l; ++m) {
            int n = this.method_25337(m);
            int o = this.method_25319(m);
            if (o < this.field_19085 || n > this.field_19086) continue;
            this.method_44397(guiGraphics, mouseX, mouseY, partialTick, m, i, n, j, k);
        }
    }

    public void filterEntries(@NotNull Function<Map.Entry<String, String>, Boolean> filter) {
        this.method_25339();
        this.entriesMap.clear();
        this.method_25307(0.0);
        for (Map.Entry<String, String> entry : this.rawEntries.entrySet()) {
            if (!filter.apply(entry).booleanValue()) continue;
            CheckboxEntry checkboxEntry = new CheckboxEntry(entry.getKey(), (class_2561)class_2561.method_43470((String)entry.getValue()), this.rawEntriesState.get(entry.getKey()));
            this.method_25321(checkboxEntry);
            this.entriesMap.put(checkboxEntry.id, checkboxEntry);
        }
    }

    public void resetEntries(@NotNull Map<String, String> rawEntries, @NotNull List<String> selectedEntries) {
        this.method_25339();
        this.entriesMap.clear();
        this.method_25307(0.0);
        for (Map.Entry<String, String> entry : rawEntries.entrySet()) {
            CheckboxEntry checkboxEntry = new CheckboxEntry(entry.getKey(), (class_2561)class_2561.method_43470((String)entry.getValue()), selectedEntries.contains(entry.getKey()));
            this.method_25321(checkboxEntry);
            this.entriesMap.put(checkboxEntry.id, checkboxEntry);
        }
        this.rawEntries = rawEntries;
        this.rawEntriesState = new HashMap<String, Boolean>();
        for (String id : rawEntries.keySet()) {
            this.rawEntriesState.put(id, selectedEntries.contains(id));
        }
    }

    public void changeSelectedAll(boolean flag) {
        for (CheckboxEntry entry : this.method_25396()) {
            entry.setSelected(flag);
        }
    }

    public boolean isAllSelected() {
        for (Map.Entry<String, Boolean> entry : this.rawEntriesState.entrySet()) {
            if (entry.getValue().booleanValue()) continue;
            return false;
        }
        return true;
    }

    public boolean isAllNotSelected() {
        for (Map.Entry<String, Boolean> entry : this.rawEntriesState.entrySet()) {
            if (!entry.getValue().booleanValue()) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public CheckboxEntry getEntry(@NotNull String id) {
        return this.entriesMap.get(id);
    }

    public List<CheckboxEntry> getSelectedEntries() {
        return this.method_25396().stream().filter(it -> it.selected).toList();
    }

    public List<String> getSelectedEntriesId() {
        return this.method_25396().stream().filter(it -> it.selected).map(it -> it.id).toList();
    }

    public List<String> getEntriesId() {
        return this.method_25396().stream().map(it -> it.id).toList();
    }

    public void scrollTo(@NotNull CheckboxEntry entry) {
        int maxScroll = this.method_25331();
        if (maxScroll <= 0) {
            return;
        }
        int idx = this.method_25396().indexOf((Object)entry);
        if (idx < 0) {
            return;
        }
        double desired = (double)idx * (double)this.field_22741;
        this.method_25307(desired);
    }

    @Nullable
    protected CheckboxEntry getEntryAtPosition(double mouseX, double mouseY) {
        CheckboxEntry entry;
        int i = this.method_25322() / 2;
        int j = this.field_19088 + this.field_22742 / 2;
        int k = j - i;
        int l = j + i;
        int m = class_3532.method_15357((double)(mouseY - (double)this.field_19085)) - this.field_22748 + (int)this.method_25341() - 4;
        int n = m / this.field_22741;
        CheckboxEntry checkboxEntry = entry = mouseX < (double)this.method_25329() && mouseX >= (double)k && mouseX <= (double)l && n >= 0 && m >= 0 && n < this.method_25340() ? (CheckboxEntry)((Object)this.method_25396().get(n)) : null;
        if (entry == null) {
            return null;
        }
        if (!entry.isCheckboxHovered(mouseX, mouseY)) {
            return null;
        }
        return entry;
    }

    protected void method_25318(double mouseX, double mouseY, int button) {
        super.method_25318(mouseX, mouseY, button);
        if (this.field_22750) {
            this.lastDragCall = System.currentTimeMillis();
        }
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.field_22750) {
            this.lastDragCall = System.currentTimeMillis();
        }
        return super.method_25403(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.field_22750 = false;
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    protected int method_25329() {
        return this.field_19088 + this.field_22742 - (this.scrollBarWidth + 2) - this.paddingCheckbox;
    }

    public int method_25322() {
        return this.field_22742 - this.scrollBarWidth - this.paddingLeft * 2;
    }

    public int method_25342() {
        return this.field_19088 + this.paddingLeft;
    }

    protected int method_25337(int index) {
        return this.field_19085 + this.paddingTop - (int)this.method_25341() + index * this.field_22741 + this.field_22748;
    }

    protected int method_25319(int index) {
        return super.method_25319(index) - this.paddingTop;
    }

    public void method_37020(@NotNull class_6382 narrationElementOutput) {
    }

    public void setSelected(@Nullable CheckboxEntry entry) {
        if (entry == null) {
            return;
        }
        entry.setSelected(!entry.selected);
    }

    public void setSelected(@NotNull String id) {
        CheckboxEntry entry = this.getEntry(id);
        if (entry == null) {
            return;
        }
        this.setSelected(entry);
    }

    public void playSelectedSound(class_1144 handler) {
        handler.method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
    }

    public WidgetInfoCheckboxList getWidgetInfo() {
        return this.widgetInfo;
    }

    @Environment(value=EnvType.CLIENT)
    public class CheckboxEntry
    extends class_350.class_351<CheckboxEntry> {
        private final String id;
        private final class_2561 label;
        private boolean selected;
        private GuiTexture checkboxTex;

        public CheckboxEntry(String id, class_2561 label, boolean selected) {
            this.checkboxTex = CheckboxList.this.widgetInfo.getTextureCheckbox();
            this.id = id;
            this.label = label;
            this.selected = selected;
        }

        public void method_25343(@NotNull class_332 guiGraphics, int index, int top, int left, int rowWidth, int rowHeight, int mouseX, int mouseY, boolean hovering, float fractionalTick) {
            if (this.selected) {
                this.checkboxTex = CheckboxList.this.widgetInfo.getTextureCheckboxHoveredSelected();
                if (!hovering || this.checkboxTex == null) {
                    this.checkboxTex = CheckboxList.this.widgetInfo.getTextureCheckboxSelected();
                }
            } else {
                this.checkboxTex = hovering ? CheckboxList.this.widgetInfo.getTextureCheckboxHovered() : CheckboxList.this.widgetInfo.getTextureCheckbox();
            }
            int iconX = CheckboxList.this.method_25342() + CheckboxList.this.paddingCheckbox;
            int iconY = top + (rowHeight - this.checkboxTex.getHeight()) / 2;
            this.checkboxTex.blit(guiGraphics, iconX, iconY, this.checkboxTex.getWidth(), this.checkboxTex.getHeight());
            class_327 font = ((CheckboxList)CheckboxList.this).field_22740.field_1772;
            String text = this.label.getString();
            int textX = iconX + this.checkboxTex.getWidth() + CheckboxList.this.paddingCheckbox;
            Objects.requireNonNull(font);
            int textY = top + (rowHeight - 9) / 2;
            Objects.requireNonNull(font);
            int textMaxHeight = rowHeight - (rowHeight - 9) / 2;
            int textMaxWidth = rowWidth - (textX - CheckboxList.this.method_25342()) - CheckboxList.this.paddingCheckbox;
            int color = CheckboxList.this.widgetInfo.getTextColor().toInt();
            CheckboxList.this.widgetInfo.getTextureEntry().blit(guiGraphics, textX, top, textMaxWidth, rowHeight);
            GuiHelper.renderScalableText(guiGraphics, font, text, color, textX + 4, textY, textMaxWidth - 8, textMaxHeight, true);
        }

        public void setSelected(boolean flag) {
            if (this.selected == flag) {
                return;
            }
            this.selected = flag;
            CheckboxList.this.rawEntriesState.put(this.id, this.selected);
            if (CheckboxList.this.onChanged != null) {
                CheckboxList.this.onChanged.accept(this);
            }
        }

        public boolean isCheckboxHovered(double mouseX, double mouseY) {
            int idx = CheckboxList.this.method_25396().indexOf((Object)this);
            if (idx < 0) {
                return false;
            }
            int rowTop = CheckboxList.this.method_25337(idx);
            int iconX = CheckboxList.this.method_25342() + CheckboxList.this.paddingCheckbox;
            int iconY = rowTop + (CheckboxList.this.field_22741 - this.checkboxTex.getHeight()) / 2;
            int iconW = this.checkboxTex.getWidth();
            int iconH = this.checkboxTex.getHeight();
            return mouseX >= (double)iconX && mouseX <= (double)(iconX + iconW) && mouseY >= (double)iconY && mouseY <= (double)(iconY + iconH);
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            if (button == 0) {
                CheckboxList.this.playSelectedSound(class_310.method_1551().method_1483());
                return true;
            }
            return false;
        }

        public String getId() {
            return this.id;
        }

        public boolean isSelected() {
            return this.selected;
        }
    }
}

