/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.api.client.gui.widgets.lists;

import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4264;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import net.minecraft.class_7919;
import org.jetbrains.annotations.NotNull;

public class DropDownListWidget
extends class_4264 {
    private final int ITEM_HEIGHT = 12;
    private int visibleItems = 5;
    private final List<class_2561> items;
    private boolean expanded = false;
    private int selectedIndex = -1;
    private int scrollOffset = 0;
    private boolean draggingScrollbar = false;
    private int dragStartY = 0;
    private int initialScrollOffset = 0;
    private long startTextScrolling = -1L;
    private long elementScrollingText = -1L;
    private final class_2561 defaultMessage;
    private final Consumer<Integer> responder;

    public DropDownListWidget(int x, int y, int width, int height, class_2561 message, List<class_2561> items, int startIndex, Consumer<Integer> responder) {
        super(x, y, width, height, message);
        this.defaultMessage = message;
        this.items = items;
        this.responder = responder;
        this.setSelectedIndex(startIndex, false);
    }

    public DropDownListWidget(int x, int y, int width, int height, class_2561 message, List<class_2561> items) {
        this(x, y, width, height, message, items, -1, null);
    }

    public void method_25306() {
        this.expanded = !this.expanded;
    }

    protected void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.method_48579(guiGraphics, mouseX, mouseY, partialTick);
        if (this.expanded) {
            int itemIndex;
            int dropdownX = this.method_46426();
            int dropdownY = this.method_46427() + this.method_25364();
            int dropdownHeight = this.visibleItems * 12;
            guiGraphics.method_25294(dropdownX, dropdownY, dropdownX + this.method_25368(), dropdownY + dropdownHeight, -16777216);
            class_310 mc = class_310.method_1551();
            class_327 font = mc.field_1772;
            int padding = 2;
            int availableWidth = this.items.size() > this.visibleItems ? this.method_25368() - 12 : this.method_25368() - 4;
            for (int i = 0; i < this.visibleItems && (itemIndex = i + this.scrollOffset) < this.items.size(); ++i) {
                boolean itemHovered;
                int itemY = dropdownY + i * 12;
                class_2561 itemText = this.items.get(itemIndex);
                String text = itemText.getString();
                boolean bl = itemHovered = mouseX >= dropdownX && mouseX < dropdownX + this.method_25368() && mouseY >= itemY && mouseY < itemY + 12;
                if (itemIndex == this.selectedIndex) {
                    int selectedBackgroundColor = -2144101889;
                    guiGraphics.method_25294(dropdownX, itemY, dropdownX + this.method_25368(), itemY + 12, selectedBackgroundColor);
                } else if (itemHovered) {
                    int hoveredBackgroundColor = -1070386381;
                    guiGraphics.method_25294(dropdownX, itemY, dropdownX + this.method_25368(), itemY + 12, hoveredBackgroundColor);
                }
                int textColor = itemIndex == this.selectedIndex ? -1 : -3355444;
                int textWidth = font.method_1727(text);
                if (textWidth > availableWidth) {
                    if (itemHovered) {
                        if (this.startTextScrolling == -1L || this.elementScrollingText != (long)i) {
                            this.elementScrollingText = i;
                            this.startTextScrolling = System.currentTimeMillis();
                        }
                        int msPerPixel = 50;
                        int holdTimeStart = 1000;
                        int holdTimeEnd = 1000;
                        int extra = textWidth - availableWidth;
                        int scrollTime = extra * msPerPixel;
                        int cycleTime = holdTimeStart + scrollTime + holdTimeEnd;
                        long timePassed = System.currentTimeMillis() - this.startTextScrolling;
                        long t = timePassed % (long)cycleTime;
                        int offset = t < (long)holdTimeStart ? 0 : (t < (long)(holdTimeStart + scrollTime) ? (int)((float)(t - (long)holdTimeStart) / (float)msPerPixel) : extra);
                        guiGraphics.method_44379(dropdownX + padding, itemY, dropdownX + padding + availableWidth, itemY + 12);
                        guiGraphics.method_25303(font, text, dropdownX + padding - offset, itemY + 2, textColor);
                        guiGraphics.method_44380();
                        continue;
                    }
                    if (this.elementScrollingText == (long)i) {
                        this.startTextScrolling = -1L;
                    }
                    String truncatedText = font.method_27523(text, availableWidth);
                    guiGraphics.method_25303(font, truncatedText, dropdownX + padding, itemY + 2, textColor);
                    continue;
                }
                guiGraphics.method_25300(font, text, dropdownX + this.method_25368() / 2, itemY + 2, textColor);
            }
            if (this.items.size() > this.visibleItems) {
                int scrollbarWidth = 8;
                int scrollbarX = dropdownX + this.method_25368() - scrollbarWidth;
                int scrollbarHeight = dropdownHeight;
                guiGraphics.method_25294(scrollbarX, dropdownY, scrollbarX + scrollbarWidth, dropdownY + scrollbarHeight, -12303292);
                int thumbHeight = Math.max(10, scrollbarHeight * this.visibleItems / this.items.size());
                int maxScroll = this.items.size() - this.visibleItems;
                int thumbY = dropdownY + (maxScroll == 0 ? 0 : this.scrollOffset * (scrollbarHeight - thumbHeight) / maxScroll);
                int thumbColor = this.draggingScrollbar ? -3355444 : -7829368;
                guiGraphics.method_25294(scrollbarX, thumbY, scrollbarX + scrollbarWidth, thumbY + thumbHeight, thumbColor);
            }
        }
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.draggingScrollbar) {
            int scrollbarHeight = this.visibleItems * 12;
            int thumbHeight = Math.max(10, scrollbarHeight * this.visibleItems / this.items.size());
            int maxScroll = this.items.size() - this.visibleItems;
            int availableTrack = scrollbarHeight - thumbHeight;
            int deltaY = (int)(mouseY - (double)this.dragStartY);
            int initialThumbPos = (int)((float)(this.initialScrollOffset * availableTrack) / (float)maxScroll);
            int newThumbPos = initialThumbPos + deltaY;
            int newScrollOffset = (int)((float)(newThumbPos * maxScroll) / (float)availableTrack);
            this.scrollOffset = class_3532.method_15340((int)newScrollOffset, (int)0, (int)maxScroll);
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (this.draggingScrollbar) {
            this.draggingScrollbar = false;
            return true;
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        boolean dropdownClicked;
        if (!this.field_22763 || !this.field_22764) {
            return false;
        }
        int dropdownX = this.method_46426();
        int dropdownY = this.method_46427() + this.method_25364();
        int dropdownWidth = this.method_25368();
        int dropdownHeight = this.visibleItems * 12;
        if (this.expanded && this.items.size() > this.visibleItems) {
            int scrollbarWidth = 8;
            int scrollbarX = dropdownX + this.method_25368() - scrollbarWidth - 2;
            int thumbHeight = Math.max(10, dropdownHeight * this.visibleItems / this.items.size());
            int maxScroll = this.items.size() - this.visibleItems;
            int thumbY = dropdownY + (maxScroll == 0 ? 0 : this.scrollOffset * (dropdownHeight - thumbHeight) / maxScroll);
            if (mouseX >= (double)scrollbarX && mouseX <= (double)(scrollbarX + scrollbarWidth) && mouseY >= (double)thumbY && mouseY <= (double)(thumbY + thumbHeight)) {
                this.draggingScrollbar = true;
                this.dragStartY = (int)mouseY;
                this.initialScrollOffset = this.scrollOffset;
                return true;
            }
        }
        boolean buttonClicked = this.method_25361(mouseX, mouseY);
        boolean bl = dropdownClicked = this.expanded && mouseX >= (double)dropdownX && mouseX <= (double)(dropdownX + dropdownWidth) && mouseY >= (double)dropdownY && mouseY <= (double)(dropdownY + dropdownHeight);
        if (buttonClicked) {
            this.method_25354(class_310.method_1551().method_1483());
            this.expanded = !this.expanded;
            return true;
        }
        if (dropdownClicked) {
            this.method_25354(class_310.method_1551().method_1483());
            int clickedIndex = (int)((mouseY - (double)dropdownY) / 12.0) + this.scrollOffset;
            if (clickedIndex < this.items.size()) {
                this.setSelectedIndex(clickedIndex, true);
            }
            this.expanded = false;
            return true;
        }
        if (this.expanded) {
            this.expanded = false;
        }
        return false;
    }

    public boolean method_25401(double mouseX, double mouseY, double scrollDelta) {
        if (this.expanded && this.items.size() > this.visibleItems) {
            this.scrollOffset = (int)class_3532.method_15350((double)((double)this.scrollOffset - scrollDelta), (double)0.0, (double)(this.items.size() - this.visibleItems));
            return true;
        }
        return false;
    }

    public void setSelectedIndex(int selectedIndex, boolean useResponder) {
        this.selectedIndex = selectedIndex;
        this.method_25355(this.getSelectedItem());
        if (selectedIndex >= 0) {
            this.method_47400(class_7919.method_47407((class_2561)this.defaultMessage));
            if (this.responder != null && useResponder) {
                this.responder.accept(selectedIndex);
            }
        } else {
            this.method_47400(null);
        }
    }

    public class_2561 getSelectedItem() {
        return this.selectedIndex >= 0 && this.selectedIndex < this.items.size() ? this.items.get(this.selectedIndex) : this.defaultMessage;
    }

    protected void method_47399(class_6382 narrationElementOutput) {
        narrationElementOutput.method_37034(class_6381.field_33788, (class_2561)class_2561.method_43469((String)"narration.dropdown.title", (Object[])new Object[]{this.method_25369()}));
    }

    public static Builder builder(@NotNull List<class_2561> items) {
        return new Builder(items);
    }

    public void setVisibleItems(int visibleItems) {
        this.visibleItems = visibleItems;
    }

    public List<class_2561> getItems() {
        return this.items;
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public boolean isDraggingScrollbar() {
        return this.draggingScrollbar;
    }

    public static class Builder {
        private int x = 0;
        private int y = 0;
        private int width = 50;
        private int height = 15;
        private List<class_2561> items;
        private int visibleItems = 5;
        private int startIndex = -1;
        private class_2561 message = class_2561.method_43470((String)"Select");
        private Consumer<Integer> responder = null;

        public Builder(@NotNull List<class_2561> items) {
            this.items = items;
        }

        public Builder pos(int x, int y) {
            this.x = x;
            this.y = y;
            return this;
        }

        public Builder size(int width, int height) {
            this.width = width;
            this.height = height;
            return this;
        }

        public DropDownListWidget build() {
            DropDownListWidget out = new DropDownListWidget(this.x, this.y, this.width, this.height, this.message, this.items, this.startIndex, this.responder);
            out.setVisibleItems(this.visibleItems);
            return out;
        }

        public Builder setVisibleItems(int visibleItems) {
            this.visibleItems = visibleItems;
            return this;
        }

        public Builder setStartIndex(int startIndex) {
            this.startIndex = startIndex;
            return this;
        }

        public Builder setMessage(class_2561 message) {
            this.message = message;
            return this;
        }

        public Builder setResponder(Consumer<Integer> responder) {
            this.responder = responder;
            return this;
        }
    }
}

