/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.api.client.gui.widgets.lists;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import me.phoenixra.visor.api.VisorAPI;
import me.phoenixra.visor.api.client.gui.GuiTexture;
import me.phoenixra.visor.api.client.gui.helpers.GuiHelper;
import me.phoenixra.visor.api.client.gui.overlays.framework.VROverlayScreen;
import me.phoenixra.visor.api.client.gui.widgets.info.WidgetInfoButtonImaged;
import me.phoenixra.visor.api.client.gui.widgets.info.WidgetInfoSelectionList;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1144;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import net.minecraft.class_350;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import net.minecraft.class_6382;
import net.minecraft.class_6880;
import net.minecraft.class_7919;
import net.minecraft.class_8001;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TexturedSelectionList
extends class_350<TexturedEntry> {
    private final WidgetInfoSelectionList widgetInfo;
    private final int paddingTop;
    private final int paddingLeft;
    private final int scrollBarWidth;
    private final Consumer<TexturedEntry> onSelected;
    private final Map<String, TexturedEntry> entriesMap = new HashMap<String, TexturedEntry>();
    private Map<String, String> rawEntries;
    private long lastDragCall = -1L;
    @Nullable
    private class_7919 tooltip;
    private int tooltipMsDelay = 0;
    private long hoverOrFocusedStartTime;
    private boolean wasHoveredOrFocused;
    @Nullable
    private String tooltipEntryIdForTimer;
    private class_437 visor$attachedTo;

    public TexturedSelectionList(@NotNull WidgetInfoSelectionList widgetInfo, @NotNull Map<String, String> rawEntries, @NotNull Consumer<TexturedEntry> onSelected) {
        super(class_310.method_1551(), widgetInfo.getWidth(), widgetInfo.getHeight(), widgetInfo.getY(), widgetInfo.getY() + widgetInfo.getHeight(), widgetInfo.getEntryHeight());
        this.widgetInfo = widgetInfo;
        this.paddingTop = widgetInfo.getPaddingTop();
        this.paddingLeft = widgetInfo.getPaddingLeft();
        this.scrollBarWidth = widgetInfo.getScrollBarWidth();
        this.onSelected = onSelected;
        this.method_25333(widgetInfo.getX());
        this.method_31323(false);
        this.method_31322(false);
        this.method_29344(false);
        this.resetEntries(rawEntries);
    }

    public void method_25394(@NotNull class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        TexturedEntry texturedEntry = this.field_33780 = this.method_25405(mouseX, mouseY) ? (TexturedEntry)this.method_25308(mouseX, mouseY) : null;
        if (this.field_22750 && this.lastDragCall + 200L < System.currentTimeMillis()) {
            this.field_22750 = false;
            this.lastDragCall = -1L;
        }
        this.method_49603(guiGraphics);
        this.method_25311(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.method_44380();
        int scrollX = this.method_25329();
        int maxScroll = this.method_25331();
        if (maxScroll > 0) {
            int trackTop = this.field_19085 + this.paddingTop;
            int trackBottom = this.field_19086 - this.paddingTop;
            int viewH = trackBottom - trackTop;
            int thumbH = (int)((float)viewH * (float)viewH / ((float)viewH + (float)maxScroll));
            thumbH = class_3532.method_15340((int)thumbH, (int)32, (int)(viewH - 8));
            int thumbY = trackTop + (int)(this.method_25341() * (double)(viewH - thumbH) / (double)maxScroll);
            GuiTexture scrollBarTex = this.field_22750 ? this.widgetInfo.getTextureScrollBarActive() : this.widgetInfo.getTextureScrollBar();
            scrollBarTex.blit(guiGraphics, scrollX, thumbY, this.scrollBarWidth, thumbH);
        }
        this.updateTooltip();
        RenderSystem.disableBlend();
    }

    protected void method_25311(@NotNull class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        int i = this.method_25342();
        int j = this.method_25322();
        int k = this.field_22741 - this.paddingTop;
        int l = this.method_25340();
        for (int m = 0; m < l; ++m) {
            int n = this.method_25337(m);
            int o = this.method_25319(m);
            if (o < this.field_19085 || n > this.field_19086) continue;
            this.method_44397(guiGraphics, mouseX, mouseY, partialTick, m, i, n, j, k);
        }
    }

    private void updateTooltip() {
        boolean stateChanged;
        Function<String, class_2561> factory = this.widgetInfo.getTooltip();
        if (factory == null) {
            return;
        }
        TexturedEntry entryForTooltip = (TexturedEntry)this.field_33780;
        boolean hasTarget = entryForTooltip != null;
        String newId = hasTarget ? entryForTooltip.getId() : null;
        boolean bl = stateChanged = hasTarget != this.wasHoveredOrFocused || !Objects.equals(this.tooltipEntryIdForTimer, newId);
        if (stateChanged) {
            if (hasTarget) {
                this.hoverOrFocusedStartTime = class_156.method_658();
            }
            this.wasHoveredOrFocused = hasTarget;
            this.tooltipEntryIdForTimer = newId;
        }
        if (!hasTarget) {
            return;
        }
        if (class_156.method_658() - this.hoverOrFocusedStartTime <= (long)this.tooltipMsDelay) {
            return;
        }
        class_2561 tipText = factory.apply(newId);
        if (tipText == null) {
            return;
        }
        this.tooltip = class_7919.method_47407((class_2561)tipText);
        class_437 screen = this.getAttachedTo();
        if (screen != null) {
            screen.method_47412(this.tooltip, class_8001.field_41687, false);
        }
    }

    private class_437 getAttachedTo() {
        if (this.visor$attachedTo == null) {
            if (VisorAPI.clientState().stateMode().isNotActive()) {
                this.visor$attachedTo = class_310.method_1551().field_1755;
                return this.visor$attachedTo;
            }
            VROverlayScreen overlay = VisorAPI.client().getGuiManager().getCursorHandler().getFocusedOverlayScreen();
            this.visor$attachedTo = overlay != null ? overlay : class_310.method_1551().field_1755;
            return this.visor$attachedTo;
        }
        return this.visor$attachedTo;
    }

    public void filterEntries(@NotNull Function<Map.Entry<String, String>, Boolean> filter) {
        this.method_25339();
        this.entriesMap.clear();
        this.method_25307(0.0);
        for (Map.Entry<String, String> entry : this.rawEntries.entrySet()) {
            if (!filter.apply(entry).booleanValue()) continue;
            TexturedEntry texturedEntry = new TexturedEntry(entry.getKey(), (class_2561)class_2561.method_43470((String)entry.getValue()));
            this.method_25321(texturedEntry);
            this.entriesMap.put(texturedEntry.id, texturedEntry);
        }
    }

    public void resetEntries(@NotNull Map<String, String> rawEntries) {
        this.method_25339();
        this.entriesMap.clear();
        this.method_25307(0.0);
        for (Map.Entry<String, String> entry : rawEntries.entrySet()) {
            TexturedEntry texturedEntry = new TexturedEntry(entry.getKey(), (class_2561)class_2561.method_43470((String)entry.getValue()));
            this.method_25321(texturedEntry);
            this.entriesMap.put(texturedEntry.id, texturedEntry);
        }
        this.rawEntries = rawEntries;
    }

    public void renameEntry(String id, class_2561 newLabel) {
        TexturedEntry entry;
        if (this.rawEntries != null && this.rawEntries.containsKey(id)) {
            this.rawEntries.put(id, newLabel.getString());
        }
        if ((entry = this.entriesMap.get(id)) == null) {
            return;
        }
        entry.label = newLabel;
    }

    @Nullable
    public TexturedEntry getEntry(@NotNull String id) {
        return this.entriesMap.get(id);
    }

    public void scrollTo(@NotNull TexturedEntry entry) {
        int maxScroll = this.method_25331();
        if (maxScroll <= 0) {
            return;
        }
        int idx = this.method_25396().indexOf((Object)entry);
        if (idx < 0) {
            return;
        }
        double desired = (double)idx * (double)this.field_22741;
        this.method_25307(desired);
    }

    protected void method_25318(double mouseX, double mouseY, int button) {
        super.method_25318(mouseX, mouseY, button);
        if (this.field_22750) {
            this.lastDragCall = System.currentTimeMillis();
        }
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.field_22750) {
            this.lastDragCall = System.currentTimeMillis();
        }
        return super.method_25403(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.field_22750 = false;
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    protected int method_25329() {
        return this.field_19088 + this.field_22742 - (this.scrollBarWidth + 2);
    }

    public int method_25322() {
        return this.field_22742 - this.scrollBarWidth - this.paddingLeft * 2;
    }

    public int method_25342() {
        return this.field_19088 + this.paddingLeft;
    }

    protected int method_25337(int index) {
        return this.field_19085 + this.paddingTop - (int)this.method_25341() + index * this.field_22741 + this.field_22748;
    }

    protected int method_25319(int index) {
        return super.method_25319(index) - this.paddingTop;
    }

    public void method_37020(@NotNull class_6382 narrationElementOutput) {
    }

    public void setSelected(@Nullable TexturedEntry selected) {
        if (selected != this.method_25334()) {
            this.onSelected.accept(selected);
        } else if (this.widgetInfo.isSupportDeselection() && selected != null) {
            this.playSelectedSound(class_310.method_1551().method_1483());
            this.onSelected.accept(null);
            super.method_25313(null);
            return;
        }
        super.method_25313((class_350.class_351)selected);
    }

    public void setSelected(@NotNull String id) {
        TexturedEntry entry = this.getEntry(id);
        if (entry == null) {
            return;
        }
        this.setSelected(entry);
    }

    public void playSelectedSound(class_1144 handler) {
        handler.method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
    }

    public WidgetInfoSelectionList getWidgetInfo() {
        return this.widgetInfo;
    }

    @Environment(value=EnvType.CLIENT)
    public class TexturedEntry
    extends class_350.class_351<TexturedEntry> {
        private final String id;
        private class_2561 label;

        public TexturedEntry(String id, class_2561 label) {
            this.id = id;
            this.label = label;
        }

        public void method_49568(@NotNull class_332 guiGraphics, int index, int top, int left, int rowWidth, int rowHeight, int mouseX, int mouseY, boolean hovering, float fractionalTick) {
            GuiTexture texture;
            WidgetInfoButtonImaged entryInfo = TexturedSelectionList.this.widgetInfo.getEntryButton();
            entryInfo.pos(TexturedSelectionList.this.method_25342(), top).size(TexturedSelectionList.this.method_25322(), rowHeight);
            boolean selected = Objects.equals(TexturedSelectionList.this.method_25334(), (Object)this);
            if (selected) {
                texture = entryInfo.getTextureHoveredSelected();
                if (!hovering || texture == null) {
                    texture = entryInfo.getTextureSelected();
                }
            } else {
                texture = hovering ? entryInfo.getTextureHovered() : entryInfo.getTexture();
            }
            if (texture == null) {
                texture = entryInfo.getTexture();
            }
            texture.blit(guiGraphics, TexturedSelectionList.this.method_25342(), top, TexturedSelectionList.this.method_25322(), rowHeight);
            entryInfo.drawHighlight(guiGraphics, true, hovering, selected);
        }

        public void method_25343(@NotNull class_332 guiGraphics, int index, int top, int left, int rowWidth, int rowHeight, int mouseX, int mouseY, boolean hovering, float fractionalTick) {
            class_327 font = ((TexturedSelectionList)TexturedSelectionList.this).field_22740.field_1772;
            String text = this.label.getString();
            int startX = TexturedSelectionList.this.method_25342() + 4;
            int textWidth = TexturedSelectionList.this.method_25322() - 8;
            int color = TexturedSelectionList.this.widgetInfo.getTextColor().toInt();
            GuiHelper.renderScalableText(guiGraphics, font, text, color, startX, top, textWidth, rowHeight, true);
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            if (button == 0) {
                if (this != TexturedSelectionList.this.method_25334()) {
                    TexturedSelectionList.this.playSelectedSound(class_310.method_1551().method_1483());
                }
                return true;
            }
            return false;
        }

        public String getId() {
            return this.id;
        }
    }
}

