/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.api.client.gui.widgets.sets;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import me.phoenixra.visor.api.client.gui.widgets.EditBoxImage;
import me.phoenixra.visor.api.client.gui.widgets.ValueDragWidget;
import me.phoenixra.visor.api.client.gui.widgets.info.WidgetInfoEditBox;
import me.phoenixra.visor.api.client.gui.widgets.info.WidgetInfoValueDrag;
import me.phoenixra.visor.api.client.gui.widgets.sets.WidgetSet;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import org.jetbrains.annotations.NotNull;

public class ValueEditorInt
implements WidgetSet {
    private int x;
    private int y;
    private int width;
    private int height;
    private WidgetInfoEditBox editBoxInfo;
    private WidgetInfoValueDrag leftArrowInfo;
    private WidgetInfoValueDrag rightArrowInfo;
    private EditBoxImage editBox;
    private ValueDragWidget leftArrow;
    private ValueDragWidget rightArrow;
    private int value;
    private int minValue;
    private int maxValue;
    private Consumer<Integer> responder;

    private ValueEditorInt(@NotNull Builder builder) {
        this.x = builder.x;
        this.y = builder.y;
        this.width = builder.width;
        this.height = builder.height;
        this.editBoxInfo = builder.widgetInfoEditBox;
        this.leftArrowInfo = builder.widgetInfoLeftArrow;
        this.rightArrowInfo = builder.widgetInfoRightArrow;
        this.leftArrowInfo.pos(this.x, this.y).size(this.height, this.height).setDirection(WidgetInfoValueDrag.Direction.LEFT).setAdapter(WidgetInfoValueDrag.NumericAdapter.of(() -> this.value, v -> this.setValue((int)v, true)));
        this.editBoxInfo.pos(this.x + this.height + builder.gap, this.y).size(this.width - (this.height + builder.gap) * 2, this.height);
        this.rightArrowInfo.pos(this.editBoxInfo.getX() + this.editBoxInfo.getWidth() + builder.gap, this.y).size(this.height, this.height).setDirection(WidgetInfoValueDrag.Direction.RIGHT).setAdapter(WidgetInfoValueDrag.NumericAdapter.of(() -> this.value, v -> this.setValue((int)v, true)));
        this.value = builder.initialValue;
        this.minValue = builder.minValue;
        this.maxValue = builder.maxValue;
        this.responder = builder.responder;
    }

    public void setValue(int value, boolean updateEditBox) {
        this.value = class_3532.method_15340((int)value, (int)this.minValue, (int)this.maxValue);
        if (updateEditBox && this.editBox != null) {
            this.editBox.method_1852(Integer.toString(this.value));
        }
        if (this.responder != null) {
            this.responder.accept(this.value);
        }
    }

    @Override
    public <T extends class_364 & class_4068> List<T> initWidgets() {
        this.editBox = new EditBoxImage(this.editBoxInfo);
        this.editBox.method_1852(Integer.toString(this.getValue()));
        this.editBox.method_1890(s -> {
            if (s.isEmpty() || s.equals("-")) {
                return true;
            }
            try {
                int v = Integer.parseInt(s);
                return v >= this.minValue && v <= this.maxValue;
            }
            catch (NumberFormatException e) {
                return false;
            }
        });
        this.editBox.method_1863(s -> {
            if (s.isEmpty() || s.equals("-")) {
                return;
            }
            try {
                this.setValue(Integer.parseInt(s), false);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        });
        int maxDigits = Math.max(Integer.toString(Math.abs(this.minValue)).length(), Integer.toString(Math.abs(this.maxValue)).length()) + (this.minValue < 0 ? 1 : 0);
        this.editBox.method_1880(maxDigits);
        this.editBox.method_1870();
        this.leftArrow = new ValueDragWidget(this.leftArrowInfo);
        this.rightArrow = new ValueDragWidget(this.rightArrowInfo);
        return this.getWidgets();
    }

    @Override
    public <T extends class_364 & class_4068> List<T> getWidgets() {
        ArrayList<Object> widgets = new ArrayList<Object>();
        widgets.add((Object)this.editBox);
        widgets.add((Object)this.leftArrow);
        widgets.add((Object)this.rightArrow);
        return widgets;
    }

    @Override
    public void onPreRender(@NotNull class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
    }

    @Override
    public void onTick() {
        this.editBox.method_1865();
    }

    public EditBoxImage getEditBox() {
        return this.editBox;
    }

    public ValueDragWidget getLeftArrow() {
        return this.leftArrow;
    }

    public ValueDragWidget getRightArrow() {
        return this.rightArrow;
    }

    public int getValue() {
        return this.value;
    }

    public static class Builder {
        private int x;
        private int y;
        private int width;
        private int height;
        private int gap = 2;
        private WidgetInfoEditBox widgetInfoEditBox;
        private WidgetInfoValueDrag widgetInfoLeftArrow;
        private WidgetInfoValueDrag widgetInfoRightArrow;
        private int initialValue;
        private int minValue = Integer.MIN_VALUE;
        private int maxValue = Integer.MAX_VALUE;
        private Consumer<Integer> responder;

        public Builder(int initialValue, int x, int y, int width, int height) {
            this.initialValue = initialValue;
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
        }

        public Builder range(int min, int max) {
            this.minValue = min;
            this.maxValue = max;
            return this;
        }

        public Builder editBox(WidgetInfoEditBox widgetInfo) {
            this.widgetInfoEditBox = widgetInfo;
            return this;
        }

        public Builder leftArrow(WidgetInfoValueDrag widgetInfo) {
            this.widgetInfoLeftArrow = widgetInfo;
            return this;
        }

        public Builder rightArrow(WidgetInfoValueDrag widgetInfo) {
            this.widgetInfoRightArrow = widgetInfo;
            return this;
        }

        public ValueEditorInt build() {
            return new ValueEditorInt(this);
        }

        public Builder setGap(int gap) {
            this.gap = gap;
            return this;
        }

        public Builder setResponder(Consumer<Integer> responder) {
            this.responder = responder;
            return this;
        }
    }
}

