/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.api.client.gui.widgets.sets;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import me.phoenixra.visor.api.client.gui.GuiTexture;
import me.phoenixra.visor.api.client.gui.overlays.options.OptionTextures;
import me.phoenixra.visor.api.client.gui.widgets.sets.DynamicWidgetSet;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import org.jetbrains.annotations.NotNull;

public class WidgetsList
extends DynamicWidgetSet {
    private final int x;
    private final int y;
    private final int width;
    private final int height;
    private final int scrollBarWidth;
    private final int columns;
    private final int columnGap;
    private final int rowGap;
    private final int entryHeight;
    private final GuiTexture textureScrollBar;
    private final GuiTexture textureScrollBarActive;
    private final List<class_339> widgets;
    private Scrollbar scrollbar;
    private double scrollAmount = 0.0;
    private int maxScroll = 0;

    public WidgetsList(@NotNull Builder builder) {
        super(builder.onWidgetsChanged);
        this.x = builder.x;
        this.y = builder.y;
        this.width = builder.width;
        this.height = builder.height;
        this.scrollBarWidth = builder.scrollBarWidth;
        this.columns = Math.max(1, builder.columns);
        this.columnGap = Math.max(0, builder.columnGap);
        this.rowGap = Math.max(0, builder.rowGap);
        this.entryHeight = Math.max(1, builder.entryHeight);
        this.textureScrollBar = builder.textureScrollBar;
        this.textureScrollBarActive = builder.textureScrollBarActive;
        this.widgets = new ArrayList<class_339>(builder.widgets);
    }

    @Override
    public <T extends class_364 & class_4068> List<T> initWidgets() {
        this.recalcMaxScroll();
        this.layoutChildren();
        this.scrollbar = new Scrollbar();
        ArrayList<class_339> out = new ArrayList<class_339>(this.widgets.size() + 1);
        for (class_339 w : this.widgets) {
            out.add(w);
        }
        out.add(this.scrollbar);
        return out;
    }

    @Override
    public <T extends class_364 & class_4068> List<T> getWidgets() {
        this.layoutChildren();
        this.scrollbar.updateBounds();
        ArrayList<class_339> out = new ArrayList<class_339>(this.widgets.size() + 1);
        for (class_339 w : this.widgets) {
            out.add(w);
        }
        out.add(this.scrollbar);
        return out;
    }

    @Override
    public void onTick() {
        for (class_339 widget : this.widgets) {
            if (!(widget instanceof class_342)) continue;
            class_342 editBox = (class_342)widget;
            editBox.method_1865();
        }
    }

    @Override
    public void onPreRender(@NotNull class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
        guiGraphics.method_44379(this.contentLeft(), this.contentTop(), this.x + this.width, this.y + this.height);
    }

    @Override
    public void onPostRender(@NotNull class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
        guiGraphics.method_44380();
    }

    private int contentLeft() {
        return this.x;
    }

    private int contentTop() {
        return this.y;
    }

    private int rowWidth() {
        return Math.max(0, this.width - (this.scrollBarWidth + 4));
    }

    private int viewTop() {
        return this.y;
    }

    private int viewBottom() {
        return this.y + this.height;
    }

    private void recalcMaxScroll() {
        int rows = (int)Math.ceil((double)this.widgets.size() / (double)this.columns);
        int totalRowGaps = Math.max(0, rows - 1) * this.rowGap;
        int contentHeight = rows * this.entryHeight + totalRowGaps;
        this.maxScroll = Math.max(0, contentHeight - this.height);
        this.scrollAmount = class_3532.method_15350((double)this.scrollAmount, (double)0.0, (double)this.maxScroll);
    }

    private void layoutChildren() {
        if (this.widgets.isEmpty()) {
            return;
        }
        int totalGaps = Math.max(0, this.columns - 1) * this.columnGap;
        int avail = Math.max(0, this.rowWidth() - totalGaps);
        int baseCell = this.columns > 0 ? Math.max(0, avail / this.columns) : 0;
        int remainder = this.columns > 0 ? Math.max(0, avail - baseCell * this.columns) : 0;
        int[] colWidths = new int[this.columns];
        for (int c = 0; c < this.columns; ++c) {
            colWidths[c] = baseCell + (c == this.columns - 1 ? remainder : 0);
        }
        int[] colX = new int[this.columns];
        int curX = this.contentLeft();
        for (int c = 0; c < this.columns; ++c) {
            colX[c] = curX;
            curX += colWidths[c];
            if (c >= this.columns - 1) continue;
            curX += this.columnGap;
        }
        int viewportTop = this.viewTop();
        int viewportBottom = this.viewBottom();
        for (int i = 0; i < this.widgets.size(); ++i) {
            boolean intersects;
            class_339 w = this.widgets.get(i);
            int row = i / this.columns;
            int col = i % this.columns;
            int cellX = colX[col];
            int cellY = this.contentTop() + row * (this.entryHeight + this.rowGap) - (int)this.scrollAmount;
            int cellW = colWidths[col];
            int cellH = this.entryHeight;
            if (this.maxScroll == 0) {
                int minY = this.contentTop();
                int maxY = this.contentTop() + Math.max(0, this.height - cellH);
                cellY = class_3532.method_15340((int)cellY, (int)minY, (int)maxY);
            }
            w.method_46421(cellX);
            w.method_46419(cellY);
            w.method_25358(cellW);
            w.field_22759 = cellH;
            w.field_22764 = intersects = cellY + cellH > viewportTop && cellY < viewportBottom;
            w.field_22763 = intersects;
            if (intersects) continue;
            w.method_25365(false);
        }
    }

    private void applyScroll(double newAmount) {
        double clamped = class_3532.method_15350((double)newAmount, (double)0.0, (double)this.maxScroll);
        if (clamped != this.scrollAmount) {
            this.scrollAmount = clamped;
            this.layoutChildren();
            this.scrollbar.updateBounds();
        }
    }

    @Override
    public boolean mouseScrolled(double mouseX, double mouseY, double delta) {
        if (this.scrollbar.method_25401(mouseX, mouseY, delta)) {
            return true;
        }
        if (mouseX >= (double)this.x && mouseX < (double)(this.x + this.width) && mouseY >= (double)this.y && mouseY < (double)(this.y + this.height)) {
            double step = (double)(this.entryHeight + this.rowGap) * 0.75;
            this.applyScroll(this.scrollAmount - delta * step);
            return true;
        }
        return false;
    }

    private int getScrollbarX() {
        return this.x + this.width - (this.scrollBarWidth + 2);
    }

    private int getScrollbarY() {
        return this.y;
    }

    private int getScrollbarWidth() {
        return this.scrollBarWidth;
    }

    private int getScrollbarHeight() {
        return this.height;
    }

    public static class Builder {
        private final Collection<class_339> widgets;
        @NotNull
        Runnable onWidgetsChanged;
        private int x;
        private int y;
        private int width;
        private int height;
        private GuiTexture textureScrollBar = OptionTextures.SCROLL_BAR;
        private GuiTexture textureScrollBarActive = OptionTextures.SCROLL_BAR_ACTIVE;
        private int scrollBarWidth = 4;
        private int entryHeight = 15;
        private int columns = 1;
        private int columnGap = 4;
        private int rowGap = 4;

        public Builder(@NotNull Runnable onWidgetsChanged, @NotNull Collection<class_339> widgets) {
            this.onWidgetsChanged = onWidgetsChanged;
            this.widgets = widgets;
        }

        public Builder pos(int x, int y) {
            this.x = x;
            this.y = y;
            return this;
        }

        public Builder size(int width, int height) {
            this.width = width;
            this.height = height;
            return this;
        }

        public WidgetsList build() {
            if (this.width <= 0 || this.height <= 0) {
                throw new IllegalStateException("WidgetsList: size(width,height) must be set and > 0");
            }
            return new WidgetsList(this);
        }

        public Builder setTextureScrollBar(GuiTexture textureScrollBar) {
            this.textureScrollBar = textureScrollBar;
            return this;
        }

        public Builder setTextureScrollBarActive(GuiTexture textureScrollBarActive) {
            this.textureScrollBarActive = textureScrollBarActive;
            return this;
        }

        public Builder setScrollBarWidth(int scrollBarWidth) {
            this.scrollBarWidth = scrollBarWidth;
            return this;
        }

        public Builder setEntryHeight(int entryHeight) {
            this.entryHeight = entryHeight;
            return this;
        }

        public Builder setColumns(int columns) {
            this.columns = columns;
            return this;
        }

        public Builder setColumnGap(int columnGap) {
            this.columnGap = columnGap;
            return this;
        }

        public Builder setRowGap(int rowGap) {
            this.rowGap = rowGap;
            return this;
        }
    }

    private class Scrollbar
    extends class_339 {
        private boolean dragging;

        public Scrollbar() {
            super(0, 0, 0, 0, (class_2561)class_2561.method_43473());
            this.dragging = false;
            this.updateBounds();
        }

        void updateBounds() {
            this.method_46421(WidgetsList.this.getScrollbarX());
            this.method_46419(WidgetsList.this.getScrollbarY());
            this.method_25358(WidgetsList.this.getScrollbarWidth());
            this.field_22759 = WidgetsList.this.getScrollbarHeight();
            this.field_22763 = this.field_22764 = WidgetsList.this.maxScroll > 0;
        }

        private int viewH() {
            int trackTop = WidgetsList.this.y;
            int trackBottom = WidgetsList.this.y + this.field_22759;
            return Math.max(0, trackBottom - trackTop);
        }

        private int thumbHeight() {
            int vh = this.viewH();
            if (vh <= 0 || WidgetsList.this.maxScroll <= 0) {
                return 0;
            }
            int th = (int)((float)vh * (float)vh / ((float)vh + (float)WidgetsList.this.maxScroll));
            return class_3532.method_15340((int)th, (int)32, (int)Math.max(0, vh - 8));
        }

        private int thumbY() {
            int trackTop = WidgetsList.this.y;
            int vh = this.viewH();
            int th = this.thumbHeight();
            if (vh <= 0 || WidgetsList.this.maxScroll <= 0 || th <= 0) {
                return trackTop;
            }
            int available = Math.max(0, vh - th);
            return trackTop + (int)(WidgetsList.this.scrollAmount * ((double)available / (double)WidgetsList.this.maxScroll));
        }

        protected void method_48579(class_332 gg, int mx, int my, float pt) {
            GuiTexture bar;
            if (!this.field_22764) {
                return;
            }
            int ty = this.thumbY();
            int th = this.thumbHeight();
            GuiTexture guiTexture = bar = this.dragging ? WidgetsList.this.textureScrollBarActive : WidgetsList.this.textureScrollBar;
            if (bar != null && th > 0) {
                bar.blit(gg, this.method_46426(), ty, this.method_25368(), th);
            }
        }

        public void method_25348(double mouseX, double mouseY) {
            if (WidgetsList.this.maxScroll <= 0) {
                return;
            }
            int ty = this.thumbY();
            int th = this.thumbHeight();
            if (mouseY >= (double)ty && mouseY < (double)(ty + th)) {
                this.dragging = true;
            } else {
                int rowStep = WidgetsList.this.entryHeight + WidgetsList.this.rowGap;
                double page = Math.max(rowStep, this.field_22759 - rowStep);
                if (mouseY < (double)ty) {
                    WidgetsList.this.applyScroll(WidgetsList.this.scrollAmount - page);
                } else {
                    WidgetsList.this.applyScroll(WidgetsList.this.scrollAmount + page);
                }
            }
        }

        public void method_25357(double mouseX, double mouseY) {
            this.dragging = false;
        }

        protected void method_25349(double mouseX, double mouseY, double dragX, double dragY) {
            if (!this.dragging || WidgetsList.this.maxScroll <= 0) {
                return;
            }
            int vh = this.viewH();
            int th = this.thumbHeight();
            if (vh <= 0 || th <= 0) {
                return;
            }
            int trackTop = WidgetsList.this.y;
            int available = Math.max(0, vh - th);
            int offsetFromTop = (int)class_3532.method_15350((double)(mouseY - (double)trackTop - (double)th / 2.0), (double)0.0, (double)available);
            double ratio = available == 0 ? 0.0 : (double)offsetFromTop / (double)available;
            WidgetsList.this.applyScroll(ratio * (double)WidgetsList.this.maxScroll);
        }

        public boolean method_25401(double mouseX, double mouseY, double delta) {
            if (!this.field_22764) {
                return false;
            }
            if (mouseX >= (double)this.method_46426() && mouseX < (double)(this.method_46426() + this.method_25368()) && mouseY >= (double)this.method_46427() && mouseY < (double)(this.method_46427() + this.field_22759) && WidgetsList.this.maxScroll > 0) {
                double step = (double)(WidgetsList.this.entryHeight + WidgetsList.this.rowGap) * 0.75;
                WidgetsList.this.applyScroll(WidgetsList.this.scrollAmount - delta * step);
                return true;
            }
            return false;
        }

        protected void method_47399(class_6382 out) {
            if (this.field_22764 && WidgetsList.this.maxScroll > 0) {
                out.method_37034(class_6381.field_33788, (class_2561)class_2561.method_43471((String)"narration.scrollbar"));
                out.method_37034(class_6381.field_33789, (class_2561)class_2561.method_43469((String)"narrator.position.list", (Object[])new Object[]{(int)WidgetsList.this.scrollAmount, WidgetsList.this.maxScroll}));
            }
        }
    }
}

