/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.api.client.input;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import me.phoenixra.visor.api.VisorAPI;
import me.phoenixra.visor.api.client.gui.VRKeyboardAccessor;
import net.minecraft.class_310;
import net.minecraft.class_312;
import net.minecraft.class_437;

public class InputHelper {
    private static final Set<Integer> pressedKeys = new HashSet<Integer>();
    private static final HashMap<Character, Integer> keyCodes = new HashMap();

    public static void pressMouse(int button, int modifiers) {
        class_310.method_1551().field_1729.method_1601(class_310.method_1551().method_22683().method_4490(), button, 1, modifiers);
    }

    public static void pressMouse(int button) {
        InputHelper.pressMouse(button, 0);
    }

    public static void releaseMouse(int button, int modifiers) {
        class_310.method_1551().field_1729.method_1601(class_310.method_1551().method_22683().method_4490(), button, 0, modifiers);
    }

    public static void releaseMouse(int button) {
        InputHelper.releaseMouse(button, 0);
    }

    public static boolean isMousePressed(int button) {
        class_312 mouseHandler = class_310.method_1551().field_1729;
        switch (button) {
            case 0: {
                return mouseHandler.method_1608();
            }
            case 1: {
                return mouseHandler.method_1609();
            }
            case 2: {
                return mouseHandler.method_35707();
            }
        }
        return false;
    }

    public static void setMousePos(double x, double y) {
        class_310.method_1551().field_1729.method_1600(class_310.method_1551().method_22683().method_4490(), x, y);
    }

    public static void scrollMouse(double xOffset, double yOffset) {
        class_310.method_1551().field_1729.method_1598(class_310.method_1551().method_22683().method_4490(), xOffset, yOffset);
    }

    public static void pressKey(int key, int modifiers) {
        pressedKeys.add(key);
        class_310.method_1551().field_1774.method_1466(class_310.method_1551().method_22683().method_4490(), key, 0, 1, modifiers);
    }

    public static void pressKey(int key) {
        InputHelper.pressKey(key, 0);
    }

    public static void releaseKey(int key, int modifiers) {
        pressedKeys.remove(key);
        class_310.method_1551().field_1774.method_1466(class_310.method_1551().method_22683().method_4490(), key, 0, 0, modifiers);
    }

    public static void releaseKey(int key) {
        InputHelper.releaseKey(key, 0);
    }

    public static boolean isKeyDown(int key) {
        return pressedKeys.contains(key);
    }

    public static void typeChar(char character, int modifiers) {
        int keyCode;
        VRKeyboardAccessor keyboardAccessor = VisorAPI.client().getGuiManager().getOverlayManager().getKeyboardAccessor();
        class_437 screen = keyboardAccessor.getAttachedTo();
        if (screen != null) {
            screen.method_25400(character, modifiers);
            return;
        }
        class_310 mc = class_310.method_1551();
        if (mc.field_1755 != null) {
            class_310.method_1551().field_1774.method_1457(class_310.method_1551().method_22683().method_4490(), (int)character, modifiers);
        }
        if ((keyCode = keyCodes.getOrDefault(Character.valueOf(Character.toUpperCase(character)), -1).intValue()) == -1) {
            return;
        }
        InputHelper.pressKey(keyCode);
        InputHelper.releaseKey(keyCode);
    }

    public static void typeChar(char character) {
        InputHelper.typeChar(character, 0);
    }

    public static void typeChars(CharSequence characters) {
        int i = characters.length();
        for (int j = 0; j < i; ++j) {
            char character = characters.charAt(j);
            InputHelper.typeChar(character);
        }
    }

    static {
        keyCodes.put(Character.valueOf('`'), 96);
        keyCodes.put(Character.valueOf('1'), 49);
        keyCodes.put(Character.valueOf('2'), 50);
        keyCodes.put(Character.valueOf('3'), 51);
        keyCodes.put(Character.valueOf('4'), 52);
        keyCodes.put(Character.valueOf('5'), 53);
        keyCodes.put(Character.valueOf('6'), 54);
        keyCodes.put(Character.valueOf('7'), 55);
        keyCodes.put(Character.valueOf('8'), 56);
        keyCodes.put(Character.valueOf('9'), 57);
        keyCodes.put(Character.valueOf('0'), 48);
        keyCodes.put(Character.valueOf('-'), 45);
        keyCodes.put(Character.valueOf('='), 61);
        keyCodes.put(Character.valueOf('Q'), 81);
        keyCodes.put(Character.valueOf('W'), 87);
        keyCodes.put(Character.valueOf('E'), 69);
        keyCodes.put(Character.valueOf('R'), 82);
        keyCodes.put(Character.valueOf('T'), 84);
        keyCodes.put(Character.valueOf('Y'), 89);
        keyCodes.put(Character.valueOf('U'), 85);
        keyCodes.put(Character.valueOf('I'), 73);
        keyCodes.put(Character.valueOf('O'), 79);
        keyCodes.put(Character.valueOf('P'), 80);
        keyCodes.put(Character.valueOf('['), 91);
        keyCodes.put(Character.valueOf(']'), 93);
        keyCodes.put(Character.valueOf('\\'), 92);
        keyCodes.put(Character.valueOf('A'), 65);
        keyCodes.put(Character.valueOf('S'), 83);
        keyCodes.put(Character.valueOf('D'), 68);
        keyCodes.put(Character.valueOf('F'), 70);
        keyCodes.put(Character.valueOf('G'), 71);
        keyCodes.put(Character.valueOf('H'), 72);
        keyCodes.put(Character.valueOf('J'), 74);
        keyCodes.put(Character.valueOf('K'), 75);
        keyCodes.put(Character.valueOf('L'), 76);
        keyCodes.put(Character.valueOf(';'), 59);
        keyCodes.put(Character.valueOf('\''), 39);
        keyCodes.put(Character.valueOf('Z'), 90);
        keyCodes.put(Character.valueOf('X'), 88);
        keyCodes.put(Character.valueOf('C'), 67);
        keyCodes.put(Character.valueOf('V'), 86);
        keyCodes.put(Character.valueOf('B'), 66);
        keyCodes.put(Character.valueOf('N'), 78);
        keyCodes.put(Character.valueOf('M'), 77);
        keyCodes.put(Character.valueOf(','), 44);
        keyCodes.put(Character.valueOf('.'), 46);
        keyCodes.put(Character.valueOf('/'), 47);
    }
}

