/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.api.client.input.action.framework;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Map;
import me.phoenixra.atumvr.api.input.action.VRActionDataButton;
import me.phoenixra.atumvr.core.enums.XRInteractionProfile;
import me.phoenixra.atumvr.core.input.action.profileset.OpenXRProfileSet;
import me.phoenixra.visor.api.VisorAPI;
import me.phoenixra.visor.api.client.input.action.BindingPath;
import me.phoenixra.visor.api.client.input.action.VisorAction;
import me.phoenixra.visor.api.client.input.action.VisorActionSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class VisorActionButton
implements VisorAction {
    private final VisorActionSet actionSet;
    private final String id;
    protected boolean active;
    protected boolean changed;
    protected boolean pressed = false;
    protected boolean pressDelayed;
    protected boolean releaseDelayed;
    protected boolean forcedState;
    protected final Map<XRInteractionProfile, BindingPath> defaultBindings;
    protected Map<XRInteractionProfile, BindingPath> bindings;

    public VisorActionButton(VisorActionSet actionSet, String id) {
        this.actionSet = actionSet;
        this.id = id;
        this.defaultBindings = new EnumMap<XRInteractionProfile, BindingPath>(this.loadDefaults());
        this.bindings = new EnumMap<XRInteractionProfile, BindingPath>(this.defaultBindings);
    }

    protected abstract Map<XRInteractionProfile, BindingPath> loadDefaults();

    protected abstract void onPress();

    protected abstract void onRelease();

    protected void onClear() {
    }

    @Nullable
    protected VRActionDataButton getButtonData(@NotNull BindingPath bindingPath, @NotNull OpenXRProfileSet currentProfile, boolean leftHanded) {
        return bindingPath.getButton(currentProfile, leftHanded);
    }

    @Override
    public void preTick() {
        if (this.pressDelayed && !this.pressed) {
            this.pressed = true;
            this.pressDelayed = false;
            this.changed = true;
            this.onPress();
            return;
        }
        if (this.releaseDelayed && this.pressed) {
            this.forcedState = false;
            this.pressed = false;
            this.releaseDelayed = false;
            this.changed = true;
            this.onRelease();
            return;
        }
        this.changed = false;
    }

    @Override
    public void updateState(@NotNull OpenXRProfileSet currentProfile, boolean leftHanded) {
        BindingPath bindingPath = this.bindings.get((Object)currentProfile.getType());
        if (bindingPath == null) {
            this.active = false;
            if (this.pressed) {
                this.releaseDelayed = true;
                this.pressDelayed = false;
            }
            return;
        }
        if (this.forcedState) {
            return;
        }
        VRActionDataButton buttonData = this.getButtonData(bindingPath, currentProfile, leftHanded);
        if (buttonData == null) {
            if (this.active) {
                this.clear();
            }
            return;
        }
        this.active = buttonData.isActive();
        if (!this.active) {
            if (this.pressed) {
                this.releaseDelayed = true;
                this.pressDelayed = false;
            }
            return;
        }
        if (!buttonData.isButtonChanged()) {
            return;
        }
        if (buttonData.isPressed()) {
            this.pressed = false;
            this.pressDelayed = true;
            this.releaseDelayed = false;
        } else if (this.pressed) {
            this.releaseDelayed = true;
        }
    }

    @Override
    public void clear() {
        if (this.pressed) {
            this.pressed = false;
            this.releaseDelayed = false;
            this.changed = true;
            this.onRelease();
        }
        this.pressed = false;
        this.active = false;
        this.releaseDelayed = false;
        this.pressDelayed = false;
        this.changed = false;
        this.onClear();
    }

    public void forcePress() {
        this.forcedState = true;
        this.pressDelayed = true;
        this.releaseDelayed = false;
    }

    public void forceRelease() {
        this.pressDelayed = false;
        this.releaseDelayed = true;
    }

    @Override
    public void setBinding(@NotNull XRInteractionProfile profile, @NotNull BindingPath path) {
        this.bindings.put(profile, path);
    }

    @Override
    @Nullable
    public BindingPath getBinding(@NotNull XRInteractionProfile profile) {
        return this.bindings.get((Object)profile);
    }

    @Override
    @Nullable
    public BindingPath getDefaultBinding(@NotNull XRInteractionProfile profile) {
        return this.defaultBindings.get((Object)profile);
    }

    @Override
    @NotNull
    public Collection<String> getSelectableBindings(@NotNull XRInteractionProfile profile) {
        OpenXRProfileSet profileSet = VisorAPI.client().getInputManager().getProfileSetHolder().getProfileSet(profile);
        ArrayList<String> out = new ArrayList<String>();
        out.add("null");
        if (profileSet != null) {
            out.addAll(profileSet.getButtonIds());
        }
        return out;
    }

    @Override
    public VisorActionSet getActionSet() {
        return this.actionSet;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public boolean isChanged() {
        return this.changed;
    }

    public boolean isPressed() {
        return this.pressed;
    }
}

