/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.api.common.addon.element;

import java.util.Collection;
import java.util.List;
import me.phoenixra.visor.api.common.addon.VisorAddon;
import me.phoenixra.visor.api.common.addon.element.VisorElement;
import me.phoenixra.visor.api.common.utils.LoggerUtils;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface VisorRegistry<T extends VisorElement> {
    @ApiStatus.Internal
    public void registerAddonPath(@NotNull VisorAddon var1);

    public void registerElement(@NotNull T var1);

    default public void registerElements(@NotNull List<T> list) {
        list.forEach(this::registerElement);
    }

    public T unregisterElement(@NotNull String var1);

    default public void unregisterAddon(@NotNull VisorAddon addon) {
        LoggerUtils.getLogger().info("Unregistering addon from registry: {}", (Object)this.getRegistryName());
        this.getAddonElements(addon).forEach(it -> this.unregisterElement(it.getId()));
    }

    @Nullable
    public T getElement(@NotNull String var1);

    @NotNull
    default public Collection<T> getAddonElements(@NotNull VisorAddon addon) {
        return this.getAllElements().stream().filter(t -> t.getOwner().equals(addon)).toList();
    }

    @NotNull
    public Collection<T> getAllElements();

    @NotNull
    public String getRegistryName();
}

