/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.api.common.utils;

import com.sun.management.OperatingSystemMXBean;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryManagerMXBean;
import me.phoenixra.visor.api.ModLoader;
import me.phoenixra.visor.api.VisorAPI;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.Logger;

public class LoggerUtils {
    private LoggerUtils() {
        throw new UnsupportedOperationException("This is an utility class and cannot be instantiated");
    }

    public static Logger getLogger() {
        if (ModLoader.get().isDedicatedServer()) {
            return VisorAPI.server().getLogger();
        }
        return VisorAPI.client().getLogger();
    }

    public static void printError(Logger logger, Throwable throwable) {
        logger.error((Object)throwable);
        for (StackTraceElement stackTraceElement : throwable.getStackTrace()) {
            logger.error(stackTraceElement.toString());
        }
        if (throwable.getCause() != null) {
            logger.error("Caused by:");
            logger.error(throwable.getCause().toString());
        }
        for (Serializable serializable : throwable.getSuppressed()) {
            LoggerUtils.printError(logger, (Throwable)serializable);
        }
    }

    public static void printError(Throwable throwable) {
        LoggerUtils.printError(LoggerUtils.getLogger(), throwable);
    }

    public static class_2561 throwableToComponent(Throwable throwable) {
        String title = throwable.getClass().getName() + (String)(throwable.getMessage() == null ? "" : ": " + throwable.getMessage());
        class_5250 result = class_2561.method_43470((String)title);
        if (throwable.getCause() != null) {
            result.method_27693("Caused by:");
            result.method_27693(throwable.getCause().toString());
        } else {
            for (StackTraceElement element : throwable.getStackTrace()) {
                result.method_10852((class_2561)class_2561.method_43470((String)("\n" + element.toString())));
            }
        }
        return result;
    }

    public static void sendPcInfo() {
        try {
            Logger logger = LoggerUtils.getLogger();
            String garbageCollector = StringUtils.getCommonPrefix((String[])((String[])ManagementFactory.getGarbageCollectorMXBeans().stream().map(MemoryManagerMXBean::getName).toArray(String[]::new))).trim();
            if (garbageCollector.isEmpty()) {
                garbageCollector = ManagementFactory.getGarbageCollectorMXBeans().get(0).getName();
            }
            logger.info("Garbage collector: {}", (Object)garbageCollector);
            OperatingSystemMXBean os = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
            logger.info("Available CPU threads: {}", (Object)Runtime.getRuntime().availableProcessors());
            logger.info("Total physical memory: {} GB", (Object)String.format("%.01f", Float.valueOf((float)os.getTotalMemorySize() / 1.0E9f)));
            logger.info("Free physical memory: {} GB", (Object)String.format("%.01f", Float.valueOf((float)os.getFreeMemorySize() / 1.0E9f)));
        }
        catch (Throwable e) {
            LoggerUtils.printError(e);
        }
    }
}

