/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.api.common.utils;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.function.LongSupplier;
import net.minecraft.class_156;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class Vector3fHistory {
    private final Deque<Entry> history;
    private final int capacity;
    private final LongSupplier clock;

    public Vector3fHistory(int capacity, LongSupplier clock) {
        if (capacity <= 0) {
            throw new IllegalArgumentException("capacity must be > 0");
        }
        this.capacity = capacity;
        this.history = new ArrayDeque<Entry>(capacity);
        this.clock = clock;
    }

    public Vector3fHistory(int capacity) {
        this(capacity, class_156::method_658);
    }

    public synchronized void add(Vector3fc pos) {
        this.history.addLast(new Entry(pos, this.clock.getAsLong()));
        if (this.history.size() > this.capacity) {
            this.history.removeFirst();
        }
    }

    public synchronized void clear() {
        this.history.clear();
    }

    public synchronized Vector3fc latest() {
        Entry last = this.history.peekLast();
        if (last == null) {
            throw new IllegalStateException("No history available");
        }
        return last.pos;
    }

    public synchronized float totalMovement(float seconds) {
        List<Entry> recent = this.getRecent(seconds);
        if (recent.size() < 2) {
            return 0.0f;
        }
        float sum = 0.0f;
        for (int i = 1; i < recent.size(); ++i) {
            sum += recent.get((int)i).pos.distance(recent.get((int)(i - 1)).pos);
        }
        return sum;
    }

    public synchronized Vector3f netMovement(float seconds) {
        List<Entry> recent = this.getRecent(seconds);
        if (recent.size() < 2) {
            return new Vector3f(0.0f, 0.0f, 0.0f);
        }
        Vector3fc first = recent.get((int)0).pos;
        Vector3fc last = recent.get((int)(recent.size() - 1)).pos;
        return last.sub(first, new Vector3f());
    }

    public synchronized float averageSpeed(float seconds) {
        List<Entry> recent = this.getRecent(seconds);
        if (recent.size() < 2) {
            return 0.0f;
        }
        float sumSpeeds = 0.0f;
        int segments = 0;
        for (int i = 1; i < recent.size(); ++i) {
            Entry prev = recent.get(i - 1);
            Entry curr = recent.get(i);
            float dtSeconds = (float)(curr.timestamp - prev.timestamp) / 1000.0f;
            if (!(dtSeconds > 0.0f)) continue;
            float dist = curr.pos.distance(prev.pos);
            sumSpeeds += dist / dtSeconds;
            ++segments;
        }
        return segments == 0 ? 0.0f : sumSpeeds / (float)segments;
    }

    public synchronized Vector3f averagePosition(float seconds) {
        List<Entry> recent = this.getRecent(seconds);
        if (recent.isEmpty()) {
            return new Vector3f(0.0f, 0.0f, 0.0f);
        }
        float x = 0.0f;
        float y = 0.0f;
        float z = 0.0f;
        for (Entry e : recent) {
            x += e.pos.x();
            y += e.pos.y();
            z += e.pos.z();
        }
        float inv = 1.0f / (float)recent.size();
        return new Vector3f(x * inv, y * inv, z * inv);
    }

    private List<Entry> getRecent(float seconds) {
        long now = this.clock.getAsLong();
        long cutoff = now - (long)(seconds * 1000.0f);
        ArrayList<Entry> out = new ArrayList<Entry>(this.capacity);
        Iterator<Entry> it = this.history.descendingIterator();
        while (it.hasNext()) {
            Entry e = it.next();
            if (e.timestamp < cutoff) break;
            out.add(0, e);
        }
        return out;
    }

    private record Entry(Vector3fc pos, long timestamp) {
    }
}

