/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.core.client;

import java.util.ArrayList;
import java.util.List;
import me.phoenixra.atumconfig.api.ConfigManager;
import me.phoenixra.atumconfig.core.AtumConfigManager;
import me.phoenixra.atumconfig.core.AtumPlaceholderHandler;
import me.phoenixra.atumvr.api.VRProvider;
import me.phoenixra.atumvr.api.VRState;
import me.phoenixra.atumvr.api.utils.GLUtils;
import me.phoenixra.visor.api.VisorAPI;
import me.phoenixra.visor.api.VisorClient;
import me.phoenixra.visor.api.client.ClientFeature;
import me.phoenixra.visor.api.client.VRClientPlayer;
import me.phoenixra.visor.api.client.input.InputManager;
import me.phoenixra.visor.api.client.tasks.VisorTask;
import me.phoenixra.visor.api.common.MCVRLogger;
import me.phoenixra.visor.api.common.utils.LoggerUtils;
import me.phoenixra.visor.core.client.ClientContext;
import me.phoenixra.visor.core.client.ClientFeaturesToggle;
import me.phoenixra.visor.core.client.VisorState;
import me.phoenixra.visor.core.client.data.VRClientPlayerImpl;
import me.phoenixra.visor.core.client.gui.VRGuiManagerImpl;
import me.phoenixra.visor.core.client.input.InputManagerImpl;
import me.phoenixra.visor.core.client.network.players.VRRemotePlayers;
import me.phoenixra.visor.core.client.provider.openxr.XrProvider;
import me.phoenixra.visor.core.client.render.VRRendererBase;
import me.phoenixra.visor.core.client.render.context.PreRenderContext;
import me.phoenixra.visor.core.client.render.context.RenderContext;
import me.phoenixra.visor.core.client.render.decoration.DecorationRendererImpl;
import me.phoenixra.visor.core.client.settings.VRClientSettings;
import me.phoenixra.visor.core.client.settings.VRClientSettingsHandler;
import me.phoenixra.visor.core.client.tasks.registry.VisorTaskRegistry;
import me.phoenixra.visor.core.common.addon.AddonManagerImpl;
import me.phoenixra.visor.core.common.addon.CoreAddonClient;
import net.minecraft.class_310;
import net.minecraft.class_429;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class VisorClientImpl
implements VisorClient {
    public static class_310 MC;
    public static final Logger LOGGER;
    private VRProvider vrProvider;
    private ConfigManager configManager;
    private VisorTaskRegistry taskRegistry;
    private ClientFeaturesToggle featuresToggle;

    public VisorClientImpl() {
        MC = class_310.method_1551();
    }

    protected void prepare() {
        this.vrProvider = new XrProvider("Visor", new MCVRLogger(LOGGER));
        this.featuresToggle = new ClientFeaturesToggle();
        this.configManager = new AtumConfigManager("visor_client", VisorAPI.CONFIG_PATH, this.vrProvider.getLogger(), true);
        this.configManager.setPlaceholderHandler(new AtumPlaceholderHandler(this.vrProvider.getLogger()));
        ClientContext.settingsHandler = new VRClientSettingsHandler();
        ClientContext.inputManager = new InputManagerImpl();
        ClientContext.decorationRenderer = new DecorationRendererImpl();
        ClientContext.guiManager = new VRGuiManagerImpl();
        ClientContext.player = new VRClientPlayerImpl();
        this.taskRegistry = new VisorTaskRegistry();
        ClientContext.addonManager = new AddonManagerImpl(LOGGER);
        ArrayList registries = new ArrayList();
        registries.add(this.taskRegistry);
        registries.addAll(ClientContext.inputManager.getElementRegistries());
        registries.addAll(ClientContext.decorationRenderer.getElementRegistries());
        registries.addAll(ClientContext.guiManager.getElementRegistries());
        ClientContext.addonManager.initialize(new CoreAddonClient(), registries);
    }

    protected void initializeVR() throws Throwable {
        this.vrProvider.initializeVR();
    }

    public void syncVRState() {
        this.vrProvider.syncState();
    }

    public void preTickVR() {
        try {
            this.featuresToggle.preTick();
            ClientContext.inputManager.preTick();
            List<VisorTask> tasks = ClientContext.visor.getTaskRegistry().getPreTick();
            for (VisorTask task : tasks) {
                if (task.isEnabledAndActive(null)) {
                    task.run(null);
                    continue;
                }
                task.clear(null);
            }
            ClientContext.player.preTick();
        }
        catch (Throwable e) {
            VisorState.destroyVRWithErrorScreen(e);
        }
    }

    public void tickVR() {
        try {
            ++VisorState.TICK_COUNT;
            VRRemotePlayers.getInstance().tick();
            ClientContext.decorationRenderer.tick();
        }
        catch (Throwable e) {
            VisorState.destroyVRWithErrorScreen(e);
        }
    }

    public void postTickVR() {
        try {
            ClientContext.player.postTick();
        }
        catch (Throwable e) {
            VisorState.destroyVRWithErrorScreen(e);
        }
    }

    public void earlyPreRenderVR(PreRenderContext context) {
        try {
            this.vrProvider.preRender(context);
            ClientContext.inputManager.update();
            ClientContext.player.earlyPreRender();
            if (!(VisorClientImpl.MC.field_1755 instanceof class_429) && VRClientSettings.getEyeFovScaleCurrent() != VRClientSettings.getEyesFovScale()) {
                VRClientSettings.setEyeFovScaleCurrent(VRClientSettings.getEyesFovScale());
            }
            this.featuresToggle.preRender();
            List<VisorTask> tasks = ClientContext.visor.getTaskRegistry().getPreRender();
            for (VisorTask task : tasks) {
                if (task.isEnabledAndActive(null)) {
                    task.run(null);
                    continue;
                }
                task.clear(null);
            }
        }
        catch (Throwable e) {
            VisorState.destroyVRWithErrorScreen(e);
        }
    }

    public void preRenderVR(PreRenderContext context) {
        try {
            ClientContext.player.preRender(context.partialTicks());
        }
        catch (Throwable e) {
            VisorState.destroyVRWithErrorScreen(e);
        }
    }

    public void renderVR(RenderContext context) {
        try {
            context.profiler().method_15396("VR render");
            ClientContext.renderer.render(context);
            context.profiler().method_15407();
            GLUtils.checkGLError("post VR render");
        }
        catch (Throwable e) {
            VisorState.destroyVRWithErrorScreen(e);
        }
    }

    public boolean isActive() {
        VRState state = this.vrProvider.getState();
        return state.isActive();
    }

    public boolean isFocused() {
        VRState state = this.vrProvider.getState();
        return state.isFocused();
    }

    @Override
    @NotNull
    public VRClientPlayer getPlayer() {
        return ClientContext.player;
    }

    @Override
    @NotNull
    public VRRendererBase getRenderer() {
        return ClientContext.renderer;
    }

    @Override
    @NotNull
    public Logger getLogger() {
        return LOGGER;
    }

    @Override
    @NotNull
    public InputManager getInputManager() {
        return ClientContext.inputManager;
    }

    @Override
    @NotNull
    public DecorationRendererImpl getDecorationRenderer() {
        return ClientContext.decorationRenderer;
    }

    @Override
    @NotNull
    public VRGuiManagerImpl getGuiManager() {
        return ClientContext.guiManager;
    }

    @Override
    public boolean isFeatureEnabled(@NotNull ClientFeature feature) {
        return this.featuresToggle.isAllowed(feature);
    }

    protected void destroy() {
        try {
            this.vrProvider.destroy();
        }
        catch (Throwable throwable) {
            LoggerUtils.printError(throwable);
        }
    }

    @Override
    public VRProvider getVrProvider() {
        return this.vrProvider;
    }

    @Override
    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public VisorTaskRegistry getTaskRegistry() {
        return this.taskRegistry;
    }

    public ClientFeaturesToggle getFeaturesToggle() {
        return this.featuresToggle;
    }

    static {
        LOGGER = LogManager.getLogger((String)"Visor");
    }
}

