/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.core.client;

import me.phoenixra.visor.api.VisorAPI;
import me.phoenixra.visor.api.VisorClientState;
import me.phoenixra.visor.api.client.VRPlayMode;
import me.phoenixra.visor.api.client.VRStateMode;
import me.phoenixra.visor.api.client.render.RenderPhase;
import me.phoenixra.visor.api.client.render.VRDisplay;
import me.phoenixra.visor.api.common.network.toserver.vrstate.VRActivePayloadToServer;
import me.phoenixra.visor.api.common.utils.LoggerUtils;
import me.phoenixra.visor.core.client.ClientContext;
import me.phoenixra.visor.core.client.VisorClientImpl;
import me.phoenixra.visor.core.client.gui.screens.GameMenuScreen;
import me.phoenixra.visor.core.client.gui.screens.VRErrorReportScreen;
import me.phoenixra.visor.core.client.network.ClientNetworking;
import me.phoenixra.visor.core.client.network.players.VRRemotePlayers;
import me.phoenixra.visor.core.client.render.VRRenderState;
import me.phoenixra.visor.core.client.settings.VRClientSettings;
import net.minecraft.class_1297;
import net.minecraft.class_3675;
import net.minecraft.class_419;
import net.minecraft.class_437;
import net.minecraft.class_442;
import org.jetbrains.annotations.NotNull;

public class VisorState
implements VisorClientState {
    private static VRStateMode state = VRStateMode.OFF;
    public static int TICK_COUNT;
    public static long FRAME_COUNT;
    private static boolean minecraftLoaded;
    private static Runnable delayedErrorHandling;

    public static void updateState() {
        boolean canInit;
        if (ClientContext.visor == null) {
            if (!minecraftLoaded) {
                return;
            }
            VisorState.startClient();
        }
        if (delayedErrorHandling != null && (VisorClientImpl.MC.field_1755 instanceof class_419 || VisorClientImpl.MC.field_1755 instanceof class_442)) {
            delayedErrorHandling.run();
            delayedErrorHandling = null;
        }
        if (canInit = VRClientSettings.getVrPlayMode().canInitVR()) {
            if (state.isNotInitialized()) {
                VisorState.initVR();
                return;
            }
        } else if (state.isInitialized()) {
            VisorState.destroyVR();
            return;
        }
        if (state.isNotInitialized()) {
            return;
        }
        ClientContext.visor.syncVRState();
        VRPlayMode playMode = VRClientSettings.getVrPlayMode();
        boolean vrActive = playMode.canPlayVR() && (ClientContext.visor.isActive() || playMode == VRPlayMode.ALWAYS_ACTIVE);
        boolean changed = VisorState.updateActive(vrActive);
        if (changed) {
            return;
        }
        if (state.isActive()) {
            if (ClientContext.visor.isFocused()) {
                state = VRStateMode.FOCUSED;
            } else {
                if (state != VRStateMode.ACTIVE && VisorClientImpl.MC.field_1687 != null) {
                    VisorClientImpl.MC.method_1507((class_437)new GameMenuScreen());
                }
                state = VRStateMode.ACTIVE;
            }
        }
    }

    private static void startClient() {
        try {
            if (ClientContext.visor != null) {
                return;
            }
            VisorClientImpl.LOGGER.info("Starting Visor client...");
            VisorAPI.Instance.setClientState(new VisorState());
            ClientContext.visor = new VisorClientImpl();
            VisorAPI.Instance.setClient(ClientContext.visor);
            ClientContext.visor.prepare();
            VisorClientImpl.LOGGER.info("Current VR Play Mode: {}", (Object)VRClientSettings.getVrPlayMode());
        }
        catch (Throwable e) {
            VisorState.destroyVRWithErrorScreen(e);
        }
    }

    private static void initVR() {
        try {
            VisorClientImpl.LOGGER.info("Initializing VR session...");
            ClientContext.visor.initializeVR();
            VRRenderState.startVanillaPhase();
            state = VRStateMode.INITIALIZED;
            VisorClientImpl.LOGGER.info("VR session INIT SUCCESS");
            LoggerUtils.sendPcInfo();
        }
        catch (Throwable e) {
            VisorState.destroyVRWithErrorScreen(e);
        }
    }

    private static boolean updateActive(boolean active) {
        if (state.isActive() == active) {
            return false;
        }
        if (active) {
            VisorState.activate();
        } else {
            VisorState.deactivate();
        }
        ClientNetworking.sendVRPacket(new VRActivePayloadToServer(state.isActive()));
        if (!VisorClientImpl.MC.method_1483().method_4864().isEmpty()) {
            VisorClientImpl.MC.method_1483().method_38566();
        }
        VisorClientImpl.MC.method_15993();
        VisorClientImpl.MC.method_22683().method_4497(((Boolean)VisorClientImpl.MC.field_1690.method_42433().method_41753()).booleanValue());
        ClientContext.renderer.prepareReinit("Switched state");
        return true;
    }

    private static void activate() {
        state = VRStateMode.ACTIVE;
        if (VisorClientImpl.MC.field_1724 != null) {
            ClientContext.player.recenterOrigin((class_1297)VisorClientImpl.MC.field_1724, false);
        }
        class_3675.method_15984((long)VisorClientImpl.MC.method_22683().method_4490(), (int)212993, (double)VisorClientImpl.MC.field_1729.method_1603(), (double)VisorClientImpl.MC.field_1729.method_1604());
    }

    private static void deactivate() {
        state = VRStateMode.INITIALIZED;
        if (VisorClientImpl.MC.field_1724 != null) {
            VRRemotePlayers.getInstance().removePlayer(VisorClientImpl.MC.field_1724.method_5667());
        }
        if (VisorClientImpl.MC.field_1773 != null) {
            VisorClientImpl.MC.field_1773.method_3167(VisorClientImpl.MC.field_1690.method_31044().method_31034() ? VisorClientImpl.MC.method_1560() : null);
        }
        if (VisorClientImpl.MC.field_1755 != null || VisorClientImpl.MC.field_1687 == null) {
            VisorClientImpl.MC.field_1729.method_1610();
            class_3675.method_15984((long)VisorClientImpl.MC.method_22683().method_4490(), (int)212993, (double)VisorClientImpl.MC.field_1729.method_1603(), (double)VisorClientImpl.MC.field_1729.method_1604());
        } else {
            VisorClientImpl.MC.field_1729.method_1612();
            class_3675.method_15984((long)VisorClientImpl.MC.method_22683().method_4490(), (int)212995, (double)VisorClientImpl.MC.field_1729.method_1603(), (double)VisorClientImpl.MC.field_1729.method_1604());
        }
    }

    public static void destroyVRWithErrorScreen(Throwable throwable) {
        VisorState.destroyVR();
        VRClientSettings.setVrPlayMode(VRPlayMode.DISABLED);
        if (VisorClientImpl.MC.field_1687 != null) {
            VisorClientImpl.MC.field_1687.method_8525();
            delayedErrorHandling = () -> VRErrorReportScreen.catchError(throwable, true);
        } else {
            VRErrorReportScreen.catchError(throwable, true);
        }
    }

    public static void destroyVR() {
        if (ClientContext.visor != null) {
            VisorState.updateActive(false);
            state = VRStateMode.OFF;
            ClientContext.visor.destroy();
        } else {
            state = VRStateMode.OFF;
        }
    }

    @Override
    @NotNull
    public VRStateMode stateMode() {
        return state;
    }

    @Override
    @NotNull
    public VRPlayMode playMode() {
        return VRClientSettings.getVrPlayMode();
    }

    @Override
    @NotNull
    public RenderPhase renderPhase() {
        return VRRenderState.getCurrentPhase();
    }

    @Override
    public VRDisplay renderingDisplay() {
        return VRRenderState.getCurrentVRDisplay();
    }

    public static VRStateMode getState() {
        return state;
    }

    public static void setMinecraftLoaded(boolean minecraftLoaded) {
        VisorState.minecraftLoaded = minecraftLoaded;
    }

    static {
        minecraftLoaded = false;
        delayedErrorHandling = null;
    }
}

