/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.core.client.data;

import java.util.List;
import me.phoenixra.atumvr.api.enums.EyeType;
import me.phoenixra.visor.api.client.data.PoseData;
import me.phoenixra.visor.api.client.data.PoseDataType;
import me.phoenixra.visor.api.client.data.PoseElement;
import me.phoenixra.visor.api.client.render.VRDisplay;
import me.phoenixra.visor.api.common.ControllerHand;
import me.phoenixra.visor.api.common.utils.VRMathUtils;
import me.phoenixra.visor.core.client.ClientContext;
import me.phoenixra.visor.core.client.data.PoseElementImpl;
import me.phoenixra.visor.core.client.data.raw.RawController;
import me.phoenixra.visor.core.client.data.raw.RawHmd;
import me.phoenixra.visor.core.client.settings.VRClientSettings;
import net.minecraft.class_3532;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class PoseDataImpl
implements PoseData {
    private final PoseDataType type;
    protected final PoseElementImpl hmd;
    protected final PoseElementImpl eyeLeft;
    protected final PoseElementImpl eyeRight;
    protected final PoseElementImpl controllerMain;
    protected final PoseElementImpl controllerOffhand;
    protected final PoseElementImpl handMain;
    protected final PoseElementImpl handOffhand;
    protected final PoseElementImpl thirdPersonCamera;
    private final List<PoseElementImpl> elements;
    private Vector3fc origin;
    private float rotationY;
    private float worldScale;
    private float bodyYaw;
    private Vector3fc headPivot;

    public PoseDataImpl(PoseDataType type, Vector3fc origin, float walkMul, float worldScale, float rotationY) {
        this.type = type;
        this.hmd = new PoseElementImpl();
        this.eyeLeft = new PoseElementImpl();
        this.eyeRight = new PoseElementImpl();
        this.controllerOffhand = new PoseElementImpl();
        this.controllerMain = new PoseElementImpl();
        this.handOffhand = new PoseElementImpl();
        this.handMain = new PoseElementImpl();
        this.thirdPersonCamera = new PoseElementImpl();
        this.elements = List.of(this.hmd, this.eyeLeft, this.eyeRight, this.controllerOffhand, this.controllerMain, this.handOffhand, this.handMain, this.thirdPersonCamera);
        this.update(origin, walkMul, worldScale, rotationY);
    }

    protected void update(Vector3fc origin, float walkMul, float worldScale, float rotationY) {
        RawController dataMain = ClientContext.rawPoseHandler.getControllerData(ControllerHand.MAIN);
        RawController dataOffhand = ClientContext.rawPoseHandler.getControllerData(ControllerHand.OFFHAND);
        this.origin = origin;
        this.worldScale = worldScale;
        this.rotationY = rotationY;
        RawHmd hmdData = ClientContext.rawPoseHandler.getHmdData();
        Vector3f headsetPos = hmdData.getHeadsetPosition();
        Vector3f headsetPosFinal = new Vector3f(headsetPos.x * walkMul, headsetPos.y, headsetPos.z * walkMul);
        this.hmd.update(this.origin, this.rotationY, this.worldScale, hmdData.getRotation(), (Vector3fc)headsetPosFinal, (Vector3fc)hmdData.getVector());
        this.eyeLeft.update(this.origin, this.rotationY, this.worldScale, hmdData.getEyeRotation(EyeType.LEFT), (Vector3fc)hmdData.getEyePosition(EyeType.LEFT).sub((Vector3fc)headsetPos).add((Vector3fc)headsetPosFinal), (Vector3fc)hmdData.getVector());
        this.eyeRight.update(this.origin, this.rotationY, this.worldScale, hmdData.getEyeRotation(EyeType.RIGHT), (Vector3fc)hmdData.getEyePosition(EyeType.RIGHT).sub((Vector3fc)headsetPos).add((Vector3fc)headsetPosFinal), (Vector3fc)hmdData.getVector());
        this.controllerOffhand.update(this.origin, this.rotationY, this.worldScale, dataOffhand.getAimRotation(), (Vector3fc)dataOffhand.getAimPosition().sub((Vector3fc)headsetPos).add((Vector3fc)headsetPosFinal), (Vector3fc)dataOffhand.getAimVector());
        this.controllerMain.update(this.origin, this.rotationY, this.worldScale, dataMain.getAimRotation(), (Vector3fc)dataMain.getAimPosition().sub((Vector3fc)headsetPos).add((Vector3fc)headsetPosFinal), (Vector3fc)dataMain.getAimVector());
        this.handOffhand.update(this.origin, this.rotationY, this.worldScale, dataOffhand.getGripRotation(), (Vector3fc)dataOffhand.getAimPosition().sub((Vector3fc)headsetPos).add((Vector3fc)headsetPosFinal), (Vector3fc)dataOffhand.getGripVector());
        this.handMain.update(this.origin, this.rotationY, this.worldScale, dataMain.getGripRotation(), (Vector3fc)dataMain.getAimPosition().sub((Vector3fc)headsetPos).add((Vector3fc)headsetPosFinal), (Vector3fc)dataMain.getGripVector());
        Vector3f camPos = new Vector3f(VRClientSettings.getThirdPersonCameraPosX(), VRClientSettings.getThirdPersonCameraPosY(), VRClientSettings.getThirdPersonCameraPosZ());
        Matrix4f camRot = VRClientSettings.getThirdPersonCameraRotation().get(new Matrix4f());
        Vector3f camDir = camRot.transformDirection(VRMathUtils.BACK_VECTOR, new Vector3f());
        this.thirdPersonCamera.update(this.origin, this.rotationY, this.worldScale, (Matrix4fc)camRot, (Vector3fc)camPos.sub((Vector3fc)headsetPos).add((Vector3fc)headsetPosFinal), (Vector3fc)camDir);
        this.bodyYaw = this.calcBodyYaw();
        this.headPivot = this.calcHeadPivot();
    }

    public Vector3f createNewHeadPivot(Vector3fc newOrigin, float newWorldScale) {
        Vector3f hmdPosition = this.hmd.getPosition().add(newOrigin.x() - this.origin.x(), newOrigin.y() - this.origin.y(), newOrigin.z() - this.origin.z(), new Vector3f());
        Vector3f headPivotOffset = this.hmd.getRotation().transformPosition(new Vector3f(0.0f, -0.1f * newWorldScale, 0.1f * newWorldScale));
        return hmdPosition.add((Vector3fc)headPivotOffset);
    }

    private float calcBodyYaw() {
        Vector3fc hmdDirection;
        Vector3f bodyPos = this.controllerOffhand.getPosition().sub(this.controllerMain.getPosition(), new Vector3f()).normalize().rotateY(-1.5707964f);
        if ((double)bodyPos.dot(hmdDirection = this.hmd.getDirection()) < 0.0) {
            bodyPos = bodyPos.mul(-1.0f);
        }
        bodyPos = VRMathUtils.lerpVector(hmdDirection, (Vector3fc)bodyPos, 0.7f);
        return (float)class_3532.method_15349((double)(-bodyPos.x), (double)bodyPos.z);
    }

    private Vector3f calcHeadPivot() {
        Vector3fc hmdPosition = this.hmd.getPosition();
        Vector3f transform = this.hmd.getRotation().transformPosition(new Vector3f(0.0f, -0.1f * this.worldScale, 0.1f * this.worldScale));
        return new Vector3f(transform.x() + hmdPosition.x(), transform.y() + hmdPosition.y(), transform.z() + hmdPosition.z());
    }

    protected void resetOrigin(Vector3fc newOrigin) {
        this.origin = newOrigin;
        this.elements.forEach(it -> it.onOriginChanged(this.origin));
        this.headPivot = this.calcHeadPivot();
        this.bodyYaw = this.calcBodyYaw();
    }

    @Override
    @NotNull
    public PoseElement getElementForDisplay(@Nullable VRDisplay display) {
        if (display == null) {
            return this.hmd;
        }
        return switch (display) {
            case VRDisplay.FIRST_PERSON -> this.hmd;
            case VRDisplay.THIRD_PERSON -> this.thirdPersonCamera;
            case VRDisplay.EYE_LEFT -> this.eyeLeft;
            case VRDisplay.EYE_RIGHT -> this.eyeRight;
            default -> this.hmd;
        };
    }

    @Override
    @NotNull
    public Vector3f convertPositionFrom(@NotNull PoseDataType originType, @NotNull Vector3fc position) {
        if (originType == this.type) {
            return new Vector3f(position.x(), position.y(), position.z());
        }
        if (originType == PoseDataType.ROOM) {
            return position.mul(this.worldScale, new Vector3f()).rotateY(this.rotationY).add(this.origin);
        }
        PoseDataImpl originPose = ClientContext.player.getPoseData(originType);
        Vector3f roomPose = position.sub(originPose.origin, new Vector3f()).mul(1.0f / originPose.worldScale).rotateY(-originPose.rotationY);
        if (this.type == PoseDataType.ROOM) {
            return roomPose;
        }
        return roomPose.mul(this.worldScale).rotateY(this.rotationY).add(this.origin);
    }

    @Override
    @NotNull
    public Matrix4f convertRotationFrom(@NotNull PoseDataType originType, @NotNull Matrix4fc rotationMatrix) {
        if (originType == this.type) {
            return new Matrix4f(rotationMatrix);
        }
        if (originType == PoseDataType.ROOM) {
            return new Matrix4f().rotationY(this.rotationY).mul(rotationMatrix);
        }
        PoseDataImpl originPose = ClientContext.player.getPoseData(originType);
        if (this.type == PoseDataType.ROOM) {
            return new Matrix4f().rotationY(-originPose.rotationY).mul(rotationMatrix);
        }
        return new Matrix4f().rotationY(this.rotationY - originPose.rotationY).mul(rotationMatrix);
    }

    public String toString() {
        return String.format("VRClientPose:%n  Pose Stage         : %s%n  Origin             : %s%n  Rotation           : %.2f\u00b0%n  World Scale        : %.2f%n  Body Yaw           : %.2f\u00b0%n  Head Pivot         : %s%n  HMD                : %s%n  Eye Left           : %s%n  Eye Right          : %s%n  Controller Left    : %s%n  Controller Right   : %s%n  Hand Left          : %s%n  Hand Right         : %s%n  Third Person Camera: %s", new Object[]{this.type, this.origin, Math.toDegrees(this.rotationY), Float.valueOf(this.worldScale), Math.toDegrees(this.bodyYaw), this.headPivot, this.hmd, this.eyeLeft, this.eyeRight, this.controllerOffhand, this.controllerMain, this.handOffhand, this.handMain, this.thirdPersonCamera});
    }

    @Override
    public PoseDataType getType() {
        return this.type;
    }

    @Override
    public PoseElementImpl getHmd() {
        return this.hmd;
    }

    @Override
    public PoseElementImpl getEyeLeft() {
        return this.eyeLeft;
    }

    @Override
    public PoseElementImpl getEyeRight() {
        return this.eyeRight;
    }

    @Override
    public PoseElementImpl getControllerMain() {
        return this.controllerMain;
    }

    @Override
    public PoseElementImpl getControllerOffhand() {
        return this.controllerOffhand;
    }

    @Override
    public PoseElementImpl getHandMain() {
        return this.handMain;
    }

    @Override
    public PoseElementImpl getHandOffhand() {
        return this.handOffhand;
    }

    public PoseElementImpl getThirdPersonCamera() {
        return this.thirdPersonCamera;
    }

    public List<PoseElementImpl> getElements() {
        return this.elements;
    }

    @Override
    public Vector3fc getOrigin() {
        return this.origin;
    }

    @Override
    public float getRotationY() {
        return this.rotationY;
    }

    @Override
    public float getWorldScale() {
        return this.worldScale;
    }

    @Override
    public float getBodyYaw() {
        return this.bodyYaw;
    }

    @Override
    public Vector3fc getHeadPivot() {
        return this.headPivot;
    }
}

