/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.core.client.data;

import java.util.List;
import me.phoenixra.visor.api.client.VRClientPlayer;
import me.phoenixra.visor.api.client.data.ControllerRaw;
import me.phoenixra.visor.api.client.data.HmdRaw;
import me.phoenixra.visor.api.client.data.PoseDataType;
import me.phoenixra.visor.api.client.data.PoseElement;
import me.phoenixra.visor.api.client.tasks.VisorTask;
import me.phoenixra.visor.api.common.ControllerHand;
import me.phoenixra.visor.api.common.utils.VRMathUtils;
import me.phoenixra.visor.core.client.ClientContext;
import me.phoenixra.visor.core.client.VisorClientImpl;
import me.phoenixra.visor.core.client.VisorState;
import me.phoenixra.visor.core.client.data.PoseDataImpl;
import me.phoenixra.visor.core.client.network.ClientNetworking;
import me.phoenixra.visor.core.client.render.VRRenderState;
import me.phoenixra.visor.core.client.settings.VRClientSettings;
import me.phoenixra.visor.core.client.settings.options.enums.RotationMode;
import me.phoenixra.visor.core.client.tasks.movement.vehicle.TaskRoomVehicle;
import me.phoenixra.visor.modified.client.entity.LocalPlayerModified;
import me.phoenixra.visor.modified.client.render.GameRendererModified;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_746;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2f;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class VRClientPlayerImpl
implements VRClientPlayer {
    private final PoseDataImpl roomPose;
    private final PoseDataImpl preTickPose;
    private final PoseDataImpl postTickPose;
    private final PoseDataImpl renderPose;
    private Vector3fc origin = new Vector3f(0.0f, 0.0f, 0.0f);
    private float worldScale = 1.0f;
    private float rotationY = 0.0f;
    private ControllerHand activeHand = ControllerHand.MAIN;
    private Vector2f movement = new Vector2f();
    private boolean moving;

    public VRClientPlayerImpl() {
        this.roomPose = new PoseDataImpl(PoseDataType.ROOM, this.origin, VRClientSettings.getWalkMultiplier(), 1.0f, 0.0f);
        this.preTickPose = new PoseDataImpl(PoseDataType.PRE_TICK, this.origin, VRClientSettings.getWalkMultiplier(), 1.0f, 0.0f);
        this.postTickPose = new PoseDataImpl(PoseDataType.POST_TICK, this.origin, VRClientSettings.getWalkMultiplier(), 1.0f, 0.0f);
        this.renderPose = new PoseDataImpl(PoseDataType.RENDER, this.origin, VRClientSettings.getWalkMultiplier(), 1.0f, 0.0f);
    }

    public void preTick() {
        float preWorldScale;
        this.preTickPose.update(this.origin, VRClientSettings.getWalkMultiplier(), this.worldScale, this.rotationY);
        this.worldScale = preWorldScale = VRRenderState.isInMainMenu() ? 1.0f : VRClientSettings.getWorldScale();
    }

    public void tickPlayer(class_746 player) {
        try {
            List<VisorTask> tasks = ClientContext.visor.getTaskRegistry().getPlayerTick();
            for (VisorTask task : tasks) {
                if (task.isEnabledAndActive(player)) {
                    task.run(player);
                    continue;
                }
                task.clear(player);
            }
        }
        catch (Throwable e) {
            VisorState.destroyVRWithErrorScreen(e);
        }
    }

    public void postTick() {
        Vector3f scaleOffset = this.preTickPose.hmd.getScalePosOffset(this.preTickPose.getRotationY(), this.preTickPose.getWorldScale(), this.worldScale);
        this.origin = this.origin.sub((Vector3fc)scaleOffset, new Vector3f());
        Vector3f headPivot = this.preTickPose.createNewHeadPivot(this.origin, this.worldScale);
        float currentRotation = this.rotationY;
        float oldRotation = this.preTickPose.getRotationY();
        this.rotateOriginAround((Vector3fc)headPivot, oldRotation - currentRotation);
        this.postTickPose.update(this.origin, VRClientSettings.getWalkMultiplier(), this.worldScale, currentRotation);
        this.updatePlayerLook(VisorClientImpl.MC.field_1724, PoseDataType.POST_TICK);
        ClientNetworking.sendVRPlayerPose();
    }

    public void earlyPreRender() {
        this.roomPose.update(VRMathUtils.ZERO_VECTOR, VRClientSettings.getWalkMultiplier(), 1.0f, 0.0f);
    }

    public void preRender(float partialTicks) {
        float rotationPre = this.preTickPose.getRotationY();
        float rotationPost = this.postTickPose.getRotationY();
        float rotationDelta = Math.abs(rotationPost - rotationPre);
        if ((double)rotationDelta > Math.PI) {
            if (rotationPost > rotationPre) {
                rotationPre = (float)((double)rotationPre + Math.PI * 2);
            } else {
                rotationPost = (float)((double)rotationPost + Math.PI * 2);
            }
        }
        float renderRotation = rotationPost * partialTicks + rotationPre * (1.0f - partialTicks);
        Vector3fc preTickOrigin = this.preTickPose.getOrigin();
        Vector3fc postTickOrigin = this.postTickPose.getOrigin();
        Vector3f renderOrigin = new Vector3f(preTickOrigin.x() + (postTickOrigin.x() - preTickOrigin.x()) * partialTicks, preTickOrigin.y() + (postTickOrigin.y() - preTickOrigin.y()) * partialTicks, preTickOrigin.z() + (postTickOrigin.z() - preTickOrigin.z()) * partialTicks);
        float preTickWorld = this.preTickPose.getWorldScale();
        float postTickWorld = this.postTickPose.getWorldScale();
        float renderWorldScale = postTickWorld * partialTicks + preTickWorld * (1.0f - partialTicks);
        this.renderPose.update((Vector3fc)renderOrigin, VRClientSettings.getWalkMultiplier(), renderWorldScale, renderRotation);
    }

    public void updatePlayerLook(class_746 player, PoseDataType stage) {
        if (player == null) {
            return;
        }
        PoseDataImpl data = this.getPoseData(stage);
        if (player.method_5765()) {
            Vector3fc vehicleLookDir = TaskRoomVehicle.getVehicleLookDirection(player);
            if (vehicleLookDir != null) {
                player.method_36457((float)Math.toDegrees(Math.asin(-vehicleLookDir.y() / vehicleLookDir.length())));
                player.method_36456((float)Math.toDegrees(class_3532.method_15349((double)(-vehicleLookDir.x()), (double)vehicleLookDir.z())));
                player.method_5847(player.method_36454());
            }
            return;
        }
        if (player.method_6039()) {
            if (ClientContext.player.getActiveHand() == ControllerHand.MAIN) {
                player.method_36456(data.getController(ControllerHand.MAIN).getYaw());
                player.method_5847(player.method_36454());
                player.method_36457(-data.getController(ControllerHand.MAIN).getPitch());
            } else {
                player.method_36456(data.getController(ControllerHand.OFFHAND).getYaw());
                player.method_5847(player.method_36454());
                player.method_36457(-data.getController(ControllerHand.OFFHAND).getPitch());
            }
            return;
        }
        if (player.method_5624() && (player.field_3913.field_3904 || VisorClientImpl.MC.field_1690.field_1903.method_1434()) || player.method_6128() || player.method_5681() && player.field_6250 > 0.0f) {
            PoseElement rotationElement = this.getRotationElement(data.getType());
            player.method_36456(rotationElement.getYaw());
            player.method_5847(player.method_36454());
            player.method_36457(-rotationElement.getPitch());
            return;
        }
        if (((GameRendererModified)VisorClientImpl.MC.field_1773).visor$getCrossVec() != null) {
            class_243 playerToCrosshair = player.method_5836(1.0f).method_1020(((GameRendererModified)VisorClientImpl.MC.field_1773).visor$getCrossVec());
            double what = playerToCrosshair.field_1351 / playerToCrosshair.method_1033();
            if (what > 1.0) {
                what = 1.0;
            }
            if (what < -1.0) {
                what = -1.0;
            }
            float pitch = (float)Math.toDegrees(Math.asin(what));
            float yaw = (float)Math.toDegrees(class_3532.method_15349((double)playerToCrosshair.field_1352, (double)(-playerToCrosshair.field_1350)));
            player.method_36457(pitch);
            player.method_36456(yaw);
            player.method_5847(yaw);
            return;
        }
        player.method_36456(data.hmd.getYaw());
        player.method_5847(player.method_36454());
        player.method_36457(-data.hmd.getPitch());
    }

    public void recenterOrigin(@NotNull class_1297 cameraEntity, boolean reset) {
        Vector3fc headPivot = this.preTickPose.getHeadPivot();
        Vector3f headOffset = headPivot.sub(this.preTickPose.getOrigin(), new Vector3f());
        float x = (float)(cameraEntity.method_23317() - (double)headOffset.x);
        float z = (float)(cameraEntity.method_23321() - (double)headOffset.z);
        float y = (float)cameraEntity.method_23318();
        if (cameraEntity instanceof LocalPlayerModified) {
            LocalPlayerModified p = (LocalPlayerModified)cameraEntity;
            y += (float)p.visor$getRoomYOffset();
        }
        this.setOrigin(x, y, z, reset);
    }

    public void rotateOriginAround(Vector3fc anchor, float radians) {
        float radSin = class_3532.method_15374((float)radians);
        float radCos = class_3532.method_15362((float)radians);
        this.setOrigin(radCos * (this.origin.x() - anchor.x()) - radSin * (this.origin.z() - anchor.z()) + anchor.x(), this.origin.y(), radSin * (this.origin.x() - anchor.x()) + radCos * (this.origin.z() - anchor.z()) + anchor.z(), false);
    }

    public void setOrigin(float x, float y, float z, boolean reset) {
        Vector3f newOrigin = new Vector3f(x, y, z);
        if (reset) {
            this.preTickPose.resetOrigin((Vector3fc)newOrigin);
        }
        this.origin = newOrigin;
    }

    public void setRotationY(float rotationY) {
        this.rotationY = rotationY % ((float)Math.PI * 2);
    }

    @Override
    @Nullable
    public class_1657 getMcPlayer() {
        return VisorClientImpl.MC.field_1724;
    }

    public class_1268 getActiveInteractHand() {
        return this.activeHand == ControllerHand.MAIN ? class_1268.field_5808 : class_1268.field_5810;
    }

    @Override
    @NotNull
    public PoseElement getRotationElement(@NotNull PoseDataType stage) {
        PoseDataImpl playerPose = this.getPoseData(stage);
        return switch (VRClientSettings.getRotationMode()) {
            case RotationMode.MAIN_HAND -> playerPose.getController(ControllerHand.MAIN);
            case RotationMode.HMD -> playerPose.getHmd();
            default -> playerPose.getController(ControllerHand.OFFHAND);
        };
    }

    @Override
    @NotNull
    public PoseDataImpl getPoseData(@NotNull PoseDataType stage) {
        return switch (stage) {
            case PoseDataType.PRE_TICK -> this.preTickPose;
            case PoseDataType.POST_TICK -> this.postTickPose;
            case PoseDataType.RENDER -> this.renderPose;
            default -> this.roomPose;
        };
    }

    @Override
    @NotNull
    public ControllerRaw getControllerRaw(@NotNull ControllerHand hand) {
        return ClientContext.rawPoseHandler.getControllerData(hand);
    }

    @Override
    @NotNull
    public HmdRaw getHmdRaw() {
        return ClientContext.rawPoseHandler.getHmdData();
    }

    public String toString() {
        return "VRClientPlayer:\n    origin: %s\n    rotation: %.3f\n    scale: %.3f\n    room pose: %s\n    preTick pose: %s\n    postTick pose: %s\n    render pose: %s".formatted(this.origin, Float.valueOf(this.rotationY), Float.valueOf(this.worldScale), this.roomPose, this.preTickPose, this.postTickPose, this.renderPose);
    }

    public Vector3fc getOrigin() {
        return this.origin;
    }

    @Override
    public float getWorldScale() {
        return this.worldScale;
    }

    public float getRotationY() {
        return this.rotationY;
    }

    @Override
    public ControllerHand getActiveHand() {
        return this.activeHand;
    }

    public Vector2f getMovement() {
        return this.movement;
    }

    public boolean isMoving() {
        return this.moving;
    }

    public void setMoving(boolean moving) {
        this.moving = moving;
    }
}

