/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.core.client.data.raw;

import me.phoenixra.atumvr.api.enums.EyeType;
import me.phoenixra.visor.api.client.data.HmdRaw;
import me.phoenixra.visor.api.common.utils.QuaternionFloatHistory;
import me.phoenixra.visor.api.common.utils.VRMathUtils;
import me.phoenixra.visor.api.common.utils.Vector3fHistory;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class RawHmd
implements HmdRaw {
    private final Matrix4f devicePose = new Matrix4f();
    private final Matrix4f rotation = new Matrix4f();
    private final Matrix4f leftEyePose = new Matrix4f();
    private final Matrix4f rightEyePose = new Matrix4f();
    private final Vector3fHistory positionHistory = new Vector3fHistory(301);
    private final Vector3fHistory pivotHistory = new Vector3fHistory(301);
    private final QuaternionFloatHistory rotationHistory = new QuaternionFloatHistory(301);
    private Vector3fc velocity = new Vector3f(0.0f, 0.0f, 0.0f);
    private Vector3fc angularVelocity = new Vector3f(0.0f, 0.0f, 0.0f);
    private boolean tracking;

    @Override
    public Matrix4fc getDevicePose() {
        return this.devicePose;
    }

    public Matrix4f getDevicePoseMutable() {
        return this.devicePose;
    }

    @Override
    public Matrix4fc getRotation() {
        return this.rotation;
    }

    public Matrix4f getRotationMutable() {
        return this.rotation;
    }

    public Matrix4f getLeftEyePoseMutable() {
        return this.leftEyePose;
    }

    public Matrix4f getRightEyePoseMutable() {
        return this.rightEyePose;
    }

    @Override
    public Vector3f getHeadsetPosition() {
        return this.devicePose.getTranslation(new Vector3f());
    }

    @Override
    public Vector3f getEyePosition(EyeType eye) {
        Matrix4f eyePose = eye == EyeType.LEFT ? this.leftEyePose : this.rightEyePose;
        return eyePose.getTranslation(new Vector3f());
    }

    @Override
    public Matrix4fc getEyeRotation(EyeType eye) {
        Matrix4f eyePose = eye == EyeType.LEFT ? this.leftEyePose : this.rightEyePose;
        return new Matrix4f().rotate((Quaternionfc)eyePose.getNormalizedRotation(new Quaternionf()));
    }

    @Override
    public Vector3f getVector() {
        return this.rotation.transformDirection(VRMathUtils.BACK_VECTOR, new Vector3f());
    }

    @Override
    public Vector3fHistory getPositionHistory() {
        return this.positionHistory;
    }

    @Override
    public Vector3fHistory getPivotHistory() {
        return this.pivotHistory;
    }

    @Override
    public QuaternionFloatHistory getRotationHistory() {
        return this.rotationHistory;
    }

    public Vector3fc getVelocity() {
        return this.velocity;
    }

    public void setVelocity(Vector3fc velocity) {
        this.velocity = velocity;
    }

    public Vector3fc getAngularVelocity() {
        return this.angularVelocity;
    }

    public void setAngularVelocity(Vector3fc angularVelocity) {
        this.angularVelocity = angularVelocity;
    }

    public boolean isTracking() {
        return this.tracking;
    }

    public void setTracking(boolean tracking) {
        this.tracking = tracking;
    }
}

